/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.partition;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.paimon.manifest.PartitionEntry;
import org.apache.paimon.operation.FileStoreScan;
import org.apache.paimon.partition.PartitionExpireStrategy;
import org.apache.paimon.types.RowType;

public class PartitionUpdateTimeExpireStrategy
extends PartitionExpireStrategy {
    public PartitionUpdateTimeExpireStrategy(RowType partitionType) {
        super(partitionType);
    }

    @Override
    public List<PartitionEntry> selectExpiredPartitions(FileStoreScan scan, LocalDateTime expirationTime) {
        long expirationMilli = expirationTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        return scan.readPartitionEntries().stream().filter(partitionEntry -> expirationMilli > partitionEntry.lastFileCreationTime()).collect(Collectors.toList());
    }
}

