/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.mergetree.compact.MergeFunction;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;
import org.apache.paimon.options.Options;

public class FirstRowMergeFunction
implements MergeFunction<KeyValue> {
    private KeyValue first;
    public boolean containsHighLevel;
    private final boolean ignoreDelete;

    protected FirstRowMergeFunction(boolean ignoreDelete) {
        this.ignoreDelete = ignoreDelete;
    }

    @Override
    public void reset() {
        this.first = null;
        this.containsHighLevel = false;
    }

    @Override
    public void add(KeyValue kv) {
        if (kv.valueKind().isRetract()) {
            if (this.ignoreDelete) {
                return;
            }
            throw new IllegalArgumentException("By default, First row merge engine can not accept DELETE/UPDATE_BEFORE records.\nYou can config 'first-row.ignore-delete' to ignore the DELETE/UPDATE_BEFORE records.");
        }
        if (this.first == null) {
            this.first = kv;
        }
        if (kv.level() > 0) {
            this.containsHighLevel = true;
        }
    }

    @Override
    public KeyValue getResult() {
        return this.first;
    }

    @Override
    public boolean requireCopy() {
        return true;
    }

    public static MergeFunctionFactory<KeyValue> factory(Options options) {
        return new Factory((Boolean)options.get(CoreOptions.IGNORE_DELETE));
    }

    private static class Factory
    implements MergeFunctionFactory<KeyValue> {
        private static final long serialVersionUID = 1L;
        private final boolean ignoreDelete;

        public Factory(boolean ignoreDelete) {
            this.ignoreDelete = ignoreDelete;
        }

        @Override
        public MergeFunction<KeyValue> create(@Nullable int[][] projection) {
            return new FirstRowMergeFunction(this.ignoreDelete);
        }
    }
}

