/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.paimon.compact.CompactUnit;
import org.apache.paimon.deletionvectors.DeletionVectorsMaintainer;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.RecordLevelExpire;
import org.apache.paimon.mergetree.LevelSortedRun;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface CompactStrategy {
    public static final Logger LOG = LoggerFactory.getLogger(CompactStrategy.class);

    public Optional<CompactUnit> pick(int var1, List<LevelSortedRun> var2);

    public static Optional<CompactUnit> pickFullCompaction(int numLevels, List<LevelSortedRun> runs, @Nullable RecordLevelExpire recordLevelExpire, @Nullable DeletionVectorsMaintainer dvMaintainer, boolean forceRewriteAllFiles) {
        int maxLevel = numLevels - 1;
        if (runs.isEmpty()) {
            return Optional.empty();
        }
        if (runs.size() == 1 && runs.get(0).level() == maxLevel) {
            ArrayList<DataFileMeta> filesToBeCompacted = new ArrayList<DataFileMeta>();
            for (DataFileMeta file : runs.get(0).run().files()) {
                if (forceRewriteAllFiles) {
                    filesToBeCompacted.add(file);
                    continue;
                }
                if (recordLevelExpire != null && recordLevelExpire.isExpireFile(file)) {
                    filesToBeCompacted.add(file);
                    continue;
                }
                if (dvMaintainer == null || !dvMaintainer.deletionVectorOf(file.fileName()).isPresent()) continue;
                filesToBeCompacted.add(file);
            }
            if (filesToBeCompacted.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(CompactUnit.fromFiles(maxLevel, filesToBeCompacted, true));
        }
        return Optional.of(CompactUnit.fromLevelRuns(maxLevel, runs));
    }
}

