/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.catalog;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.Public;

@Public
public interface Database {
    public String name();

    public Map<String, String> options();

    public Optional<String> comment();

    public static Database of(String name, Map<String, String> options, @Nullable String comment) {
        return new DatabaseImpl(name, options, comment);
    }

    public static Database of(String name) {
        return new DatabaseImpl(name, new HashMap<String, String>(), null);
    }

    public static class DatabaseImpl
    implements Database {
        private final String name;
        private final Map<String, String> options;
        @Nullable
        private final String comment;

        public DatabaseImpl(String name, Map<String, String> options, @Nullable String comment) {
            this.name = name;
            this.options = options;
            this.comment = comment;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Map<String, String> options() {
            return this.options;
        }

        @Override
        public Optional<String> comment() {
            return Optional.ofNullable(this.comment);
        }
    }
}

