/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.po;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class UserPO {
    private Long userId;
    private String userName;
    private Long metalakeId;
    private String auditInfo;
    private Long currentVersion;
    private Long lastVersion;
    private Long deletedAt;

    public Long getUserId() {
        return this.userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public Long getMetalakeId() {
        return this.metalakeId;
    }

    public String getAuditInfo() {
        return this.auditInfo;
    }

    public Long getCurrentVersion() {
        return this.currentVersion;
    }

    public Long getLastVersion() {
        return this.lastVersion;
    }

    public Long getDeletedAt() {
        return this.deletedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserPO)) {
            return false;
        }
        UserPO tablePO = (UserPO)o;
        return Objects.equal((Object)this.getUserId(), (Object)tablePO.getUserId()) && Objects.equal((Object)this.getUserName(), (Object)tablePO.getUserName()) && Objects.equal((Object)this.getMetalakeId(), (Object)tablePO.getMetalakeId()) && Objects.equal((Object)this.getAuditInfo(), (Object)tablePO.getAuditInfo()) && Objects.equal((Object)this.getCurrentVersion(), (Object)tablePO.getCurrentVersion()) && Objects.equal((Object)this.getLastVersion(), (Object)tablePO.getLastVersion()) && Objects.equal((Object)this.getDeletedAt(), (Object)tablePO.getDeletedAt());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getUserId(), this.getUserName(), this.getMetalakeId(), this.getAuditInfo(), this.getCurrentVersion(), this.getLastVersion(), this.getDeletedAt()});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final UserPO userPO = new UserPO();

        private Builder() {
        }

        public Builder withUserId(Long userId) {
            this.userPO.userId = userId;
            return this;
        }

        public Builder withUserName(String userName) {
            this.userPO.userName = userName;
            return this;
        }

        public Builder withMetalakeId(Long metalakeId) {
            this.userPO.metalakeId = metalakeId;
            return this;
        }

        public Builder withAuditInfo(String auditInfo) {
            this.userPO.auditInfo = auditInfo;
            return this;
        }

        public Builder withCurrentVersion(Long currentVersion) {
            this.userPO.currentVersion = currentVersion;
            return this;
        }

        public Builder withLastVersion(Long lastVersion) {
            this.userPO.lastVersion = lastVersion;
            return this;
        }

        public Builder withDeletedAt(Long deletedAt) {
            this.userPO.deletedAt = deletedAt;
            return this;
        }

        private void validate() {
            Preconditions.checkArgument((this.userPO.userId != null ? 1 : 0) != 0, (Object)"User id is required");
            Preconditions.checkArgument((this.userPO.userName != null ? 1 : 0) != 0, (Object)"User name is required");
            Preconditions.checkArgument((this.userPO.metalakeId != null ? 1 : 0) != 0, (Object)"Metalake id is required");
            Preconditions.checkArgument((this.userPO.auditInfo != null ? 1 : 0) != 0, (Object)"Audit info is required");
            Preconditions.checkArgument((this.userPO.currentVersion != null ? 1 : 0) != 0, (Object)"Current version is required");
            Preconditions.checkArgument((this.userPO.lastVersion != null ? 1 : 0) != 0, (Object)"Last version is required");
            Preconditions.checkArgument((this.userPO.deletedAt != null ? 1 : 0) != 0, (Object)"Deleted at is required");
        }

        public UserPO build() {
            this.validate();
            return this.userPO;
        }
    }
}

