/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.connector;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.gravitino.Audit;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.CatalogProvider;
import org.apache.gravitino.annotation.Evolving;
import org.apache.gravitino.connector.CatalogOperations;
import org.apache.gravitino.connector.HasPropertyMetadata;
import org.apache.gravitino.connector.OperationsProxy;
import org.apache.gravitino.connector.PropertiesMetadata;
import org.apache.gravitino.connector.ProxyPlugin;
import org.apache.gravitino.connector.authorization.AuthorizationPlugin;
import org.apache.gravitino.connector.authorization.BaseAuthorization;
import org.apache.gravitino.connector.capability.Capability;
import org.apache.gravitino.credential.CatalogCredentialManager;
import org.apache.gravitino.meta.CatalogEntity;
import org.apache.gravitino.utils.IsolatedClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Evolving
public abstract class BaseCatalog<T extends BaseCatalog>
implements Catalog,
CatalogProvider,
HasPropertyMetadata,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(BaseCatalog.class);
    public static final String CATALOG_OPERATION_IMPL = "ops-impl";
    private volatile AuthorizationPlugin authorizationPlugin;
    private CatalogEntity entity;
    private Map<String, String> conf;
    private volatile CatalogOperations ops;
    private volatile Capability capability;
    private volatile Map<String, String> properties;
    private volatile CatalogCredentialManager catalogCredentialManager;
    private static String ENTITY_IS_NOT_SET = "entity is not set";
    public static final String CATALOG_BYPASS_PREFIX = "gravitino.bypass.";

    @Evolving
    protected abstract CatalogOperations newOps(Map<String, String> var1);

    @Evolving
    protected Capability newCapability() {
        return Capability.DEFAULT;
    }

    @Evolving
    protected Optional<ProxyPlugin> newProxyPlugin(Map<String, String> config) {
        return Optional.empty();
    }

    @Override
    public PropertiesMetadata tablePropertiesMetadata() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("The catalog does not support table properties metadata");
    }

    @Override
    public PropertiesMetadata catalogPropertiesMetadata() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("The catalog does not support catalog properties metadata");
    }

    @Override
    public PropertiesMetadata schemaPropertiesMetadata() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("The catalog does not support schema properties metadata");
    }

    @Override
    public PropertiesMetadata filesetPropertiesMetadata() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("The catalog does not support fileset properties metadata");
    }

    @Override
    public PropertiesMetadata topicPropertiesMetadata() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("The catalog does not support topic properties metadata");
    }

    @Override
    public PropertiesMetadata modelPropertiesMetadata() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("The catalog does not support model properties metadata");
    }

    @Override
    public PropertiesMetadata modelVersionPropertiesMetadata() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("The catalog does not support model version properties metadata");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CatalogOperations ops() {
        if (this.ops == null) {
            BaseCatalog baseCatalog = this;
            synchronized (baseCatalog) {
                if (this.ops == null) {
                    Preconditions.checkArgument((this.entity != null && this.conf != null ? 1 : 0) != 0, (Object)"entity and conf must be set before calling ops()");
                    CatalogOperations newOps = this.createOps(this.conf);
                    newOps.initialize(this.conf, this.entity.toCatalogInfo(), this);
                    this.ops = this.newProxyPlugin(this.conf).map(proxyPlugin -> this.asProxyOps(newOps, (ProxyPlugin)proxyPlugin)).orElse(newOps);
                }
            }
        }
        return this.ops;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorizationPlugin getAuthorizationPlugin() {
        if (this.authorizationPlugin == null) {
            BaseCatalog baseCatalog = this;
            synchronized (baseCatalog) {
                if (this.authorizationPlugin == null) {
                    return null;
                }
            }
        }
        return this.authorizationPlugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initAuthorizationPluginInstance(IsolatedClassLoader classLoader) {
        if (this.authorizationPlugin == null) {
            BaseCatalog baseCatalog = this;
            synchronized (baseCatalog) {
                if (this.authorizationPlugin == null) {
                    String authorizationProvider = (String)this.catalogPropertiesMetadata().getOrDefault(this.conf, "authorization-provider");
                    if (authorizationProvider == null) {
                        LOG.info("Authorization provider is not set!");
                        return;
                    }
                    try (BaseAuthorization<?> authorization = BaseAuthorization.createAuthorization(classLoader, authorizationProvider);){
                        this.authorizationPlugin = classLoader.withClassLoader(cl -> authorization.newPlugin(this.entity.namespace().level(0), this.provider(), this.conf));
                    }
                    catch (Exception e) {
                        LOG.error("Failed to load authorization with class loader", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.ops != null) {
            this.ops.close();
            this.ops = null;
        }
        if (this.authorizationPlugin != null) {
            this.authorizationPlugin.close();
            this.authorizationPlugin = null;
        }
        if (this.catalogCredentialManager != null) {
            this.catalogCredentialManager.close();
            this.catalogCredentialManager = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Capability capability() {
        if (this.capability == null) {
            BaseCatalog baseCatalog = this;
            synchronized (baseCatalog) {
                if (this.capability == null) {
                    this.capability = this.newCapability();
                }
            }
        }
        return this.capability;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CatalogCredentialManager catalogCredentialManager() {
        if (this.catalogCredentialManager == null) {
            BaseCatalog baseCatalog = this;
            synchronized (baseCatalog) {
                if (this.catalogCredentialManager == null) {
                    this.catalogCredentialManager = new CatalogCredentialManager(this.name(), this.properties());
                }
            }
        }
        return this.catalogCredentialManager;
    }

    private CatalogOperations createOps(Map<String, String> conf) {
        String customCatalogOperationClass = conf.get(CATALOG_OPERATION_IMPL);
        return Optional.ofNullable(customCatalogOperationClass).map(className -> this.loadCustomOps((String)className)).orElse(this.newOps(conf));
    }

    private CatalogOperations loadCustomOps(String className) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            return (CatalogOperations)Class.forName(className, true, classLoader).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOG.error("Failed to load custom catalog operations, {}", (Object)className, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public T withCatalogEntity(CatalogEntity entity) {
        this.entity = entity;
        return (T)this;
    }

    public T withCatalogConf(Map<String, String> conf) {
        this.conf = conf;
        return (T)this;
    }

    public CatalogEntity entity() {
        return this.entity;
    }

    public String name() {
        Preconditions.checkArgument((this.entity != null ? 1 : 0) != 0, (Object)ENTITY_IS_NOT_SET);
        return this.entity.name();
    }

    public Catalog.Type type() {
        Preconditions.checkArgument((this.entity != null ? 1 : 0) != 0, (Object)ENTITY_IS_NOT_SET);
        return this.entity.getType();
    }

    public String provider() {
        Preconditions.checkArgument((this.entity != null ? 1 : 0) != 0, (Object)ENTITY_IS_NOT_SET);
        return this.entity.getProvider();
    }

    public String comment() {
        Preconditions.checkArgument((this.entity != null ? 1 : 0) != 0, (Object)ENTITY_IS_NOT_SET);
        return this.entity.getComment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> properties() {
        if (this.properties == null) {
            BaseCatalog baseCatalog = this;
            synchronized (baseCatalog) {
                if (this.properties == null) {
                    Preconditions.checkArgument((this.entity != null ? 1 : 0) != 0, (Object)ENTITY_IS_NOT_SET);
                    HashMap tempProperties = Maps.newHashMap(this.entity.getProperties());
                    tempProperties.entrySet().removeIf(entry -> this.catalogPropertiesMetadata().isHiddenProperty((String)entry.getKey()));
                    tempProperties.putIfAbsent("in-use", this.catalogPropertiesMetadata().getDefaultValue("in-use").toString());
                    this.properties = tempProperties;
                }
            }
        }
        return this.properties;
    }

    public Audit auditInfo() {
        Preconditions.checkArgument((this.entity != null ? 1 : 0) != 0, (Object)ENTITY_IS_NOT_SET);
        return this.entity.auditInfo();
    }

    private CatalogOperations asProxyOps(CatalogOperations ops, ProxyPlugin plugin) {
        return OperationsProxy.createProxy(ops, plugin);
    }
}

