/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.Schema;
import org.apache.gravitino.SchemaChange;
import org.apache.gravitino.StringIdentifier;
import org.apache.gravitino.connector.BaseSchema;
import org.apache.gravitino.connector.SupportsSchemas;
import org.apache.gravitino.exceptions.AlreadyExistsException;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NonEmptyEntityException;
import org.apache.gravitino.exceptions.NonEmptySchemaException;
import org.apache.gravitino.exceptions.SchemaAlreadyExistsException;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.SchemaEntity;
import org.apache.gravitino.utils.PrincipalUtils;

public abstract class ManagedSchemaOperations
implements SupportsSchemas {
    private static final String SCHEMA_DOES_NOT_EXIST_MSG = "Schema %s does not exist";

    protected abstract EntityStore store();

    @Override
    public NameIdentifier[] listSchemas(Namespace namespace) throws NoSuchCatalogException {
        try {
            List<SchemaEntity> schemas = this.store().list(namespace, SchemaEntity.class, Entity.EntityType.SCHEMA);
            return (NameIdentifier[])schemas.stream().map(s -> NameIdentifier.of((Namespace)namespace, (String)s.name())).toArray(NameIdentifier[]::new);
        }
        catch (NoSuchEntityException e) {
            throw new NoSuchCatalogException((Throwable)e, "Catalog %s does not exist", new Object[]{namespace});
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to list schemas under namespace " + String.valueOf(namespace), ioe);
        }
    }

    @Override
    public Schema createSchema(NameIdentifier ident, String comment, Map<String, String> properties) throws NoSuchCatalogException, SchemaAlreadyExistsException {
        try {
            if (this.store().exists(ident, Entity.EntityType.SCHEMA)) {
                throw new SchemaAlreadyExistsException("Schema %s already exists", new Object[]{ident});
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to check if schema " + String.valueOf(ident) + " exists", ioe);
        }
        StringIdentifier stringId = StringIdentifier.fromProperties(properties);
        Preconditions.checkArgument((stringId != null ? 1 : 0) != 0, (Object)"Property String identifier should not be null");
        SchemaEntity schemaEntity = SchemaEntity.builder().withName(ident.name()).withId(stringId.id()).withNamespace(ident.namespace()).withComment(comment).withProperties(properties).withAuditInfo(AuditInfo.builder().withCreator(PrincipalUtils.getCurrentPrincipal().getName()).withCreateTime(Instant.now()).build()).build();
        try {
            this.store().put(schemaEntity, true);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to create schema " + String.valueOf(ident), ioe);
        }
        catch (NoSuchEntityException e) {
            throw new NoSuchCatalogException((Throwable)e, "Catalog %s does not exist", new Object[]{ident.namespace()});
        }
        return ((ManagedSchema.Builder)((ManagedSchema.Builder)((ManagedSchema.Builder)((ManagedSchema.Builder)ManagedSchema.builder().withName(ident.name())).withComment(comment)).withProperties(schemaEntity.properties())).withAuditInfo(schemaEntity.auditInfo())).build();
    }

    @Override
    public Schema loadSchema(NameIdentifier ident) throws NoSuchSchemaException {
        try {
            SchemaEntity schemaEntity = this.store().get(ident, Entity.EntityType.SCHEMA, SchemaEntity.class);
            return ((ManagedSchema.Builder)((ManagedSchema.Builder)((ManagedSchema.Builder)((ManagedSchema.Builder)ManagedSchema.builder().withName(ident.name())).withComment(schemaEntity.comment())).withProperties(schemaEntity.properties())).withAuditInfo(schemaEntity.auditInfo())).build();
        }
        catch (NoSuchEntityException exception) {
            throw new NoSuchSchemaException((Throwable)exception, SCHEMA_DOES_NOT_EXIST_MSG, new Object[]{ident});
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to load schema " + String.valueOf(ident), ioe);
        }
    }

    @Override
    public Schema alterSchema(NameIdentifier ident, SchemaChange ... changes) throws NoSuchSchemaException {
        try {
            SchemaEntity entity = this.store().update(ident, SchemaEntity.class, Entity.EntityType.SCHEMA, schemaEntity -> this.updateSchemaEntity(ident, (SchemaEntity)schemaEntity, changes));
            return ((ManagedSchema.Builder)((ManagedSchema.Builder)((ManagedSchema.Builder)((ManagedSchema.Builder)ManagedSchema.builder().withName(ident.name())).withComment(entity.comment())).withProperties(entity.properties())).withAuditInfo(entity.auditInfo())).build();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to update schema " + String.valueOf(ident), ioe);
        }
        catch (NoSuchEntityException nsee) {
            throw new NoSuchSchemaException((Throwable)nsee, SCHEMA_DOES_NOT_EXIST_MSG, new Object[]{ident});
        }
        catch (AlreadyExistsException aee) {
            throw new RuntimeException("Schema with the same name " + ident.name() + " already exists, this is unexpected because schema doesn't support rename", aee);
        }
    }

    @Override
    public boolean dropSchema(NameIdentifier ident, boolean cascade) throws NonEmptySchemaException {
        try {
            return this.store().delete(ident, Entity.EntityType.SCHEMA, cascade);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to delete schema " + String.valueOf(ident), ioe);
        }
        catch (NonEmptyEntityException neee) {
            throw new NonEmptySchemaException((Throwable)neee, "Schema %s is not empty", new Object[]{ident});
        }
        catch (NoSuchEntityException nsee) {
            return false;
        }
    }

    private SchemaEntity updateSchemaEntity(NameIdentifier ident, SchemaEntity schemaEntity, SchemaChange ... changes) {
        HashMap props = schemaEntity.properties() == null ? Maps.newHashMap() : Maps.newHashMap(schemaEntity.properties());
        for (SchemaChange change : changes) {
            if (change instanceof SchemaChange.SetProperty) {
                SchemaChange.SetProperty setProperty = (SchemaChange.SetProperty)change;
                props.put(setProperty.getProperty(), setProperty.getValue());
                continue;
            }
            if (change instanceof SchemaChange.RemoveProperty) {
                SchemaChange.RemoveProperty removeProperty = (SchemaChange.RemoveProperty)change;
                props.remove(removeProperty.getProperty());
                continue;
            }
            throw new IllegalArgumentException("Unsupported schema change: " + change.getClass().getSimpleName());
        }
        return SchemaEntity.builder().withName(schemaEntity.name()).withNamespace(ident.namespace()).withId(schemaEntity.id()).withComment(schemaEntity.comment()).withProperties(props).withAuditInfo(AuditInfo.builder().withCreator(schemaEntity.auditInfo().creator()).withCreateTime(schemaEntity.auditInfo().createTime()).withLastModifier(PrincipalUtils.getCurrentPrincipal().getName()).withLastModifiedTime(Instant.now()).build()).build();
    }

    public static class ManagedSchema
    extends BaseSchema {
        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BaseSchema.BaseSchemaBuilder<Builder, ManagedSchema> {
            private Builder() {
            }

            @Override
            protected ManagedSchema internalBuild() {
                ManagedSchema schema = new ManagedSchema();
                schema.name = this.name;
                schema.comment = this.comment;
                schema.properties = this.properties;
                schema.auditInfo = this.auditInfo;
                return schema;
            }
        }
    }
}

