/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerDynamicEditException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedLeafQueueConfig;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedQueueManagementPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueManagementChange;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedParentQueue
extends AbstractManagedParentQueue {
    private boolean shouldFailAutoCreationWhenGuaranteedCapacityExceeded = this.csContext.getConfiguration().getShouldFailAutoQueueCreationWhenGuaranteedCapacityExceeded(this.getQueuePath());
    private static final Logger LOG = LoggerFactory.getLogger(ManagedParentQueue.class);

    public ManagedParentQueue(CapacitySchedulerContext cs, String queueName, CSQueue parent, CSQueue old) throws IOException {
        super(cs, queueName, parent, old);
        this.leafQueueTemplate = this.initializeLeafQueueConfigs().build();
        StringBuffer queueInfo = new StringBuffer();
        queueInfo.append("Created Managed Parent Queue: ").append(queueName).append("]\nwith capacity: [").append(super.getCapacity()).append("]\nwith max capacity: [").append(super.getMaximumCapacity()).append("].");
        LOG.info(queueInfo.toString());
        this.initializeQueueManagementPolicy();
    }

    @Override
    public void reinitialize(CSQueue newlyParsedQueue, Resource clusterResource) throws IOException {
        try {
            this.writeLock.lock();
            this.validate(newlyParsedQueue);
            this.shouldFailAutoCreationWhenGuaranteedCapacityExceeded = this.csContext.getConfiguration().getShouldFailAutoQueueCreationWhenGuaranteedCapacityExceeded(this.getQueuePath());
            if (this.shouldFailAutoCreationWhenGuaranteedCapacityExceeded) {
                float childCap = this.sumOfChildCapacities();
                if (this.getCapacity() < childCap) {
                    throw new IOException("Total of Auto Created leaf queues guaranteed capacity : " + childCap + " exceeds Parent queue's " + this.getQueuePath() + " guaranteed capacity " + this.getCapacity() + ".Cannot enforce policy to auto create queues beyond parent queue's capacity");
                }
            }
            this.leafQueueTemplate = this.initializeLeafQueueConfigs().build();
            super.reinitialize(newlyParsedQueue, clusterResource);
            for (CSQueue res : this.getChildQueues()) {
                res.reinitialize(res, clusterResource);
            }
            this.reinitializeQueueManagementPolicy();
            List<QueueManagementChange> queueManagementChanges = this.queueManagementPolicy.computeQueueManagementChanges();
            this.validateAndApplyQueueManagementChanges(queueManagementChanges);
            StringBuffer queueInfo = new StringBuffer();
            queueInfo.append("Reinitialized Managed Parent Queue: ").append(this.queueName).append("]\nwith capacity: [").append(super.getCapacity()).append("]\nwith max capacity: [").append(super.getMaximumCapacity()).append("].");
            LOG.info(queueInfo.toString());
        }
        catch (YarnException ye) {
            LOG.error("Exception while computing policy changes for leaf queue : " + this.getQueueName(), (Throwable)ye);
            throw new IOException(ye);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void initializeQueueManagementPolicy() {
        this.queueManagementPolicy = this.csContext.getConfiguration().getAutoCreatedQueueManagementPolicyClass(this.getQueuePath());
        this.queueManagementPolicy.init(this.csContext, this);
    }

    private void reinitializeQueueManagementPolicy() {
        AutoCreatedQueueManagementPolicy managementPolicy = this.csContext.getConfiguration().getAutoCreatedQueueManagementPolicyClass(this.getQueuePath());
        if (!managementPolicy.getClass().equals(this.queueManagementPolicy.getClass())) {
            this.queueManagementPolicy = managementPolicy;
            this.queueManagementPolicy.init(this.csContext, this);
        } else {
            this.queueManagementPolicy.reinitialize(this.csContext, this);
        }
    }

    protected AutoCreatedLeafQueueConfig.Builder initializeLeafQueueConfigs() {
        AutoCreatedLeafQueueConfig.Builder builder = new AutoCreatedLeafQueueConfig.Builder();
        String leafQueueTemplateConfPrefix = this.getLeafQueueConfigPrefix(this.csContext.getConfiguration());
        builder.configuration(super.initializeLeafQueueConfigs(leafQueueTemplateConfPrefix));
        QueueCapacities queueCapacities = new QueueCapacities(false);
        CSQueueUtils.loadUpdateAndCheckCapacities(this.csContext.getConfiguration().getAutoCreatedQueueTemplateConfPrefix(this.getQueuePath()), this.csContext.getConfiguration(), queueCapacities, this.getQueueCapacities());
        builder.capacities(queueCapacities);
        return builder;
    }

    protected void validate(CSQueue newlyParsedQueue) throws IOException {
        if (!(newlyParsedQueue instanceof ManagedParentQueue) || !newlyParsedQueue.getQueuePath().equals(this.getQueuePath())) {
            throw new IOException("Trying to reinitialize " + this.getQueuePath() + " from " + newlyParsedQueue.getQueuePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChildQueue(CSQueue childQueue) throws SchedulerDynamicEditException, IOException {
        try {
            this.writeLock.lock();
            if (childQueue == null || !(childQueue instanceof AutoCreatedLeafQueue)) {
                throw new SchedulerDynamicEditException("Expected child queue to be an instance of AutoCreatedLeafQueue");
            }
            CapacitySchedulerConfiguration conf = this.csContext.getConfiguration();
            ManagedParentQueue parentQueue = (ManagedParentQueue)childQueue.getParent();
            String leafQueueName = childQueue.getQueueName();
            int maxQueues = conf.getAutoCreatedQueuesMaxChildQueuesLimit(parentQueue.getQueuePath());
            if (parentQueue.getChildQueues().size() >= maxQueues) {
                throw new SchedulerDynamicEditException("Cannot auto create leaf queue " + leafQueueName + ".Max Child Queue limit exceeded which is configured as : " + maxQueues + " and number of child queues is : " + parentQueue.getChildQueues().size());
            }
            if (this.shouldFailAutoCreationWhenGuaranteedCapacityExceeded && this.getLeafQueueTemplate().getQueueCapacities().getAbsoluteCapacity() + parentQueue.sumOfChildAbsCapacities() > parentQueue.getAbsoluteCapacity()) {
                throw new SchedulerDynamicEditException("Cannot auto create leaf queue " + leafQueueName + ". Child queues capacities have reached parent queue : " + parentQueue.getQueuePath() + "'s guaranteed capacity");
            }
            AutoCreatedLeafQueue leafQueue = (AutoCreatedLeafQueue)childQueue;
            super.addChildQueue(leafQueue);
            AutoCreatedLeafQueueConfig initialLeafQueueTemplate = this.queueManagementPolicy.getInitialLeafQueueConfiguration(leafQueue);
            leafQueue.reinitializeFromTemplate(initialLeafQueueTemplate);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FiCaSchedulerApp> getScheduleableApplications() {
        try {
            this.readLock.lock();
            ArrayList<FiCaSchedulerApp> apps = new ArrayList<FiCaSchedulerApp>();
            for (CSQueue childQueue : this.getChildQueues()) {
                apps.addAll(((LeafQueue)childQueue).getApplications());
            }
            List list = Collections.unmodifiableList(apps);
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FiCaSchedulerApp> getPendingApplications() {
        try {
            this.readLock.lock();
            ArrayList<FiCaSchedulerApp> apps = new ArrayList<FiCaSchedulerApp>();
            for (CSQueue childQueue : this.getChildQueues()) {
                apps.addAll(((LeafQueue)childQueue).getPendingApplications());
            }
            List list = Collections.unmodifiableList(apps);
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FiCaSchedulerApp> getAllApplications() {
        try {
            this.readLock.lock();
            ArrayList<FiCaSchedulerApp> apps = new ArrayList<FiCaSchedulerApp>();
            for (CSQueue childQueue : this.getChildQueues()) {
                apps.addAll(((LeafQueue)childQueue).getAllApplications());
            }
            List list = Collections.unmodifiableList(apps);
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String getLeafQueueConfigPrefix(CapacitySchedulerConfiguration conf) {
        return "yarn.scheduler.capacity." + conf.getAutoCreatedQueueTemplateConfPrefix(this.getQueuePath());
    }

    public boolean shouldFailAutoCreationWhenGuaranteedCapacityExceeded() {
        return this.shouldFailAutoCreationWhenGuaranteedCapacityExceeded;
    }

    public void validateAndApplyQueueManagementChanges(List<QueueManagementChange> queueManagementChanges) throws IOException, SchedulerDynamicEditException {
        try {
            this.writeLock.lock();
            this.validateQueueManagementChanges(queueManagementChanges);
            this.applyQueueManagementChanges(queueManagementChanges);
            AutoCreatedQueueManagementPolicy policy = this.getAutoCreatedQueueManagementPolicy();
            policy.commitQueueManagementChanges(queueManagementChanges);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void validateQueueManagementChanges(List<QueueManagementChange> queueManagementChanges) throws SchedulerDynamicEditException {
        for (QueueManagementChange queueManagementChange : queueManagementChanges) {
            CSQueue childQueue = queueManagementChange.getQueue();
            if (!(childQueue instanceof AutoCreatedLeafQueue)) {
                throw new SchedulerDynamicEditException("queue should be AutoCreatedLeafQueue. Found " + childQueue.getClass());
            }
            if (!AbstractManagedParentQueue.class.isAssignableFrom(childQueue.getParent().getClass())) {
                LOG.error("Queue " + this.getQueueName() + " is not an instance of PlanQueue or ManagedParentQueue. Ignoring update " + queueManagementChanges);
                throw new SchedulerDynamicEditException("Queue " + this.getQueueName() + " is not a AutoEnabledParentQueue. Ignoring update " + queueManagementChanges);
            }
            switch (queueManagementChange.getQueueAction()) {
                case UPDATE_QUEUE: {
                    AutoCreatedLeafQueueConfig template = queueManagementChange.getUpdatedQueueTemplate();
                    ((AutoCreatedLeafQueue)childQueue).validateConfigurations(template);
                }
            }
        }
    }

    private void applyQueueManagementChanges(List<QueueManagementChange> queueManagementChanges) throws SchedulerDynamicEditException, IOException {
        for (QueueManagementChange queueManagementChange : queueManagementChanges) {
            switch (queueManagementChange.getQueueAction()) {
                case UPDATE_QUEUE: {
                    AutoCreatedLeafQueue childQueueToBeUpdated = (AutoCreatedLeafQueue)queueManagementChange.getQueue();
                    childQueueToBeUpdated.reinitializeFromTemplate(queueManagementChange.getUpdatedQueueTemplate());
                }
            }
        }
    }

    public CapacitySchedulerConfiguration getLeafQueueConfigs(String leafQueueName) {
        return this.getLeafQueueConfigs(this.getLeafQueueTemplate().getLeafQueueConfigs(), leafQueueName);
    }

    public CapacitySchedulerConfiguration getLeafQueueConfigs(CapacitySchedulerConfiguration templateConfig, String leafQueueName) {
        CapacitySchedulerConfiguration leafQueueConfigTemplate = new CapacitySchedulerConfiguration(new Configuration(false), false);
        Iterator iterator = templateConfig.iterator();
        while (iterator.hasNext()) {
            Map.Entry confKeyValuePair = (Map.Entry)iterator.next();
            String name = ((String)confKeyValuePair.getKey()).replaceFirst("leaf-queue-template", leafQueueName);
            leafQueueConfigTemplate.set(name, (String)confKeyValuePair.getValue());
        }
        return leafQueueConfigTemplate;
    }
}

