/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.utils.RoaringBitmap32;

public class BitSliceIndexRoaringBitmap {
    public static final byte VERSION_1 = 1;
    public static final BitSliceIndexRoaringBitmap EMPTY = new BitSliceIndexRoaringBitmap(0L, 0L, new RoaringBitmap32(), new RoaringBitmap32[0]);
    private final long min;
    private final long max;
    private final RoaringBitmap32 ebm;
    private final RoaringBitmap32[] slices;

    private BitSliceIndexRoaringBitmap(long min, long max, RoaringBitmap32 ebm, RoaringBitmap32[] slices) {
        this.min = min;
        this.max = max;
        this.ebm = ebm;
        this.slices = slices;
    }

    public RoaringBitmap32 eq(long predicate) {
        return this.compare(Operation.EQ, predicate, null);
    }

    public RoaringBitmap32 lt(long predicate) {
        return this.compare(Operation.LT, predicate, null);
    }

    public RoaringBitmap32 lte(long predicate) {
        return this.compare(Operation.LTE, predicate, null);
    }

    public RoaringBitmap32 gt(long predicate) {
        return this.compare(Operation.GT, predicate, null);
    }

    public RoaringBitmap32 gte(long predicate) {
        return this.compare(Operation.GTE, predicate, null);
    }

    public RoaringBitmap32 isNotNull() {
        return this.ebm.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BitSliceIndexRoaringBitmap that = (BitSliceIndexRoaringBitmap)o;
        return this.min == that.min && Objects.equals(this.ebm, that.ebm) && Arrays.equals(this.slices, that.slices);
    }

    private RoaringBitmap32 compare(Operation operation, long predicate, RoaringBitmap32 foundSet) {
        return this.compareUsingMinMax(operation, predicate, foundSet).orElseGet(() -> this.oNeilCompare(operation, predicate - this.min, foundSet));
    }

    @VisibleForTesting
    protected Optional<RoaringBitmap32> compareUsingMinMax(Operation operation, long predicate, RoaringBitmap32 foundSet) {
        Supplier<Optional> empty = () -> Optional.of(new RoaringBitmap32());
        Supplier<Optional> all = () -> {
            if (foundSet == null) {
                return Optional.of(this.isNotNull());
            }
            return Optional.of(RoaringBitmap32.and(foundSet, this.ebm));
        };
        switch (operation) {
            case EQ: {
                if (this.min == this.max && this.min == predicate) {
                    return all.get();
                }
                if (predicate >= this.min && predicate <= this.max) break;
                return empty.get();
            }
            case NEQ: {
                if (this.min == this.max && this.min == predicate) {
                    return empty.get();
                }
                if (predicate >= this.min && predicate <= this.max) break;
                return all.get();
            }
            case GTE: {
                if (predicate <= this.min) {
                    return all.get();
                }
                if (predicate <= this.max) break;
                return empty.get();
            }
            case GT: {
                if (predicate < this.min) {
                    return all.get();
                }
                if (predicate < this.max) break;
                return empty.get();
            }
            case LTE: {
                if (predicate >= this.max) {
                    return all.get();
                }
                if (predicate >= this.min) break;
                return empty.get();
            }
            case LT: {
                if (predicate > this.max) {
                    return all.get();
                }
                if (predicate > this.min) break;
                return empty.get();
            }
            default: {
                throw new IllegalArgumentException("not support operation: " + (Object)((Object)operation));
            }
        }
        return Optional.empty();
    }

    private RoaringBitmap32 oNeilCompare(Operation operation, long predicate, RoaringBitmap32 foundSet) {
        RoaringBitmap32 fixedFoundSet = foundSet == null ? this.ebm : foundSet;
        RoaringBitmap32 gt = new RoaringBitmap32();
        RoaringBitmap32 lt = new RoaringBitmap32();
        RoaringBitmap32 eq = this.ebm;
        for (int i = this.slices.length - 1; i >= 0; --i) {
            long bit = predicate >> i & 1L;
            if (bit == 1L) {
                lt = RoaringBitmap32.or(lt, RoaringBitmap32.andNot(eq, this.slices[i]));
                eq = RoaringBitmap32.and(eq, this.slices[i]);
                continue;
            }
            gt = RoaringBitmap32.or(gt, RoaringBitmap32.and(eq, this.slices[i]));
            eq = RoaringBitmap32.andNot(eq, this.slices[i]);
        }
        eq = RoaringBitmap32.and(fixedFoundSet, eq);
        switch (operation) {
            case EQ: {
                return eq;
            }
            case NEQ: {
                return RoaringBitmap32.andNot(fixedFoundSet, eq);
            }
            case GT: {
                return RoaringBitmap32.and(gt, fixedFoundSet);
            }
            case LT: {
                return RoaringBitmap32.and(lt, fixedFoundSet);
            }
            case LTE: {
                return RoaringBitmap32.and(RoaringBitmap32.or(lt, eq), fixedFoundSet);
            }
            case GTE: {
                return RoaringBitmap32.and(RoaringBitmap32.or(gt, eq), fixedFoundSet);
            }
        }
        throw new IllegalArgumentException("not support operation: " + (Object)((Object)operation));
    }

    public static BitSliceIndexRoaringBitmap map(DataInput in) throws IOException {
        byte version = in.readByte();
        if (version > 1) {
            throw new RuntimeException(String.format("deserialize bsi index fail, your plugin version is lower than %d", version));
        }
        long min = in.readLong();
        long max = in.readLong();
        RoaringBitmap32 ebm = new RoaringBitmap32();
        ebm.deserialize(in);
        RoaringBitmap32[] slices = new RoaringBitmap32[in.readInt()];
        for (int i = 0; i < slices.length; ++i) {
            RoaringBitmap32 rb = new RoaringBitmap32();
            rb.deserialize(in);
            slices[i] = rb;
        }
        return new BitSliceIndexRoaringBitmap(min, max, ebm, slices);
    }

    public static class Appender {
        private final long min;
        private final long max;
        private final RoaringBitmap32 ebm;
        private final RoaringBitmap32[] slices;

        public Appender(long min, long max) {
            if (min < 0L) {
                throw new IllegalArgumentException("values should be non-negative");
            }
            if (min > max) {
                throw new IllegalArgumentException("min should be less than max");
            }
            this.min = min;
            this.max = max;
            this.ebm = new RoaringBitmap32();
            this.slices = new RoaringBitmap32[64 - Long.numberOfLeadingZeros(max - min)];
            for (int i = 0; i < this.slices.length; ++i) {
                this.slices[i] = new RoaringBitmap32();
            }
        }

        public void append(int rid, long value) {
            if (value > this.max) {
                throw new IllegalArgumentException(String.format("value %s is too large", value));
            }
            if (this.ebm.contains(rid)) {
                throw new IllegalArgumentException(String.format("rid=%s is already exists", rid));
            }
            value -= this.min;
            while (value != 0L) {
                this.slices[Long.numberOfTrailingZeros(value)].add(rid);
                value &= value - 1L;
            }
            this.ebm.add(rid);
        }

        public boolean isNotEmpty() {
            return !this.ebm.isEmpty();
        }

        public void serialize(DataOutput out) throws IOException {
            out.writeByte(1);
            out.writeLong(this.min);
            out.writeLong(this.max);
            this.ebm.serialize(out);
            out.writeInt(this.slices.length);
            for (RoaringBitmap32 slice : this.slices) {
                slice.serialize(out);
            }
        }

        public BitSliceIndexRoaringBitmap build() throws IOException {
            return new BitSliceIndexRoaringBitmap(this.min, this.max, this.ebm, this.slices);
        }
    }

    @VisibleForTesting
    protected static enum Operation {
        EQ,
        NEQ,
        LTE,
        LT,
        GTE,
        GT;

    }
}

