/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.factories.FormatFactoryUtil;
import org.apache.paimon.format.FileFormatFactory;
import org.apache.paimon.format.FormatReaderFactory;
import org.apache.paimon.format.FormatWriterFactory;
import org.apache.paimon.format.SimpleStatsExtractor;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.options.Options;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.statistics.SimpleColStatsCollector;
import org.apache.paimon.types.RowType;

public abstract class FileFormat {
    protected String formatIdentifier;

    protected FileFormat(String formatIdentifier) {
        this.formatIdentifier = formatIdentifier;
    }

    public String getFormatIdentifier() {
        return this.formatIdentifier;
    }

    public abstract FormatReaderFactory createReaderFactory(RowType var1, @Nullable List<Predicate> var2);

    public abstract FormatWriterFactory createWriterFactory(RowType var1);

    public abstract void validateDataFields(RowType var1);

    public FormatReaderFactory createReaderFactory(RowType rowType) {
        return this.createReaderFactory(rowType, new ArrayList<Predicate>());
    }

    public Optional<SimpleStatsExtractor> createStatsExtractor(RowType type, SimpleColStatsCollector.Factory[] statsCollectors) {
        return Optional.empty();
    }

    public static FileFormat fromIdentifier(String identifier, Options options) {
        return FileFormat.fromIdentifier(CoreOptions.normalizeFileFormat((String)identifier), new FileFormatFactory.FormatContext(options, (Integer)options.get(CoreOptions.READ_BATCH_SIZE), (Integer)options.get(CoreOptions.WRITE_BATCH_SIZE), (Integer)options.get(CoreOptions.FILE_COMPRESSION_ZSTD_LEVEL), (MemorySize)options.get(CoreOptions.FILE_BLOCK_SIZE)));
    }

    public static FileFormat fromIdentifier(String identifier, FileFormatFactory.FormatContext context) {
        return FormatFactoryUtil.discoverFactory(FileFormat.class.getClassLoader(), identifier.toLowerCase()).create(context);
    }

    protected Options getIdentifierPrefixOptions(Options options) {
        HashMap<String, String> result = new HashMap<String, String>();
        String prefix = this.formatIdentifier.toLowerCase() + ".";
        for (String key : options.keySet()) {
            if (!key.toLowerCase().startsWith(prefix)) continue;
            result.put(prefix + key.substring(prefix.length()), options.get(key));
        }
        return new Options(result);
    }

    public static FileFormat fileFormat(CoreOptions options) {
        return FileFormat.fromIdentifier(options.fileFormatString(), options.toConfiguration());
    }

    public static FileFormat manifestFormat(CoreOptions options) {
        return FileFormat.fromIdentifier(options.manifestFormatString(), options.toConfiguration());
    }
}

