/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.compression;

import org.apache.paimon.compression.BlockCompressor;
import org.apache.paimon.compression.BufferCompressionException;
import org.apache.paimon.compression.CompressorUtils;
import org.apache.paimon.shade.io.airlift.compress.Compressor;

public class AirBlockCompressor
implements BlockCompressor {
    private final Compressor internalCompressor;

    public AirBlockCompressor(Compressor internalCompressor) {
        this.internalCompressor = internalCompressor;
    }

    @Override
    public int getMaxCompressedSize(int srcSize) {
        return 8 + this.internalCompressor.maxCompressedLength(srcSize);
    }

    @Override
    public int compress(byte[] src, int srcOff, int srcLen, byte[] dst, int dstOff) throws BufferCompressionException {
        try {
            if (dst.length < dstOff + this.getMaxCompressedSize(srcLen)) {
                throw new ArrayIndexOutOfBoundsException();
            }
            int compressedLength = this.internalCompressor.compress(src, srcOff, srcLen, dst, dstOff + 8, this.internalCompressor.maxCompressedLength(srcLen));
            CompressorUtils.writeIntLE(compressedLength, dst, dstOff);
            CompressorUtils.writeIntLE(srcLen, dst, dstOff + 4);
            return 8 + compressedLength;
        }
        catch (Exception e) {
            throw new BufferCompressionException(e);
        }
    }
}

