/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.casting;

import org.apache.paimon.casting.AbstractCastRule;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastRulePredicate;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeFamily;
import org.apache.paimon.utils.BinaryStringUtils;

class StringToStringCastRule
extends AbstractCastRule<BinaryString, BinaryString> {
    static final StringToStringCastRule INSTANCE = new StringToStringCastRule();

    private StringToStringCastRule() {
        super(CastRulePredicate.builder().input(DataTypeFamily.CHARACTER_STRING).target(DataTypeFamily.CHARACTER_STRING).build());
    }

    @Override
    public CastExecutor<BinaryString, BinaryString> create(DataType inputType, DataType targetType) {
        return value -> BinaryStringUtils.toCharacterString(value, targetType);
    }
}

