/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import java.util.Locale;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.gravitino.Entity;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.MetadataObjects;
import org.apache.gravitino.authorization.Owner;
import org.apache.gravitino.authorization.OwnerDispatcher;
import org.apache.gravitino.dto.requests.OwnerSetRequest;
import org.apache.gravitino.dto.responses.OwnerResponse;
import org.apache.gravitino.dto.responses.SetResponse;
import org.apache.gravitino.dto.util.DTOConverters;
import org.apache.gravitino.server.authorization.NameBindings;
import org.apache.gravitino.server.authorization.annotations.AuthorizationExpression;
import org.apache.gravitino.server.authorization.annotations.AuthorizationFullName;
import org.apache.gravitino.server.authorization.annotations.AuthorizationMetadata;
import org.apache.gravitino.server.authorization.annotations.AuthorizationObjectType;
import org.apache.gravitino.server.web.Utils;
import org.apache.gravitino.server.web.rest.ExceptionHandlers;
import org.apache.gravitino.server.web.rest.OperationType;
import org.apache.gravitino.utils.MetadataObjectUtil;

@NameBindings.AccessControlInterfaces
@Path(value="/metalakes/{metalake}/owners")
public class OwnerOperations {
    private final OwnerDispatcher ownerDispatcher = GravitinoEnv.getInstance().ownerDispatcher();
    @Context
    private HttpServletRequest httpRequest;

    @GET
    @Path(value="{metadataObjectType}/{fullName}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="get-object-owner.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="get-object-owner", absolute=true)
    @AuthorizationExpression(expression="CAN_ACCESS_METADATA", errorMessage="Current user can not get this objects's owner")
    public Response getOwnerForObject(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="metadataObjectType") @AuthorizationObjectType String metadataObjectType, @PathParam(value="fullName") @AuthorizationFullName String fullName) {
        try {
            MetadataObject object = MetadataObjects.parse((String)fullName, (MetadataObject.Type)MetadataObject.Type.valueOf((String)metadataObjectType.toUpperCase(Locale.ROOT)));
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                MetadataObjectUtil.checkMetadataObject((String)metalake, (MetadataObject)object);
                Optional owner = this.ownerDispatcher.getOwner(metalake, object);
                if (owner.isPresent()) {
                    return Utils.ok((Object)new OwnerResponse(DTOConverters.toDTO((Owner)((Owner)owner.get()))));
                }
                return Utils.ok((Object)new OwnerResponse(null));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleOwnerException(OperationType.GET, String.format("metadata object %s", fullName), metalake, e);
        }
    }

    @PUT
    @Path(value="{metadataObjectType}/{fullName}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="set-object-owner.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="set-object-owner", absolute=true)
    @AuthorizationExpression(expression="CAN_SET_OWNER", errorMessage="Current user can not set this objects's owner")
    public Response setOwnerForObject(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="metadataObjectType") String metadataObjectType, @PathParam(value="fullName") String fullName, OwnerSetRequest request) {
        try {
            MetadataObject object = MetadataObjects.parse((String)fullName, (MetadataObject.Type)MetadataObject.Type.valueOf((String)metadataObjectType.toUpperCase(Locale.ROOT)));
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                request.validate();
                MetadataObjectUtil.checkMetadataObject((String)metalake, (MetadataObject)object);
                this.ownerDispatcher.setOwner(metalake, object, request.getName(), request.getType());
                return Utils.ok((Object)new SetResponse(true));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleOwnerException(OperationType.SET, String.format("metadata object %s", fullName), metalake, e);
        }
    }
}

