/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class ReplicationPeerConfig {
    private String clusterKey;
    private String replicationEndpointImpl;
    private final Map<byte[], byte[]> peerData = new TreeMap<byte[], byte[]>(Bytes.BYTES_COMPARATOR);
    private final Map<String, String> configuration = new HashMap<String, String>(0);
    private Map<TableName, ? extends Collection<String>> tableCFsMap = null;
    private Set<String> namespaces = null;
    private long bandwidth = 0L;

    public ReplicationPeerConfig setClusterKey(String clusterKey) {
        this.clusterKey = clusterKey;
        return this;
    }

    public ReplicationPeerConfig setReplicationEndpointImpl(String replicationEndpointImpl) {
        this.replicationEndpointImpl = replicationEndpointImpl;
        return this;
    }

    public String getClusterKey() {
        return this.clusterKey;
    }

    public String getReplicationEndpointImpl() {
        return this.replicationEndpointImpl;
    }

    public Map<byte[], byte[]> getPeerData() {
        return this.peerData;
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public Map<TableName, List<String>> getTableCFsMap() {
        return this.tableCFsMap;
    }

    public ReplicationPeerConfig setTableCFsMap(Map<TableName, ? extends Collection<String>> tableCFsMap) {
        this.tableCFsMap = tableCFsMap;
        return this;
    }

    public Set<String> getNamespaces() {
        return this.namespaces;
    }

    public ReplicationPeerConfig setNamespaces(Set<String> namespaces) {
        this.namespaces = namespaces;
        return this;
    }

    public long getBandwidth() {
        return this.bandwidth;
    }

    public ReplicationPeerConfig setBandwidth(long bandwidth) {
        this.bandwidth = bandwidth;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("clusterKey=").append(this.clusterKey).append(",");
        builder.append("replicationEndpointImpl=").append(this.replicationEndpointImpl).append(",");
        if (this.namespaces != null) {
            builder.append("namespaces=").append(this.namespaces.toString()).append(",");
        }
        if (this.tableCFsMap != null) {
            builder.append("tableCFs=").append(this.tableCFsMap.toString()).append(",");
        }
        builder.append("bandwidth=").append(this.bandwidth);
        return builder.toString();
    }
}

