/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.HBaseRpcControllerImpl;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RpcControllerFactory {
    private static final Log LOG = LogFactory.getLog(RpcControllerFactory.class);
    public static final String CUSTOM_CONTROLLER_CONF_KEY = "hbase.rpc.controllerfactory.class";
    protected final Configuration conf;

    public RpcControllerFactory(Configuration conf) {
        this.conf = conf;
    }

    public HBaseRpcController newController() {
        return new HBaseRpcControllerImpl();
    }

    public HBaseRpcController newController(CellScanner cellScanner) {
        return new HBaseRpcControllerImpl(cellScanner);
    }

    public HBaseRpcController newController(List<CellScannable> cellIterables) {
        return new HBaseRpcControllerImpl(cellIterables);
    }

    public static RpcControllerFactory instantiate(Configuration configuration) {
        String rpcControllerFactoryClazz = configuration.get(CUSTOM_CONTROLLER_CONF_KEY, RpcControllerFactory.class.getName());
        try {
            return (RpcControllerFactory)ReflectionUtils.instantiateWithCustomCtor((String)rpcControllerFactoryClazz, (Class[])new Class[]{Configuration.class}, (Object[])new Object[]{configuration});
        }
        catch (NoClassDefFoundError | UnsupportedOperationException ex) {
            String msg = "Cannot load configured \"hbase.rpc.controllerfactory.class\" (" + rpcControllerFactoryClazz + ") from hbase-site.xml, falling back to use default RpcControllerFactory";
            if (LOG.isDebugEnabled()) {
                LOG.warn((Object)msg, ex);
            } else {
                LOG.warn((Object)msg);
            }
            return new RpcControllerFactory(configuration);
        }
    }
}

