/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.iceberg.converter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.expressions.transforms.Transforms;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.transforms.PartitionSpecVisitor;

public class FromIcebergPartitionSpec
implements PartitionSpecVisitor<Transform> {
    private final Map<Integer, String> idToName;

    public FromIcebergPartitionSpec(Map<Integer, String> idToName) {
        this.idToName = idToName;
    }

    public Transform identity(String sourceName, int sourceId) {
        return Transforms.identity((String)this.idToName.get(sourceId));
    }

    public Transform bucket(String sourceName, int sourceId, int numBuckets) {
        return Transforms.bucket((int)numBuckets, (String[][])new String[][]{{this.idToName.get(sourceId)}});
    }

    public Transform truncate(String sourceName, int sourceId, int width) {
        return Transforms.truncate((int)width, (String)this.idToName.get(sourceId));
    }

    public Transform year(String sourceName, int sourceId) {
        return Transforms.year((String)this.idToName.get(sourceId));
    }

    public Transform month(String sourceName, int sourceId) {
        return Transforms.month((String)this.idToName.get(sourceId));
    }

    public Transform day(String sourceName, int sourceId) {
        return Transforms.day((String)this.idToName.get(sourceId));
    }

    public Transform hour(String sourceName, int sourceId) {
        return Transforms.hour((String)this.idToName.get(sourceId));
    }

    public Transform alwaysNull(int fieldId, String sourceName, int sourceId) {
        return null;
    }

    public Transform unknown(int fieldId, String sourceName, int sourceId, String transform) {
        throw new UnsupportedOperationException("Unsupported Transform conversion type.");
    }

    public static Transform[] fromPartitionSpec(PartitionSpec partitionSpec, Schema schema) {
        FromIcebergPartitionSpec visitor = new FromIcebergPartitionSpec(schema.idToName());
        ArrayList transforms = Lists.newArrayList();
        List fields = partitionSpec.fields();
        for (PartitionField field : fields) {
            Transform transform = (Transform)PartitionSpecVisitor.visit((Schema)schema, (PartitionField)field, (PartitionSpecVisitor)visitor);
            if (transform == null) continue;
            transforms.add(transform);
        }
        return transforms.toArray(new Transform[0]);
    }
}

