/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.paimon.authentication;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.gravitino.Config;
import org.apache.gravitino.config.ConfigBuilder;
import org.apache.gravitino.config.ConfigEntry;
import org.apache.gravitino.connector.PropertyEntry;

public class AuthenticationConfig
extends Config {
    public static final String AUTH_TYPE_KEY = "authentication.type";
    public static final ConfigEntry<String> AUTH_TYPE_ENTRY = new ConfigBuilder("authentication.type").doc("The type of authentication for Paimon catalog, currently we only support simple and Kerberos").version("0.6.0").stringConf().createWithDefault((Object)"simple");
    public static final Map<String, PropertyEntry<?>> AUTHENTICATION_PROPERTY_ENTRIES = new ImmutableMap.Builder().put((Object)"authentication.type", (Object)PropertyEntry.stringOptionalPropertyEntry((String)"authentication.type", (String)"The type of authentication for Paimon catalog, currently we only support simple and Kerberos", (boolean)false, null, (boolean)false)).build();

    public AuthenticationConfig(Map<String, String> properties) {
        super(false);
        this.loadFromMap(properties, k -> true);
    }

    public String getAuthType() {
        return (String)this.get(AUTH_TYPE_ENTRY);
    }

    public boolean isSimpleAuth() {
        return AuthenticationType.SIMPLE.name().equalsIgnoreCase(this.getAuthType());
    }

    public boolean isKerberosAuth() {
        return AuthenticationType.KERBEROS.name().equalsIgnoreCase(this.getAuthType());
    }

    static enum AuthenticationType {
        SIMPLE,
        KERBEROS;

    }
}

