/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.base;

import java.util.List;
import org.apache.gravitino.storage.relational.po.PolicyMetadataObjectRelPO;
import org.apache.ibatis.annotations.Param;

public class PolicyMetadataObjectRelBaseSQLProvider {
    public String listPolicyPOsByMetadataObjectIdAndType(@Param(value="metadataObjectId") Long metadataObjectId, @Param(value="metadataObjectType") String metadataObjectType) {
        return "SELECT pm.policy_id, pm.policy_name, pm.policy_type, pm.metalake_id, pm.audit_info, pm.current_version, pm.last_version, pm.deleted_at, pvi.id, pvi.metalake_id as version_metalake_id, pvi.policy_id as version_policy_id, pvi.version, pvi.policy_comment, pvi.enabled, pvi.content, pvi.deleted_at as version_deleted_at FROM policy_meta pm JOIN policy_relation_meta pe ON pm.policy_id = pe.policy_id JOIN policy_version_info pvi ON pm.policy_id = pvi.policy_id AND pm.current_version = pvi.version WHERE pe.metadata_object_id = #{metadataObjectId} AND pe.metadata_object_type = #{metadataObjectType} AND pe.deleted_at = 0 AND pm.deleted_at = 0 AND pvi.deleted_at = 0";
    }

    public String getPolicyPOsByMetadataObjectAndPolicyName(@Param(value="metadataObjectId") Long metadataObjectId, @Param(value="metadataObjectType") String metadataObjectType, @Param(value="policyName") String policyName) {
        return "SELECT pm.policy_id, pm.policy_name, pm.policy_type, pm.metalake_id, pm.audit_info, pm.current_version, pm.last_version, pm.deleted_at, pvi.id, pvi.metalake_id as version_metalake_id, pvi.policy_id as version_policy_id, pvi.version, pvi.policy_comment, pvi.enabled, pvi.content, pvi.deleted_at as version_deleted_at FROM policy_meta pm JOIN policy_relation_meta pe ON pm.policy_id = pe.policy_id JOIN policy_version_info pvi ON pm.policy_id = pvi.policy_id AND pm.current_version = pvi.version WHERE pe.metadata_object_id = #{metadataObjectId} AND pe.metadata_object_type = #{metadataObjectType} AND pm.policy_name = #{policyName} AND pe.deleted_at = 0 AND pm.deleted_at = 0 AND pvi.deleted_at = 0";
    }

    public String listPolicyMetadataObjectRelsByMetalakeAndPolicyName(@Param(value="metalakeName") String metalakeName, @Param(value="policyName") String policyName) {
        return "SELECT pe.policy_id as policyId, pe.metadata_object_id as metadataObjectId, pe.metadata_object_type as metadataObjectType, pe.audit_info as auditInfo, pe.current_version as currentVersion, pe.last_version as lastVersion, pe.deleted_at as deletedAt FROM policy_relation_meta pe JOIN policy_meta pm ON pe.policy_id = pm.policy_id JOIN metalake_meta mm ON pm.metalake_id = mm.metalake_id WHERE mm.metalake_name = #{metalakeName} AND pm.policy_name = #{policyName} AND pe.deleted_at = 0 AND pm.deleted_at = 0 AND mm.deleted_at = 0";
    }

    public String batchInsertPolicyMetadataObjectRels(@Param(value="policyRels") List<PolicyMetadataObjectRelPO> policyRelPOs) {
        return "<script>INSERT INTO policy_relation_meta (policy_id, metadata_object_id, metadata_object_type, audit_info, current_version, last_version, deleted_at) VALUES <foreach collection='policyRels' item='item' separator=','>(#{item.policyId}, #{item.metadataObjectId}, #{item.metadataObjectType}, #{item.auditInfo}, #{item.currentVersion}, #{item.lastVersion}, #{item.deletedAt})</foreach></script>";
    }

    public String batchDeletePolicyMetadataObjectRelsByPolicyIdsAndMetadataObject(@Param(value="metadataObjectId") Long metadataObjectId, @Param(value="metadataObjectType") String metadataObjectType, @Param(value="policyIds") List<Long> policyIds) {
        return "<script>UPDATE policy_relation_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE policy_id IN <foreach item='policyId' collection='policyIds' open='(' separator=',' close=')'>#{policyId}</foreach> AND metadata_object_id = #{metadataObjectId} AND metadata_object_type = #{metadataObjectType} AND deleted_at = 0</script>";
    }

    public String softDeletePolicyMetadataObjectRelsByMetalakeAndPolicyName(@Param(value="metalakeName") String metalakeName, @Param(value="policyName") String policyName) {
        return "UPDATE policy_relation_meta pe JOIN policy_meta pm ON pe.policy_id = pm.policy_id JOIN metalake_meta mm ON pm.metalake_id = mm.metalake_id SET pe.deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE mm.metalake_name = #{metalakeName} AND pm.policy_name = #{policyName} AND pe.deleted_at = 0 AND pm.deleted_at = 0 AND mm.deleted_at = 0";
    }

    public String softDeletePolicyMetadataObjectRelsByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return "UPDATE policy_relation_meta pe JOIN policy_meta pm ON pe.policy_id = pm.policy_id SET pe.deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE pm.metalake_id = #{metalakeId} AND pe.deleted_at = 0 AND pm.deleted_at = 0";
    }

    public String softDeletePolicyMetadataObjectRelsByMetadataObject(@Param(value="metadataObjectId") Long metadataObjectId, @Param(value="metadataObjectType") String metadataObjectType) {
        return " UPDATE policy_relation_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE metadata_object_id = #{metadataObjectId} AND deleted_at = 0 AND metadata_object_type = #{metadataObjectType}";
    }

    public String softDeletePolicyMetadataObjectRelsByCatalogId(@Param(value="catalogId") Long catalogId) {
        return "UPDATE policy_relation_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE deleted_at = 0 AND (   (metadata_object_type = 'CATALOG' AND metadata_object_id = #{catalogId})   OR (metadata_object_type = 'SCHEMA' AND metadata_object_id IN (SELECT schema_id FROM schema_meta WHERE catalog_id = #{catalogId}))   OR (metadata_object_type = 'TOPIC' AND metadata_object_id IN (SELECT topic_id FROM topic_meta WHERE catalog_id = #{catalogId}))   OR (metadata_object_type = 'TABLE' AND metadata_object_id IN (SELECT table_id FROM table_meta WHERE catalog_id = #{catalogId}))   OR (metadata_object_type = 'FILESET' AND metadata_object_id IN (SELECT fileset_id FROM fileset_meta WHERE catalog_id = #{catalogId}))   OR (metadata_object_type = 'MODEL' AND metadata_object_id IN (SELECT model_id FROM model_meta WHERE catalog_id = #{catalogId})) )";
    }

    public String softDeletePolicyMetadataObjectRelsBySchemaId(@Param(value="schemaId") Long schemaId) {
        return "UPDATE policy_relation_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE deleted_at = 0 AND (   (metadata_object_type = 'SCHEMA' AND metadata_object_id = #{schemaId})   OR (metadata_object_type = 'TOPIC' AND metadata_object_id IN (SELECT topic_id FROM topic_meta WHERE schema_id = #{schemaId}))   OR (metadata_object_type = 'TABLE' AND metadata_object_id IN (SELECT table_id FROM table_meta WHERE schema_id = #{schemaId}))   OR (metadata_object_type = 'FILESET' AND metadata_object_id IN (SELECT fileset_id FROM fileset_meta WHERE schema_id = #{schemaId}))   OR (metadata_object_type = 'MODEL' AND metadata_object_id IN (SELECT model_id FROM model_meta WHERE schema_id = #{schemaId})) )";
    }

    public String softDeletePolicyMetadataObjectRelsByTableId(@Param(value="tableId") Long tableId) {
        return "UPDATE policy_relation_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE metadata_object_id = #{tableId} AND metadata_object_type = 'TABLE' AND deleted_at = 0";
    }

    public String deletePolicyEntityRelsByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return "DELETE FROM policy_relation_meta WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit}";
    }
}

