/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.hive.kerberos;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.hive.client.HiveClient;
import org.apache.gravitino.hive.kerberos.FetchFileUtils;
import org.apache.gravitino.hive.kerberos.KerberosConfig;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosClient
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosClient.class);
    private ScheduledThreadPoolExecutor checkTgtExecutor;
    private final Properties conf;
    private final Configuration hadoopConf;
    private final boolean refreshCredentials;
    private UserGroupInformation realLoginUgi;
    private final String keytabFilePath;
    private HiveClient hiveClient = null;

    public KerberosClient(Properties properties, Configuration hadoopConf, boolean refreshCredentials, String keytabFilePath) throws IOException {
        this.conf = properties;
        this.hadoopConf = hadoopConf;
        this.refreshCredentials = refreshCredentials;
        File keyTabFile = this.saveKeyTabFileFromUri(keytabFilePath);
        this.keytabFilePath = keyTabFile.getAbsolutePath();
    }

    public UserGroupInformation loginProxyUser(String currentUser) {
        try {
            if (currentUser.equals(this.realLoginUgi.getUserName()) || this.hiveClient == null) {
                return this.realLoginUgi;
            }
            String tokenSignature = this.conf.getProperty("hive.metastore.token.signature", "");
            String principal = this.conf.getProperty("authentication.kerberos.principal", "");
            List principalComponents = Splitter.on((char)'@').splitToList((CharSequence)principal);
            Preconditions.checkArgument((principalComponents.size() == 2 ? 1 : 0) != 0, (Object)"The principal has the wrong format");
            String kerberosRealm = (String)principalComponents.get(1);
            String finalPrincipalName = !currentUser.contains("@") ? String.format("%s@%s", currentUser, kerberosRealm) : currentUser;
            UserGroupInformation proxyUser = UserGroupInformation.createProxyUser((String)finalPrincipalName, (UserGroupInformation)this.realLoginUgi);
            String tokenStr = this.hiveClient.getDelegationToken(finalPrincipalName, this.realLoginUgi.getUserName());
            Token delegationToken = new Token();
            delegationToken.decodeFromUrlString(tokenStr);
            delegationToken.setService(new Text(tokenSignature));
            proxyUser.addToken(delegationToken);
            return proxyUser;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create proxy user for Kerberos Hive client", e);
        }
    }

    public UserGroupInformation login() throws Exception {
        UserGroupInformation loginUgi;
        KerberosConfig kerberosConfig = new KerberosConfig(this.conf, this.hadoopConf);
        String catalogPrincipal = kerberosConfig.getPrincipalName();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)catalogPrincipal), (Object)"The principal can't be blank");
        List principalComponents = Splitter.on((char)'@').splitToList((CharSequence)catalogPrincipal);
        Preconditions.checkArgument((principalComponents.size() == 2 ? 1 : 0) != 0, (Object)"The principal has the wrong format");
        UserGroupInformation.setConfiguration((Configuration)this.hadoopConf);
        UserGroupInformation.loginUserFromKeytab((String)catalogPrincipal, (String)this.keytabFilePath);
        this.realLoginUgi = loginUgi = UserGroupInformation.getLoginUser();
        if (this.refreshCredentials) {
            if (this.checkTgtExecutor == null) {
                this.checkTgtExecutor = new ScheduledThreadPoolExecutor(1, KerberosClient.getThreadFactory("check-tgt"));
            }
            int checkInterval = kerberosConfig.getCheckIntervalSec();
            this.checkTgtExecutor.scheduleAtFixedRate(() -> {
                try {
                    loginUgi.checkTGTAndReloginFromKeytab();
                }
                catch (Exception e) {
                    LOG.error("Fail to refresh ugi token: ", (Throwable)e);
                }
            }, checkInterval, checkInterval, TimeUnit.SECONDS);
        }
        return loginUgi;
    }

    public File saveKeyTabFileFromUri(String path) throws IOException {
        KerberosConfig kerberosConfig = new KerberosConfig(this.conf, this.hadoopConf);
        String keyTabUri = kerberosConfig.getKeytab();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)keyTabUri), (Object)"Keytab uri can't be blank");
        Preconditions.checkArgument((!keyTabUri.trim().startsWith("hdfs") ? 1 : 0) != 0, (Object)"HDFS URIs are not supported for keytab files");
        File keytabsDir = new File("keytabs");
        if (!keytabsDir.exists()) {
            keytabsDir.mkdir();
        }
        File keytabFile = new File(path);
        keytabFile.deleteOnExit();
        if (keytabFile.exists() && !keytabFile.delete()) {
            throw new IllegalStateException(String.format("Fail to delete keytab file %s", keytabFile.getAbsolutePath()));
        }
        int fetchKeytabFileTimeout = kerberosConfig.getFetchTimeoutSec();
        FetchFileUtils.fetchFileFromUri(keyTabUri, keytabFile, fetchKeytabFileTimeout, this.hadoopConf);
        return keytabFile;
    }

    private static ThreadFactory getThreadFactory(String factoryName) {
        return new ThreadFactoryBuilder().setDaemon(true).setNameFormat(factoryName + "-%d").build();
    }

    @Override
    public void close() {
        try {
            if (this.checkTgtExecutor != null) {
                this.checkTgtExecutor.shutdown();
            }
            Files.deleteIfExists(Paths.get(this.keytabFilePath, new String[0]));
        }
        catch (IOException e) {
            LOG.warn("Failed to delete keytab file: {}", (Object)this.keytabFilePath, (Object)e);
        }
    }

    public void setHiveClient(HiveClient client) {
        this.hiveClient = client;
    }
}

