/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.hive.client;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.exceptions.GravitinoRuntimeException;
import org.apache.gravitino.hive.client.HiveClientImpl;
import org.apache.gravitino.hive.client.HiveShim;
import org.apache.gravitino.hive.client.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HiveClientClassLoader
extends URLClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(HiveClientClassLoader.class);
    private final ClassLoader baseClassLoader;
    private final HiveVersion version;

    private HiveClientClassLoader(HiveVersion version, List<URL> execJars, ClassLoader baseClassLoader) {
        super(version.toString(), execJars.toArray(new URL[0]), null);
        Preconditions.checkArgument((version != null ? 1 : 0) != 0, (Object)"Hive version cannot be null");
        Preconditions.checkArgument((execJars != null && !execJars.isEmpty() ? 1 : 0) != 0, (Object)"Jar URLs cannot be null or empty");
        Preconditions.checkArgument((baseClassLoader != null ? 1 : 0) != 0, (Object)"Base classloader cannot be null");
        this.version = version;
        this.baseClassLoader = baseClassLoader;
    }

    public HiveVersion getHiveVersion() {
        return this.version;
    }

    public static HiveClientClassLoader createLoader(HiveVersion hiveVersion, ClassLoader baseLoader) throws IOException {
        Path jarDir = HiveClientClassLoader.getJarDirectory(hiveVersion);
        if (!Files.exists(jarDir, new LinkOption[0]) || !Files.isDirectory(jarDir, new LinkOption[0])) {
            throw new IOException("Hive jar directory does not exist or is not a directory: " + String.valueOf(jarDir));
        }
        List<URL> jars = HiveClientClassLoader.loadJarUrls(jarDir);
        if (jars.isEmpty()) {
            throw new IOException("No jar files found in directory: " + String.valueOf(jarDir));
        }
        return new HiveClientClassLoader(hiveVersion, jars, baseLoader);
    }

    private static Path getJarDirectory(HiveVersion version) {
        String gravitinoHome = System.getenv("GRAVITINO_HOME");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)gravitinoHome), (Object)"GRAVITINO_HOME not set");
        boolean testEnv = System.getenv("GRAVITINO_TEST") != null;
        String libsDir = version == HiveVersion.HIVE2 ? "hive-metastore2-libs" : "hive-metastore3-libs";
        Path jarDir = testEnv ? Paths.get(gravitinoHome, "catalogs", libsDir, "build", "libs") : Paths.get(gravitinoHome, "catalogs", "hive", "libs", libsDir);
        if (!Files.exists(jarDir, new LinkOption[0]) || !Files.isDirectory(jarDir, new LinkOption[0])) {
            throw new GravitinoRuntimeException("Cannot find Hive jar directory for version %s in directory %s", new Object[]{version, jarDir});
        }
        return jarDir.toAbsolutePath();
    }

    private static List<URL> loadJarUrls(Path jarDir) throws IOException {
        List<URL> list;
        block8: {
            Stream<Path> stream = Files.list(jarDir);
            try {
                list = stream.filter(p -> p.toString().endsWith(".jar")).map(p -> {
                    try {
                        return p.toUri().toURL();
                    }
                    catch (Exception e) {
                        throw new GravitinoRuntimeException((Throwable)e, "Failed to convert path to URL: %s", new Object[]{p});
                    }
                }).collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IOException("Failed to list jar files in directory: " + jarDir.toString(), e);
                }
            }
            stream.close();
        }
        return list;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> loaded = this.findLoadedClass(name);
        if (loaded != null) {
            return loaded;
        }
        if (this.isBarrierClass(name)) {
            return this.loadBarrierClass(name);
        }
        if (this.isSharedClass(name)) {
            return this.loadSharedClass(name, resolve);
        }
        LOG.debug("Classloader {} loading isolated class {}", (Object)this.getName(), (Object)name);
        return super.loadClass(name, resolve);
    }

    private Class<?> loadBarrierClass(String name) throws ClassNotFoundException {
        Class<?> clazz;
        block9: {
            LOG.debug("Classloader {} loading barrier class {}", (Object)this.getName(), (Object)name);
            String classFileName = name.replace(".", "/") + ".class";
            InputStream is = this.baseClassLoader.getResourceAsStream(classFileName);
            try {
                if (is == null) {
                    throw new ClassNotFoundException("Cannot load barrier class: " + name);
                }
                byte[] bytes = is.readAllBytes();
                clazz = this.defineClass(name, bytes, 0, bytes.length);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ClassNotFoundException("Failed to load barrier class: " + name, e);
                }
            }
            is.close();
        }
        return clazz;
    }

    private Class<?> loadSharedClass(String name, boolean resolve) throws ClassNotFoundException {
        LOG.debug("Classloader {} loading shared class {}", (Object)this.getName(), (Object)name);
        try {
            return this.baseClassLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return super.loadClass(name, resolve);
        }
    }

    private boolean isSharedClass(String name) {
        if (name.startsWith("org.slf4j") || name.startsWith("org.apache.log4j") || name.startsWith("org.apache.logging.log4j")) {
            return true;
        }
        if (name.startsWith("org.apache.hadoop.") && !name.startsWith("org.apache.hadoop.hive.")) {
            return true;
        }
        if (name.startsWith("com.google") && !name.startsWith("com.google.cloud")) {
            return true;
        }
        if (name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("com.sun.") || name.startsWith("org.ietf.jgss.")) {
            return true;
        }
        return name.startsWith("org.apache.gravitino.");
    }

    private boolean isBarrierClass(String name) {
        return name.startsWith(HiveClientImpl.class.getName()) || name.startsWith(HiveShim.class.getName()) || name.startsWith(Util.class.getName()) || name.startsWith("org.apache.gravitino.hive.converter.");
    }

    public static enum HiveVersion {
        HIVE2,
        HIVE3;

    }
}

