/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public class JsonUtilsV2 {
    private static final ThreadLocal<ObjectMapper> mapper = new ThreadLocal<ObjectMapper>(){

        @Override
        protected ObjectMapper initialValue() {
            return new ObjectMapper();
        }
    };

    public static ObjectMapper getMapper() {
        return mapper.get();
    }

    public static Map<String, String> jsonToMap(String jsonStr) throws Exception {
        Map<String, String> ret = jsonStr == null || jsonStr.isEmpty() ? new HashMap<String, String>() : (Map)JsonUtilsV2.getMapper().readValue(jsonStr, (TypeReference)new TypeReference<Map<String, String>>(){});
        return ret;
    }

    public static String mapToJson(Map<?, ?> map) throws Exception {
        return JsonUtilsV2.getMapper().writeValueAsString(map);
    }

    public static String listToJson(List<?> list) throws Exception {
        return JsonUtilsV2.getMapper().writeValueAsString(list);
    }

    public static String objToJson(Serializable obj) throws Exception {
        return JsonUtilsV2.getMapper().writeValueAsString((Object)obj);
    }

    public static <T> T jsonToObj(String json, Class<T> tClass) throws Exception {
        return (T)JsonUtilsV2.getMapper().readValue(json, tClass);
    }
}

