/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerPluginContext;
import org.apache.ranger.plugin.policyengine.RangerResourceTrie;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyEvaluator;
import org.apache.ranger.plugin.policyresourcematcher.RangerResourceEvaluator;
import org.apache.ranger.plugin.resourcematcher.RangerAbstractResourceMatcher;
import org.apache.ranger.plugin.resourcematcher.RangerResourceMatcher;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.ServiceDefUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerResourceTrie<T extends RangerResourceEvaluator> {
    private static final Logger LOG = LoggerFactory.getLogger(RangerResourceTrie.class);
    private static final Logger TRACE_LOG = RangerPerfTracer.getPerfLogger("resourcetrie.trace");
    private static final Logger PERF_TRIE_INIT_LOG = RangerPerfTracer.getPerfLogger("resourcetrie.init");
    private static final Logger PERF_TRIE_OP_LOG = RangerPerfTracer.getPerfLogger("resourcetrie.op");
    private static final String DEFAULT_WILDCARD_CHARS = "*?";
    private static final String TRIE_BUILDER_THREAD_COUNT = "ranger.policyengine.trie.builder.thread.count";
    private final RangerServiceDef.RangerResourceDef resourceDef;
    private final boolean optIgnoreCase;
    private final boolean optWildcard;
    private final String wildcardChars;
    private final boolean isOptimizedForRetrieval;
    private final boolean isOptimizedForSpace;
    private final Character separatorChar;
    private Set<T> inheritedEvaluators;
    private final TrieNode<T> root;

    public RangerResourceTrie(RangerServiceDef.RangerResourceDef resourceDef, List<T> evaluators) {
        this(resourceDef, evaluators, true, null);
    }

    public RangerResourceTrie(RangerResourceTrie<T> other) {
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_TRIE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_TRIE_INIT_LOG, "RangerResourceTrie.copyTrie(name=" + other.resourceDef.getName() + ")");
        }
        this.resourceDef = other.resourceDef;
        this.optIgnoreCase = other.optIgnoreCase;
        this.optWildcard = other.optWildcard;
        this.wildcardChars = other.wildcardChars;
        this.isOptimizedForSpace = other.isOptimizedForSpace;
        this.isOptimizedForRetrieval = false;
        this.separatorChar = other.separatorChar;
        this.inheritedEvaluators = other.inheritedEvaluators != null ? new HashSet<T>(other.inheritedEvaluators) : null;
        this.root = this.copyTrieSubtree(other.root, null);
        RangerPerfTracer.logAlways(perf);
        if (PERF_TRIE_INIT_LOG.isDebugEnabled()) {
            PERF_TRIE_INIT_LOG.debug(this.toString());
        }
        if (TRACE_LOG.isTraceEnabled()) {
            TRACE_LOG.trace("Trie Dump from RangerResourceTrie.copyTrie(name=" + other.resourceDef.getName() + "):\n[" + this.dumpTrie() + "]");
        }
    }

    public RangerResourceTrie(RangerServiceDef.RangerResourceDef resourceDef, List<T> evaluators, boolean isOptimizedForRetrieval, RangerPluginContext pluginContext) {
        this(resourceDef, evaluators, isOptimizedForRetrieval, false, pluginContext);
    }

    public <T extends RangerResourceEvaluator, E> RangerResourceTrie(RangerServiceDef.RangerResourceDef resourceDef, List<E> evaluators, boolean isOptimizedForRetrieval, boolean isOptimizedForSpace, RangerPluginContext pluginContext) {
        int builderThreadCount;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerResourceTrie(" + resourceDef.getName() + ", evaluatorCount=" + evaluators.size() + ", isOptimizedForRetrieval=" + isOptimizedForRetrieval + ", isOptimizedForSpace=" + isOptimizedForSpace + ")");
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_TRIE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_TRIE_INIT_LOG, "RangerResourceTrie.init(name=" + resourceDef.getName() + ")");
        }
        RangerPluginConfig config = pluginContext != null ? pluginContext.getConfig() : null;
        int n = builderThreadCount = config != null ? config.getInt(TRIE_BUILDER_THREAD_COUNT, 1) : 1;
        if (builderThreadCount < 1) {
            builderThreadCount = 1;
        }
        if (TRACE_LOG.isTraceEnabled()) {
            TRACE_LOG.trace("builderThreadCount is set to [" + builderThreadCount + "]");
        }
        Map<String, String> matcherOptions = resourceDef.getMatcherOptions();
        boolean optReplaceTokens = RangerAbstractResourceMatcher.getOptionReplaceTokens(matcherOptions);
        boolean optReplaceReqExpressions = RangerAbstractResourceMatcher.getOptionReplaceReqExpressions(matcherOptions);
        String tokenReplaceSpecialChars = "";
        if (optReplaceTokens) {
            char delimiterStart = RangerAbstractResourceMatcher.getOptionDelimiterStart(matcherOptions);
            char delimiterEnd = RangerAbstractResourceMatcher.getOptionDelimiterEnd(matcherOptions);
            char delimiterEscape = RangerAbstractResourceMatcher.getOptionDelimiterEscape(matcherOptions);
            tokenReplaceSpecialChars = tokenReplaceSpecialChars + delimiterStart;
            tokenReplaceSpecialChars = tokenReplaceSpecialChars + delimiterEnd;
            tokenReplaceSpecialChars = tokenReplaceSpecialChars + delimiterEscape;
        }
        if (optReplaceReqExpressions) {
            tokenReplaceSpecialChars = tokenReplaceSpecialChars + "${{".charAt(0);
        }
        this.resourceDef = resourceDef;
        this.optIgnoreCase = RangerAbstractResourceMatcher.getOptionIgnoreCase(matcherOptions);
        this.optWildcard = RangerAbstractResourceMatcher.getOptionWildCard(matcherOptions);
        this.wildcardChars = this.optWildcard ? DEFAULT_WILDCARD_CHARS + tokenReplaceSpecialChars : "" + tokenReplaceSpecialChars;
        this.isOptimizedForSpace = isOptimizedForSpace;
        this.isOptimizedForRetrieval = !isOptimizedForSpace && isOptimizedForRetrieval;
        this.separatorChar = Character.valueOf(ServiceDefUtil.getCharOption(matcherOptions, "pathSeparatorChar", '/'));
        TrieNode<T> tmpRoot = this.buildTrie(resourceDef, evaluators, builderThreadCount);
        this.root = builderThreadCount > 1 && tmpRoot == null ? this.buildTrie(resourceDef, evaluators, 1) : tmpRoot;
        this.wrapUpUpdate();
        RangerPerfTracer.logAlways(perf);
        if (PERF_TRIE_INIT_LOG.isDebugEnabled()) {
            PERF_TRIE_INIT_LOG.debug(this.toString());
        }
        if (TRACE_LOG.isTraceEnabled()) {
            TRACE_LOG.trace("Trie Dump from RangerResourceTrie.init(name=" + resourceDef.getName() + "):\n[" + this.dumpTrie() + "]");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerResourceTrie(" + resourceDef.getName() + ", evaluatorCount=" + evaluators.size() + ", isOptimizedForRetrieval=" + this.isOptimizedForRetrieval + ", isOptimizedForSpace=" + this.isOptimizedForSpace + "): " + this.toString());
        }
    }

    public Set<T> getInheritedEvaluators() {
        return this.inheritedEvaluators;
    }

    public Set<T> getEvaluatorsForResource(Object resource) {
        return this.getEvaluatorsForResource(resource, RangerAccessRequest.ResourceMatchingScope.SELF);
    }

    public Set<T> getEvaluatorsForResource(Object resource, RangerAccessRequest.ResourceMatchingScope scope) {
        if (resource instanceof String) {
            return this.getEvaluatorsForResource((String)resource, scope);
        }
        if (resource instanceof Collection) {
            if (CollectionUtils.isEmpty((Collection)((Collection)resource))) {
                return this.getEvaluatorsForResource("", scope);
            }
            Collection resources = (Collection)resource;
            return this.getEvaluatorsForResources(resources, scope);
        }
        return null;
    }

    public void add(RangerPolicy.RangerPolicyResource resource, T evaluator) {
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_TRIE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_TRIE_INIT_LOG, "RangerResourceTrie.add(name=" + resource + ")");
        }
        if (resource == null) {
            if (evaluator.isAncestorOf(this.resourceDef)) {
                this.addInheritedEvaluator(evaluator);
            }
        } else if (resource.getIsExcludes().booleanValue()) {
            this.addInheritedEvaluator(evaluator);
        } else if (CollectionUtils.isNotEmpty(resource.getValues())) {
            for (String value : resource.getValues()) {
                this.insert(this.root, value, resource.getIsRecursive(), evaluator);
            }
        }
        RangerPerfTracer.logAlways(perf);
        if (TRACE_LOG.isTraceEnabled()) {
            TRACE_LOG.trace("Trie Dump from RangerResourceTrie.add(name=" + resource + "):\n[" + this.dumpTrie() + "]");
        }
    }

    public void delete(RangerPolicy.RangerPolicyResource resource, T evaluator) {
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_TRIE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_TRIE_INIT_LOG, "RangerResourceTrie.delete(name=" + resource + ")");
        }
        if (resource == null) {
            if (evaluator.isAncestorOf(this.resourceDef)) {
                this.removeInheritedEvaluator(evaluator);
            }
        } else if (resource.getIsExcludes().booleanValue()) {
            this.removeInheritedEvaluator(evaluator);
        } else {
            for (String value : resource.getValues()) {
                TrieNode<T> node = this.getNodeForResource(value);
                if (node == null) continue;
                ((TrieNode)node).removeEvaluatorFromSubtree(evaluator);
            }
        }
        RangerPerfTracer.logAlways(perf);
        if (TRACE_LOG.isTraceEnabled()) {
            TRACE_LOG.trace("Trie Dump from RangerResourceTrie.delete(name=" + resource + "):\n[" + this.dumpTrie() + "]");
        }
    }

    public void wrapUpUpdate() {
        if (this.root != null) {
            this.root.wrapUpUpdate();
            if (TRACE_LOG.isTraceEnabled()) {
                TRACE_LOG.trace("Trie Dump from RangerResourceTrie.wrapUpUpdate(name=" + this.resourceDef.getName() + "):\n[" + this.dumpTrie() + "]");
            }
        }
    }

    public StringBuilder dumpTrie() {
        StringBuilder sb = new StringBuilder();
        if (this.root != null) {
            this.root.toString("", sb);
        }
        return sb;
    }

    TrieNode<T> getRoot() {
        return this.root;
    }

    private void addInheritedEvaluator(T evaluator) {
        if (this.inheritedEvaluators == null) {
            this.inheritedEvaluators = new HashSet<T>();
        }
        this.inheritedEvaluators.add(evaluator);
    }

    private void removeInheritedEvaluator(T evaluator) {
        if (CollectionUtils.isNotEmpty(this.inheritedEvaluators) && this.inheritedEvaluators.contains(evaluator)) {
            this.inheritedEvaluators.remove(evaluator);
            if (CollectionUtils.isEmpty(this.inheritedEvaluators)) {
                this.inheritedEvaluators = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TrieNode<T> copyTrieSubtree(TrieNode<T> source, TrieNode<T> parent) {
        if (TRACE_LOG.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            source.toString(sb);
            TRACE_LOG.trace("==> copyTrieSubtree(" + sb + ")");
        }
        TrieNode dest = new TrieNode(((TrieNode)source).str);
        if (parent != null) {
            ((TrieNode)parent).addChild(dest);
        }
        Map map = ((TrieNode)source).children;
        synchronized (map) {
            dest.isSetup = ((TrieNode)source).isSetup;
            dest.isSharingParentWildcardEvaluators = ((TrieNode)source).isSharingParentWildcardEvaluators;
            if (((TrieNode)source).isSharingParentWildcardEvaluators) {
                if (dest.getParent() != null) {
                    dest.wildcardEvaluators = dest.getParent().getWildcardEvaluators();
                } else {
                    dest.wildcardEvaluators = null;
                }
            } else if (((TrieNode)source).wildcardEvaluators != null) {
                dest.wildcardEvaluators = new HashSet(((TrieNode)source).wildcardEvaluators);
            } else {
                dest.wildcardEvaluators = null;
            }
            if (((TrieNode)source).evaluators != null) {
                if (((TrieNode)source).evaluators == ((TrieNode)source).wildcardEvaluators) {
                    dest.evaluators = dest.wildcardEvaluators;
                } else {
                    dest.evaluators = new HashSet(((TrieNode)source).evaluators);
                }
            } else {
                dest.evaluators = null;
            }
        }
        Map<Character, TrieNode<T>> children = source.getChildren();
        for (Map.Entry<Character, TrieNode<T>> entry : children.entrySet()) {
            this.copyTrieSubtree(entry.getValue(), dest);
        }
        if (TRACE_LOG.isTraceEnabled()) {
            StringBuilder sourceAsString = new StringBuilder();
            StringBuilder destAsString = new StringBuilder();
            source.toString(sourceAsString);
            dest.toString(destAsString);
            TRACE_LOG.trace("<== copyTrieSubtree(" + sourceAsString + ") : " + destAsString);
        }
        return dest;
    }

    private <E> TrieNode<T> buildTrie(RangerServiceDef.RangerResourceDef resourceDef, List<E> evaluators, int builderThreadCount) {
        HashMap<Character, Integer> builderThreadMap;
        ArrayList<ResourceTrieBuilderThread> builderThreads;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> buildTrie(" + resourceDef.getName() + ", evaluatorCount=" + evaluators.size() + ", isMultiThreaded=" + (builderThreadCount > 1) + ")");
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_TRIE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_TRIE_INIT_LOG, "RangerResourceTrie.init(resourceDef=" + resourceDef.getName() + ")");
        }
        TrieNode<RangerResourceEvaluator> ret = new TrieNode<RangerResourceEvaluator>(null);
        boolean isMultiThreaded = builderThreadCount > 1;
        String resourceName = resourceDef.getName();
        int lastUsedThreadIndex = 0;
        if (isMultiThreaded) {
            builderThreads = new ArrayList<ResourceTrieBuilderThread>();
            for (int i = 0; i < builderThreadCount; ++i) {
                ResourceTrieBuilderThread t = new ResourceTrieBuilderThread();
                t.setDaemon(true);
                builderThreads.add(t);
                t.start();
            }
            builderThreadMap = new HashMap<Character, Integer>();
        } else {
            builderThreads = null;
            builderThreadMap = null;
        }
        block5: for (E evaluator : evaluators) {
            List<RangerResourceEvaluator> resourceEvaluators;
            if (evaluator instanceof RangerPolicyEvaluator) {
                resourceEvaluators = ((RangerPolicyEvaluator)evaluator).getResourceEvaluators();
            } else if (evaluator instanceof RangerResourceEvaluator) {
                resourceEvaluators = Collections.singletonList((RangerResourceEvaluator)evaluator);
            } else {
                LOG.error("buildTrie(): unexpected evaluator class " + evaluator.getClass().getCanonicalName());
                resourceEvaluators = Collections.emptyList();
            }
            for (RangerResourceEvaluator rangerResourceEvaluator : resourceEvaluators) {
                RangerPolicy.RangerPolicyResource policyResource;
                Map<String, RangerPolicy.RangerPolicyResource> policyResources = rangerResourceEvaluator.getPolicyResource();
                RangerPolicy.RangerPolicyResource rangerPolicyResource = policyResource = policyResources != null ? policyResources.get(resourceName) : null;
                if (policyResource == null) {
                    if (!rangerResourceEvaluator.isAncestorOf(resourceDef)) continue;
                    this.addInheritedEvaluator(rangerResourceEvaluator);
                    continue;
                }
                if (policyResource.getIsExcludes().booleanValue()) {
                    this.addInheritedEvaluator(rangerResourceEvaluator);
                    continue;
                }
                RangerResourceMatcher resourceMatcher = rangerResourceEvaluator.getResourceMatcher(resourceName);
                if (resourceMatcher != null && resourceMatcher.isMatchAny()) {
                    ret.addWildcardEvaluator(rangerResourceEvaluator);
                    continue;
                }
                if (!CollectionUtils.isNotEmpty(policyResource.getValues())) continue;
                for (String resource : policyResource.getValues()) {
                    if (!isMultiThreaded) {
                        this.insert(ret, resource, policyResource.getIsRecursive(), rangerResourceEvaluator);
                        continue;
                    }
                    try {
                        lastUsedThreadIndex = this.insert(ret, resource, policyResource.getIsRecursive(), rangerResourceEvaluator, builderThreadMap, builderThreads, lastUsedThreadIndex);
                    }
                    catch (InterruptedException ex) {
                        LOG.error("Failed to dispatch " + resource + " to " + builderThreads.get(lastUsedThreadIndex));
                        LOG.error("Failing and retrying with one thread");
                        ret = null;
                        break;
                    }
                }
                if (ret != null) continue;
                continue block5;
            }
        }
        if (ret != null && isMultiThreaded) {
            for (ResourceTrieBuilderThread t : builderThreads) {
                try {
                    t.add("", false, null);
                    t.join();
                    ret.getChildren().putAll(t.getSubtrees());
                }
                catch (InterruptedException ex) {
                    LOG.error("BuilderThread " + t + " was interrupted:", (Throwable)ex);
                    LOG.error("Failing and retrying with one thread");
                    ret = null;
                    break;
                }
            }
            this.cleanUpThreads(builderThreads);
        }
        RangerPerfTracer.logAlways(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== buildTrie(" + resourceDef.getName() + ", evaluatorCount=" + evaluators.size() + ", isMultiThreaded=" + isMultiThreaded + ") :" + ret);
        }
        return ret;
    }

    private void cleanUpThreads(List<ResourceTrieBuilderThread> builderThreads) {
        if (CollectionUtils.isNotEmpty(builderThreads)) {
            for (ResourceTrieBuilderThread t : builderThreads) {
                try {
                    if (!t.isAlive()) continue;
                    t.interrupt();
                    t.join();
                }
                catch (InterruptedException ex) {
                    LOG.error("Could not terminate thread " + t);
                }
            }
        }
    }

    private TrieData getTrieData() {
        TrieData ret = new TrieData();
        this.root.populateTrieData(ret);
        ret.maxDepth = this.getMaxDepth();
        return ret;
    }

    private int getMaxDepth() {
        return this.root.getMaxDepth();
    }

    private Character getLookupChar(char ch) {
        return Character.valueOf(this.optIgnoreCase ? Character.toLowerCase(ch) : ch);
    }

    private Character getLookupChar(String str, int index) {
        return this.getLookupChar(str.charAt(index));
    }

    private int insert(TrieNode<T> currentRoot, String resource, boolean isRecursive, T evaluator, Map<Character, Integer> builderThreadMap, List<ResourceTrieBuilderThread> builderThreads, int lastUsedThreadIndex) throws InterruptedException {
        int ret = lastUsedThreadIndex;
        String prefix = this.getNonWildcardPrefix(resource);
        if (StringUtils.isNotEmpty((String)prefix)) {
            char c = this.getLookupChar(prefix.charAt(0)).charValue();
            Integer index = builderThreadMap.get(Character.valueOf(c));
            if (index == null) {
                index = (lastUsedThreadIndex + 1) % builderThreads.size();
                ret = index;
                builderThreadMap.put(Character.valueOf(c), index);
            }
            builderThreads.get(index).add(resource, isRecursive, evaluator);
        } else {
            currentRoot.addWildcardEvaluator(evaluator);
        }
        return ret;
    }

    private void insert(TrieNode<T> currentRoot, String resource, boolean isRecursive, T evaluator) {
        boolean isWildcard;
        TrieNode<T> curr = currentRoot;
        String prefix = this.getNonWildcardPrefix(resource);
        boolean bl = isWildcard = prefix.length() != resource.length();
        if (StringUtils.isNotEmpty((String)prefix)) {
            curr = curr.getOrCreateChild(prefix);
        }
        if (isWildcard || isRecursive) {
            curr.addWildcardEvaluator(evaluator);
        } else {
            curr.addEvaluator(evaluator);
        }
    }

    private String getNonWildcardPrefix(String str) {
        int minIndex = str.length();
        for (int i = 0; i < this.wildcardChars.length(); ++i) {
            int index = str.indexOf(this.wildcardChars.charAt(i));
            if (index == -1 || index >= minIndex) continue;
            minIndex = index;
        }
        return str.substring(0, minIndex);
    }

    private Set<T> getEvaluatorsForResource(String resource, RangerAccessRequest.ResourceMatchingScope scope) {
        boolean includeEvaluatorsOfChildResources;
        Set<Object> ret;
        boolean isSelfMatch;
        int i;
        String childStr;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerResourceTrie.getEvaluatorsForResource(" + resource + ", " + (Object)((Object)scope) + ")");
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_TRIE_OP_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_TRIE_OP_LOG, "RangerResourceTrie.getEvaluatorsForResource(resource=" + resource + ")");
        }
        TrieNode<T> curr = this.root;
        TrieNode<T> parent = null;
        TrieNode<T> child = null;
        int len = resource.length();
        HashSet<T> accumulatedEvaluators = new HashSet<T>();
        for (i = 0; i < len; i += childStr.length()) {
            if (!this.isOptimizedForSpace) {
                curr.setupIfNeeded(parent);
            } else if (curr.getWildcardEvaluators() != null) {
                accumulatedEvaluators.addAll(curr.getWildcardEvaluators());
            }
            child = curr.getChild(this.getLookupChar(resource, i));
            if (child == null || !resource.regionMatches(this.optIgnoreCase, i, childStr = child.getStr(), 0, childStr.length())) break;
            parent = curr;
            curr = child;
        }
        if (!this.isOptimizedForSpace) {
            curr.setupIfNeeded(parent);
        } else if (curr.getWildcardEvaluators() != null) {
            accumulatedEvaluators.addAll(curr.getWildcardEvaluators());
        }
        boolean bl = isSelfMatch = i == len;
        if (!this.isOptimizedForSpace) {
            ret = isSelfMatch ? curr.getEvaluators() : curr.getWildcardEvaluators();
        } else {
            if (isSelfMatch && curr.getEvaluators() != null) {
                accumulatedEvaluators.addAll(curr.getEvaluators());
            }
            ret = accumulatedEvaluators;
        }
        boolean bl2 = includeEvaluatorsOfChildResources = scope == RangerAccessRequest.ResourceMatchingScope.SELF_OR_CHILD;
        if (includeEvaluatorsOfChildResources) {
            boolean resourceEndsWithSep;
            HashSet<Object> childEvalautors = new HashSet<Object>();
            boolean bl3 = resourceEndsWithSep = resource.charAt(resource.length() - 1) == this.separatorChar.charValue();
            if (isSelfMatch) {
                if (resourceEndsWithSep) {
                    curr.getChildren().values().stream().forEach(c -> c.collectChildEvaluators(this.separatorChar, 0, childEvalautors));
                } else if ((curr = curr.getChild(this.separatorChar)) != null) {
                    curr.collectChildEvaluators(this.separatorChar, 1, childEvalautors);
                }
            } else if (child != null) {
                int remainingLen = len - i;
                boolean isPrefixMatch = child.getStr().regionMatches(this.optIgnoreCase, 0, resource, i, remainingLen);
                if (isPrefixMatch) {
                    if (resourceEndsWithSep) {
                        child.collectChildEvaluators(this.separatorChar, remainingLen, childEvalautors);
                    } else if (child.getStr().charAt(remainingLen) == this.separatorChar.charValue()) {
                        child.collectChildEvaluators(this.separatorChar, remainingLen + 1, childEvalautors);
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(childEvalautors)) {
                if (CollectionUtils.isNotEmpty(ret)) {
                    childEvalautors.addAll(ret);
                }
                ret = childEvalautors;
            }
        }
        RangerPerfTracer.logAlways(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerResourceTrie.getEvaluatorsForResource(" + resource + ", " + (Object)((Object)scope) + "): evaluators=" + (ret == null ? null : Arrays.deepToString(ret.toArray())));
        }
        return ret;
    }

    private TrieNode<T> getNodeForResource(String resource) {
        TrieNode<T> child;
        String childStr;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerResourceTrie.getNodeForResource(" + resource + ")");
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_TRIE_OP_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_TRIE_OP_LOG, "RangerResourceTrie.getNodeForResource(resource=" + resource + ")");
        }
        TrieNode<T> curr = this.root;
        int len = resource.length();
        for (int i = 0; i < len && (child = curr.getChild(this.getLookupChar(resource, i))) != null && resource.regionMatches(this.optIgnoreCase, i, childStr = child.getStr(), 0, childStr.length()); i += childStr.length()) {
            curr = child;
        }
        RangerPerfTracer.logAlways(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerResourceTrie.getNodeForResource(" + resource + ")");
        }
        return curr;
    }

    private Set<T> getEvaluatorsForResources(Collection<String> resources, RangerAccessRequest.ResourceMatchingScope scope) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerResourceTrie.getEvaluatorsForResources(" + resources + ")");
        }
        Set<Object> ret = null;
        HashMap<Long, RangerResourceEvaluator> evaluatorsMap = null;
        for (String resource : resources) {
            Set<T> resourceEvaluators = this.getEvaluatorsForResource(resource, scope);
            if (CollectionUtils.isEmpty(resourceEvaluators)) continue;
            if (evaluatorsMap == null) {
                if (ret == null) {
                    ret = resourceEvaluators;
                } else if (ret != resourceEvaluators) {
                    evaluatorsMap = new HashMap<Long, RangerResourceEvaluator>();
                    for (RangerResourceEvaluator rangerResourceEvaluator : ret) {
                        evaluatorsMap.put(rangerResourceEvaluator.getId(), rangerResourceEvaluator);
                    }
                    ret = null;
                }
            }
            if (evaluatorsMap == null) continue;
            for (RangerResourceEvaluator rangerResourceEvaluator : resourceEvaluators) {
                evaluatorsMap.put(rangerResourceEvaluator.getId(), rangerResourceEvaluator);
            }
        }
        if (ret == null && evaluatorsMap != null) {
            ret = new HashSet(evaluatorsMap.values());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerResourceTrie.getEvaluatorsForResources(" + resources + "): evaluatorCount=" + (ret == null ? 0 : ret.size()));
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        TrieData trieData = this.getTrieData();
        sb.append("resourceName=").append(this.resourceDef.getName());
        sb.append("; optIgnoreCase=").append(this.optIgnoreCase);
        sb.append("; optWildcard=").append(this.optWildcard);
        sb.append("; wildcardChars=").append(this.wildcardChars);
        sb.append("; nodeCount=").append(trieData.nodeCount);
        sb.append("; leafNodeCount=").append(trieData.leafNodeCount);
        sb.append("; singleChildNodeCount=").append(trieData.singleChildNodeCount);
        sb.append("; maxDepth=").append(trieData.maxDepth);
        sb.append("; evaluatorListCount=").append(trieData.evaluatorListCount);
        sb.append("; wildcardEvaluatorListCount=").append(trieData.wildcardEvaluatorListCount);
        sb.append("; evaluatorListRefCount=").append(trieData.evaluatorListRefCount);
        sb.append("; wildcardEvaluatorListRefCount=").append(trieData.wildcardEvaluatorListRefCount);
        return sb.toString();
    }

    class TrieNode<U extends T> {
        private String str;
        private TrieNode<U> parent;
        private final Map<Character, TrieNode<U>> children = new HashMap<Character, TrieNode<U>>();
        private Set<U> evaluators;
        private Set<U> wildcardEvaluators;
        private boolean isSharingParentWildcardEvaluators;
        private volatile boolean isSetup = false;

        TrieNode(String str) {
            this.str = str;
        }

        String getStr() {
            return this.str;
        }

        void setStr(String str) {
            this.str = str;
        }

        TrieNode<U> getParent() {
            return this.parent;
        }

        void setParent(TrieNode<U> parent) {
            this.parent = parent;
        }

        Map<Character, TrieNode<U>> getChildren() {
            return this.children;
        }

        Set<U> getEvaluators() {
            return this.evaluators;
        }

        Set<U> getWildcardEvaluators() {
            return this.wildcardEvaluators;
        }

        TrieNode<U> getChild(Character ch) {
            return this.children.get(ch);
        }

        void populateTrieData(TrieData trieData) {
            ++trieData.nodeCount;
            if (this.wildcardEvaluators != null) {
                if (this.isSharingParentWildcardEvaluators) {
                    ++trieData.wildcardEvaluatorListRefCount;
                } else {
                    ++trieData.wildcardEvaluatorListCount;
                }
            }
            if (this.evaluators != null) {
                if (this.evaluators == this.wildcardEvaluators) {
                    ++trieData.evaluatorListRefCount;
                } else {
                    ++trieData.evaluatorListCount;
                }
            }
            if (!this.children.isEmpty()) {
                if (this.children.size() == 1) {
                    ++trieData.singleChildNodeCount;
                }
                for (Map.Entry<Character, TrieNode<U>> entry : this.children.entrySet()) {
                    TrieNode<U> child = entry.getValue();
                    child.populateTrieData(trieData);
                }
            } else {
                ++trieData.leafNodeCount;
            }
        }

        int getMaxDepth() {
            int ret = 0;
            for (Map.Entry<Character, TrieNode<U>> entry : this.children.entrySet()) {
                TrieNode<U> child = entry.getValue();
                int maxChildDepth = child.getMaxDepth();
                if (maxChildDepth <= ret) continue;
                ret = maxChildDepth;
            }
            return ret + 1;
        }

        TrieNode<U> getOrCreateChild(String str) {
            int len = str.length();
            TrieNode<U> child = this.children.get(RangerResourceTrie.this.getLookupChar(str, 0));
            if (child == null) {
                child = new TrieNode<U>(str);
                this.addChild(child);
            } else {
                boolean isExactMatch;
                String childStr = child.getStr();
                int childStrLen = childStr.length();
                boolean bl = isExactMatch = RangerResourceTrie.this.optIgnoreCase ? StringUtils.equalsIgnoreCase((String)childStr, (String)str) : StringUtils.equals((String)childStr, (String)str);
                if (!isExactMatch) {
                    int index;
                    int numOfCharactersToMatch = Math.min(childStrLen, len);
                    for (index = 1; index < numOfCharactersToMatch && RangerResourceTrie.this.getLookupChar(childStr, index) == RangerResourceTrie.this.getLookupChar(str, index); ++index) {
                    }
                    if (index == numOfCharactersToMatch) {
                        if (childStrLen > len) {
                            TrieNode<U> newChild = new TrieNode<U>(str);
                            this.addChild(newChild);
                            child.setStr(childStr.substring(index));
                            super.addChild(child);
                            child = newChild;
                        } else {
                            child = child.getOrCreateChild(str.substring(index));
                        }
                    } else {
                        String matchedPart = str.substring(0, index);
                        TrieNode<U> newChild = new TrieNode<U>(matchedPart);
                        this.addChild(newChild);
                        child.setStr(childStr.substring(index));
                        super.addChild(child);
                        child = newChild.getOrCreateChild(str.substring(index));
                    }
                }
            }
            return child;
        }

        private void addChild(TrieNode<U> child) {
            this.children.put(RangerResourceTrie.this.getLookupChar(child.getStr(), 0), child);
            child.setParent(this);
        }

        void addEvaluator(U evaluator) {
            if (this.evaluators == null) {
                this.evaluators = new HashSet<U>();
            }
            this.evaluators.add(evaluator);
        }

        void addWildcardEvaluator(U evaluator) {
            this.undoSetup();
            if (this.wildcardEvaluators == null) {
                this.wildcardEvaluators = new HashSet<U>();
            }
            if (!this.wildcardEvaluators.contains(evaluator)) {
                this.wildcardEvaluators.add(evaluator);
            }
        }

        void removeEvaluator(U evaluator) {
            if (CollectionUtils.isNotEmpty(this.evaluators) && this.evaluators.contains(evaluator)) {
                this.evaluators.remove(evaluator);
                if (CollectionUtils.isEmpty(this.evaluators)) {
                    this.evaluators = null;
                }
            }
        }

        void removeWildcardEvaluator(U evaluator) {
            if (CollectionUtils.isNotEmpty(this.wildcardEvaluators)) {
                this.wildcardEvaluators.remove(evaluator);
                if (CollectionUtils.isEmpty(this.wildcardEvaluators)) {
                    this.wildcardEvaluators = null;
                }
            }
        }

        void undoSetup() {
            if (this.isSetup) {
                for (TrieNode<U> child : this.children.values()) {
                    child.undoSetup();
                }
                if (this.evaluators != null) {
                    if (this.evaluators == this.wildcardEvaluators) {
                        this.evaluators = null;
                    } else if (this.wildcardEvaluators != null) {
                        this.evaluators.removeAll(this.wildcardEvaluators);
                        if (CollectionUtils.isEmpty(this.evaluators)) {
                            this.evaluators = null;
                        }
                    }
                }
                if (this.wildcardEvaluators != null) {
                    if (this.isSharingParentWildcardEvaluators) {
                        this.wildcardEvaluators = null;
                    } else {
                        Set<U> parentWildcardEvaluators;
                        Set<U> set = parentWildcardEvaluators = this.getParent() == null ? null : this.getParent().getWildcardEvaluators();
                        if (parentWildcardEvaluators != null) {
                            this.wildcardEvaluators.removeAll(parentWildcardEvaluators);
                            if (CollectionUtils.isEmpty(this.wildcardEvaluators)) {
                                this.wildcardEvaluators = null;
                            }
                        }
                    }
                }
                this.isSharingParentWildcardEvaluators = false;
                this.isSetup = false;
            }
        }

        void removeSelfFromTrie() {
            TrieNode<U> parent;
            if (this.evaluators == null && this.wildcardEvaluators == null && this.children.size() == 0 && (parent = this.getParent()) != null) {
                parent.children.remove(Character.valueOf(this.str.charAt(0)));
            }
        }

        void wrapUpUpdate() {
            if (RangerResourceTrie.this.isOptimizedForRetrieval) {
                RangerPerfTracer postSetupPerf = null;
                if (RangerPerfTracer.isPerfTraceEnabled(PERF_TRIE_INIT_LOG)) {
                    postSetupPerf = RangerPerfTracer.getPerfTracer(PERF_TRIE_INIT_LOG, "RangerResourceTrie.init(name=" + RangerResourceTrie.this.resourceDef.getName() + "-postSetup)");
                }
                this.postSetup(null);
                RangerPerfTracer.logAlways(postSetupPerf);
            }
        }

        void postSetup(Set<U> parentWildcardEvaluators) {
            this.setup(parentWildcardEvaluators);
            for (Map.Entry<Character, TrieNode<U>> entry : this.children.entrySet()) {
                TrieNode<U> child = entry.getValue();
                child.postSetup(this.wildcardEvaluators);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setupIfNeeded(TrieNode<U> parent) {
            boolean setupNeeded;
            boolean bl = setupNeeded = !this.isSetup;
            if (setupNeeded) {
                Map<Character, TrieNode<U>> map = this.children;
                synchronized (map) {
                    boolean bl2 = setupNeeded = !this.isSetup;
                    if (setupNeeded) {
                        this.setup(parent == null ? null : parent.getWildcardEvaluators());
                        if (TRACE_LOG.isTraceEnabled()) {
                            StringBuilder sb = new StringBuilder();
                            this.toString(sb);
                            TRACE_LOG.trace("Set up is completed for this TriNode as a part of access evaluation : [" + sb + "]");
                        }
                    }
                }
            }
        }

        void setup(Set<U> parentWildcardEvaluators) {
            if (!this.isSetup) {
                if (parentWildcardEvaluators != null) {
                    if (CollectionUtils.isEmpty(this.wildcardEvaluators)) {
                        this.wildcardEvaluators = parentWildcardEvaluators;
                    } else {
                        for (RangerResourceEvaluator evaluator : parentWildcardEvaluators) {
                            this.addWildcardEvaluator(evaluator);
                        }
                    }
                }
                boolean bl = this.isSharingParentWildcardEvaluators = this.wildcardEvaluators == parentWildcardEvaluators;
                if (this.wildcardEvaluators != null) {
                    if (CollectionUtils.isEmpty(this.evaluators)) {
                        this.evaluators = this.wildcardEvaluators;
                    } else {
                        for (RangerResourceEvaluator evaluator : this.wildcardEvaluators) {
                            this.addEvaluator(evaluator);
                        }
                    }
                }
                this.isSetup = true;
            }
        }

        void collectChildEvaluators(Character sep, int startIdx, Set<U> childEvaluators) {
            int sepPos;
            if (!RangerResourceTrie.this.isOptimizedForSpace) {
                this.setupIfNeeded(this.getParent());
            }
            int n = sepPos = startIdx < this.str.length() ? this.str.indexOf(sep.charValue(), startIdx) : -1;
            if (sepPos == -1) {
                if (RangerResourceTrie.this.isOptimizedForSpace && this.wildcardEvaluators != null) {
                    childEvaluators.addAll(this.wildcardEvaluators);
                }
                if (this.evaluators != null) {
                    childEvaluators.addAll(this.evaluators);
                }
                this.children.values().stream().forEach(c -> c.collectChildEvaluators(sep, 0, childEvaluators));
            } else if (sepPos == this.str.length() - 1) {
                if (RangerResourceTrie.this.isOptimizedForSpace && this.wildcardEvaluators != null) {
                    childEvaluators.addAll(this.wildcardEvaluators);
                }
                if (this.evaluators != null) {
                    childEvaluators.addAll(this.evaluators);
                }
            }
        }

        private void removeEvaluatorFromSubtree(U evaluator) {
            if (CollectionUtils.isNotEmpty(this.wildcardEvaluators) && this.wildcardEvaluators.contains(evaluator)) {
                this.undoSetup();
                this.removeWildcardEvaluator(evaluator);
            } else {
                this.removeEvaluator(evaluator);
            }
            this.removeSelfFromTrie();
        }

        void toString(StringBuilder sb) {
            String nodeValue = this.str;
            sb.append("nodeValue=").append(nodeValue);
            sb.append("; isSetup=").append(this.isSetup);
            sb.append("; isSharingParentWildcardEvaluators=").append(this.isSharingParentWildcardEvaluators);
            sb.append("; childCount=").append(this.children.size());
            sb.append("; evaluators=[ ");
            if (this.evaluators != null) {
                for (RangerResourceEvaluator evaluator : this.evaluators) {
                    sb.append(evaluator.getId()).append(" ");
                }
            }
            sb.append("]");
            sb.append("; wildcardEvaluators=[ ");
            if (this.wildcardEvaluators != null) {
                for (RangerResourceEvaluator evaluator : this.wildcardEvaluators) {
                    sb.append(evaluator.getId()).append(" ");
                }
            }
            sb.append("]");
        }

        void toString(String prefix, StringBuilder sb) {
            String nodeValue = prefix + (this.str != null ? this.str : "");
            sb.append(prefix);
            this.toString(sb);
            sb.append("]\n");
            for (Map.Entry<Character, TrieNode<U>> entry : this.children.entrySet()) {
                TrieNode<U> child = entry.getValue();
                child.toString(nodeValue, sb);
            }
        }
    }

    static class TrieData {
        int nodeCount;
        int leafNodeCount;
        int singleChildNodeCount;
        int maxDepth;
        int evaluatorListCount;
        int wildcardEvaluatorListCount;
        int evaluatorListRefCount;
        int wildcardEvaluatorListRefCount;

        TrieData() {
        }
    }

    class ResourceTrieBuilderThread
    extends Thread {
        private final TrieNode<T> thisRoot;
        private final BlockingQueue<org.apache.ranger.plugin.policyengine.RangerResourceTrie$ResourceTrieBuilderThread.WorkItem> workQueue;

        ResourceTrieBuilderThread() {
            this.thisRoot = new TrieNode(null);
            this.workQueue = new LinkedBlockingQueue<org.apache.ranger.plugin.policyengine.RangerResourceTrie$ResourceTrieBuilderThread.WorkItem>();
        }

        void add(String resourceName, boolean isRecursive, T evaluator) throws InterruptedException {
            this.workQueue.put((org.apache.ranger.plugin.policyengine.RangerResourceTrie$ResourceTrieBuilderThread.WorkItem)new WorkItem(this, resourceName, isRecursive, evaluator));
        }

        Map<Character, TrieNode<T>> getSubtrees() {
            return this.thisRoot.getChildren();
        }

        @Override
        public void run() {
            block6: {
                WorkItem workItem;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Running " + this);
                }
                while (true) {
                    try {
                        workItem = (WorkItem)this.workQueue.take();
                    }
                    catch (InterruptedException exception) {
                        LOG.error("Thread=" + this + " is interrupted", (Throwable)exception);
                        break block6;
                    }
                    if (workItem.evaluator == null) break;
                    RangerResourceTrie.this.insert(this.thisRoot, workItem.resourceName, workItem.isRecursive, workItem.evaluator);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Received termination signal. " + workItem);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Exiting " + this);
            }
        }

        static class WorkItem {
            final String resourceName;
            final boolean isRecursive;
            final T evaluator;
            final /* synthetic */ ResourceTrieBuilderThread this$1;

            WorkItem(String resourceName, boolean isRecursive, T evaluator) {
                this.this$1 = this$1;
                this.resourceName = resourceName;
                this.isRecursive = isRecursive;
                this.evaluator = evaluator;
            }

            public String toString() {
                return "resourceName=" + this.resourceName + "isRecursive=" + this.isRecursive + "evaluator=" + (this.evaluator != null ? Long.valueOf(this.evaluator.getId()) : null);
            }
        }
    }
}

