/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.conditionevaluator;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.ranger.plugin.conditionevaluator.RangerAbstractConditionEvaluator;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerRequestScriptEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerNoneOfExpectedTagsPresentConditionEvaluator
extends RangerAbstractConditionEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(RangerNoneOfExpectedTagsPresentConditionEvaluator.class);
    private final Set<String> policyConditionTags = new HashSet<String>();

    @Override
    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerNoneOfExpectedTagsPresentConditionEvaluator.init(" + this.condition + ")");
        }
        super.init();
        if (this.condition != null) {
            for (String value : this.condition.getValues()) {
                this.policyConditionTags.add(value.trim());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerNoneOfExpectedTagsPresentConditionEvaluator.init(" + this.condition + "): Tags[" + this.policyConditionTags + "]");
        }
    }

    @Override
    public boolean isMatched(RangerAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerNoneOfExpectedTagsPresentConditionEvaluator.isMatched(" + request + ")");
        }
        boolean matched = true;
        RangerRequestScriptEvaluator evaluator = new RangerRequestScriptEvaluator(request);
        Set<String> resourceTags = evaluator.getAllTagTypes();
        if (resourceTags != null) {
            matched = Collections.disjoint(resourceTags, this.policyConditionTags);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerNoneOfExpectedTagsPresentConditionEvaluator.isMatched(" + request + "): " + matched);
        }
        return matched;
    }
}

