/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.util;

import java.util.regex.PatternSyntaxException;

public class Glob {
    private static final String REGEX_META_CHARS = ".^$+{[]|()";
    private static final String GLOB_META_CHARS = "\\*?[{";

    public static String toRegexPattern(String globPattern) {
        boolean inGroup = false;
        StringBuilder regex = new StringBuilder("^");
        int i = 0;
        block10: while (i < globPattern.length()) {
            char c = globPattern.charAt(i++);
            switch (c) {
                case '\\': {
                    char next;
                    if (i == globPattern.length()) {
                        throw new PatternSyntaxException("No character to escape", globPattern, i - 1);
                    }
                    if (Glob.isGlobMeta(next = globPattern.charAt(i++)) || Glob.isRegexMeta(next)) {
                        regex.append('\\');
                    }
                    regex.append(next);
                    continue block10;
                }
                case '/': {
                    regex.append(c);
                    continue block10;
                }
                case '[': {
                    regex.append("[[^/]&&[");
                    if (Glob.next(globPattern, i) == '^') {
                        regex.append("\\^");
                        ++i;
                    } else {
                        if (Glob.next(globPattern, i) == '!') {
                            regex.append('^');
                            ++i;
                        }
                        if (Glob.next(globPattern, i) == '-') {
                            regex.append('-');
                            ++i;
                        }
                    }
                    boolean hasRangeStart = false;
                    char last = '\u0000';
                    while (i < globPattern.length() && (c = globPattern.charAt(i++)) != ']') {
                        if (c == '/') {
                            throw new PatternSyntaxException("Explicit 'name separator' in class", globPattern, i - 1);
                        }
                        if (c == '\\' || c == '[' || c == '&' && Glob.next(globPattern, i) == '&') {
                            regex.append('\\');
                        }
                        regex.append(c);
                        if (c == '-') {
                            if (!hasRangeStart) {
                                throw new PatternSyntaxException("Invalid range", globPattern, i - 1);
                            }
                            if ((c = Glob.next(globPattern, i++)) == '\u0000' || c == ']') break;
                            if (c < last) {
                                throw new PatternSyntaxException("Invalid range", globPattern, i - 3);
                            }
                            regex.append(c);
                            hasRangeStart = false;
                            continue;
                        }
                        hasRangeStart = true;
                        last = c;
                    }
                    if (c != ']') {
                        throw new PatternSyntaxException("Missing ']", globPattern, i - 1);
                    }
                    regex.append("]]");
                    continue block10;
                }
                case '{': {
                    if (inGroup) {
                        throw new PatternSyntaxException("Cannot nest groups", globPattern, i - 1);
                    }
                    regex.append("(?:(?:");
                    inGroup = true;
                    continue block10;
                }
                case '}': {
                    if (inGroup) {
                        regex.append("))");
                        inGroup = false;
                        continue block10;
                    }
                    regex.append('}');
                    continue block10;
                }
                case ',': {
                    if (inGroup) {
                        regex.append(")|(?:");
                        continue block10;
                    }
                    regex.append(',');
                    continue block10;
                }
                case '*': {
                    if (Glob.next(globPattern, i) == '*') {
                        regex.append(".*");
                        ++i;
                        continue block10;
                    }
                    regex.append("[^/]*");
                    continue block10;
                }
                case '?': {
                    regex.append("[^/]");
                    continue block10;
                }
            }
            if (Glob.isRegexMeta(c)) {
                regex.append('\\');
            }
            regex.append(c);
        }
        if (inGroup) {
            throw new PatternSyntaxException("Missing '}", globPattern, i - 1);
        }
        return regex.append('$').toString();
    }

    private static boolean isRegexMeta(char c) {
        return REGEX_META_CHARS.indexOf(c) != -1;
    }

    private static boolean isGlobMeta(char c) {
        return GLOB_META_CHARS.indexOf(c) != -1;
    }

    private static char next(String glob, int i) {
        return i < glob.length() ? glob.charAt(i) : (char)'\u0000';
    }
}

