/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.info;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.openjdk.jol.info.GraphPathRecord;
import org.openjdk.jol.info.GraphVisitor;

public class GraphWalker {
    private final Set<Object> visited;
    private final Object root;
    private final Collection<GraphVisitor> visitors;

    public GraphWalker(Object root) {
        this.root = root;
        this.visited = Collections.newSetFromMap(new IdentityHashMap());
        this.visitors = new ArrayList<GraphVisitor>();
    }

    public void addVisitor(GraphVisitor v) {
        this.visitors.add(v);
    }

    public void walk() {
        ArrayList<GraphPathRecord> curLayer = new ArrayList<GraphPathRecord>();
        ArrayList<GraphPathRecord> newLayer = new ArrayList<GraphPathRecord>();
        GraphPathRecord e = new GraphPathRecord("", this.root, 0);
        this.visited.add(this.root);
        this.visitObject(e);
        curLayer.add(e);
        while (!curLayer.isEmpty()) {
            newLayer.clear();
            for (GraphPathRecord next : curLayer) {
                for (GraphPathRecord ref : this.peelReferences(next)) {
                    if (ref == null || !this.visited.add(ref.obj())) continue;
                    this.visitObject(ref);
                    newLayer.add(ref);
                }
            }
            curLayer.clear();
            curLayer.addAll(newLayer);
        }
    }

    private void visitObject(GraphPathRecord record) {
        for (GraphVisitor v : this.visitors) {
            v.visit(record);
        }
    }

    private List<GraphPathRecord> peelReferences(GraphPathRecord r) {
        ArrayList<GraphPathRecord> result = new ArrayList<GraphPathRecord>();
        Object o = r.obj();
        if (o.getClass().isArray() && !o.getClass().getComponentType().isPrimitive()) {
            int c = 0;
            for (Object e : (Object[])o) {
                if (e != null) {
                    result.add(new GraphPathRecord(r.path() + "[" + c + "]", e, r.depth() + 1));
                }
                ++c;
            }
        }
        for (Field f : this.getAllFields(o.getClass())) {
            f.setAccessible(true);
            if (f.getType().isPrimitive() || Modifier.isStatic(f.getModifiers())) continue;
            try {
                Object e = f.get(o);
                if (e == null) continue;
                result.add(new GraphPathRecord(r.path() + "." + f.getName(), e, r.depth() + 1));
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
        return result;
    }

    private Collection<Field> getAllFields(Class<?> klass) {
        ArrayList<Field> results = new ArrayList<Field>();
        for (Field f : klass.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers())) continue;
            results.add(f);
        }
        Class<?> superKlass = klass;
        while ((superKlass = superKlass.getSuperclass()) != null) {
            for (Field f : superKlass.getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers())) continue;
                results.add(f);
            }
        }
        return results;
    }
}

