/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.EnumSet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet2.HamletImpl;
import org.apache.hadoop.yarn.webapp.hamlet2.HamletSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyUtils.class);
    public static final String E_HTTP_HTTPS_ONLY = "This filter only works for HTTP/HTTPS";
    public static final String LOCATION = "Location";

    public static void sendRedirect(HttpServletRequest request, HttpServletResponse response, String target) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Redirecting {} {} to {}", new Object[]{request.getMethod(), request.getRequestURI(), target});
        }
        String location = response.encodeRedirectURL(target);
        response.setStatus(302);
        response.setHeader(LOCATION, location);
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter writer = response.getWriter();
        Page p = new Page(writer);
        ((Hamlet.HTML)((Hamlet.BODY)((Hamlet.HTML)p.html().head().title("Moved").__()).body().h1("Moved").div().__(new Object[]{"Content has moved "}).a(location, "here").__()).__()).__();
        writer.close();
    }

    public static void notFound(HttpServletResponse resp, String message) throws IOException {
        resp.setStatus(404);
        resp.setContentType("text/html; charset=UTF-8");
        Page p = new Page(resp.getWriter());
        p.html().h1(message).__();
    }

    public static void rejectNonHttpRequests(ServletRequest req) throws ServletException {
        if (!(req instanceof HttpServletRequest)) {
            throw new ServletException(E_HTTP_HTTPS_ONLY);
        }
    }

    public static class Page
    extends Hamlet {
        Page(PrintWriter out) {
            super(out, 0, false);
        }

        public Hamlet.HTML<__> html() {
            return new Hamlet.HTML((Hamlet)this, "html", null, EnumSet.of(HamletImpl.EOpt.ENDTAG));
        }
    }

    public static class __
    implements HamletSpec.__ {
    }
}

