/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.fileset;

import com.codahale.metrics.caffeine.MetricsStatsCounter;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.Schema;
import org.apache.gravitino.SchemaChange;
import org.apache.gravitino.StringIdentifier;
import org.apache.gravitino.audit.CallerContext;
import org.apache.gravitino.audit.FilesetDataOperation;
import org.apache.gravitino.catalog.FilesetFileOps;
import org.apache.gravitino.catalog.ManagedSchemaOperations;
import org.apache.gravitino.catalog.fileset.FilesetImpl;
import org.apache.gravitino.catalog.hadoop.fs.FileSystemProvider;
import org.apache.gravitino.catalog.hadoop.fs.FileSystemUtils;
import org.apache.gravitino.connector.CatalogInfo;
import org.apache.gravitino.connector.CatalogOperations;
import org.apache.gravitino.connector.HasPropertyMetadata;
import org.apache.gravitino.dto.file.FileInfoDTO;
import org.apache.gravitino.exceptions.AlreadyExistsException;
import org.apache.gravitino.exceptions.FilesetAlreadyExistsException;
import org.apache.gravitino.exceptions.GravitinoRuntimeException;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.exceptions.NoSuchFilesetException;
import org.apache.gravitino.exceptions.NoSuchLocationNameException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NonEmptySchemaException;
import org.apache.gravitino.exceptions.SchemaAlreadyExistsException;
import org.apache.gravitino.file.FileInfo;
import org.apache.gravitino.file.Fileset;
import org.apache.gravitino.file.FilesetCatalog;
import org.apache.gravitino.file.FilesetChange;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.FilesetEntity;
import org.apache.gravitino.meta.SchemaEntity;
import org.apache.gravitino.metrics.MetricsSystem;
import org.apache.gravitino.metrics.source.FilesetCatalogMetricsSource;
import org.apache.gravitino.metrics.source.MetricsSource;
import org.apache.gravitino.utils.NamespaceUtil;
import org.apache.gravitino.utils.PrincipalUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesetCatalogOperations
extends ManagedSchemaOperations
implements CatalogOperations,
FilesetCatalog,
FilesetFileOps {
    private static final String SCHEMA_DOES_NOT_EXIST_MSG = "Schema %s does not exist";
    private static final String FILESET_DOES_NOT_EXIST_MSG = "Fileset %s does not exist";
    private static final String SLASH = "/";
    private static final Pattern LOCATION_PLACEHOLDER_PATTERN = Pattern.compile("\\{\\{(.*?)\\}\\}");
    private static final Logger LOG = LoggerFactory.getLogger(FilesetCatalogOperations.class);
    private final EntityStore store;
    private HasPropertyMetadata propertiesMetadata;
    @VisibleForTesting
    Configuration hadoopConf;
    @VisibleForTesting
    Map<String, Path> catalogStorageLocations;
    @VisibleForTesting
    Map<String, String> conf;
    private CatalogInfo catalogInfo;
    private Map<String, FileSystemProvider> fileSystemProvidersMap;
    private FileSystemProvider defaultFileSystemProvider;
    private boolean disableFSOps;
    private FilesetCatalogMetricsSource catalogMetricsSource;
    @VisibleForTesting
    ScheduledThreadPoolExecutor scheduler;
    @VisibleForTesting
    Cache<FileSystemCacheKey, FileSystem> fileSystemCache;
    private final ThreadPoolExecutor fileSystemExecutor = new ThreadPoolExecutor(Math.max(2, Math.min(Runtime.getRuntime().availableProcessors() * 2, 16)), Math.max(2, Math.min(Runtime.getRuntime().availableProcessors() * 2, 32)), 5L, TimeUnit.SECONDS, new ArrayBlockingQueue(1000), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("fileset-filesystem-getter-pool-%d").build(), new ThreadPoolExecutor.AbortPolicy()){
        {
            this.allowCoreThreadTimeOut(true);
        }
    };

    FilesetCatalogOperations(EntityStore store) {
        this.store = store;
    }

    public FilesetCatalogOperations() {
        this(GravitinoEnv.getInstance().entityStore());
    }

    public EntityStore store() {
        return this.store;
    }

    public CatalogInfo getCatalogInfo() {
        return this.catalogInfo;
    }

    public Map<String, String> getConf() {
        return this.conf;
    }

    public void initialize(Map<String, String> config, CatalogInfo info, HasPropertyMetadata propertiesMetadata) throws RuntimeException {
        this.propertiesMetadata = propertiesMetadata;
        this.catalogInfo = info;
        this.conf = config;
        this.disableFSOps = (Boolean)propertiesMetadata.catalogPropertiesMetadata().getOrDefault(config, "disable-filesystem-ops");
        MetricsSystem metricsSystem = GravitinoEnv.getInstance().metricsSystem();
        if (metricsSystem != null) {
            this.catalogMetricsSource = new FilesetCatalogMetricsSource(this.catalogInfo.namespace().toString(), this.catalogInfo.name());
        }
        if (!this.disableFSOps) {
            String fileSystemProviders = (String)propertiesMetadata.catalogPropertiesMetadata().getOrDefault(config, "filesystem-providers");
            this.fileSystemProvidersMap = ImmutableMap.builder().putAll(FileSystemUtils.getFileSystemProviders((String)fileSystemProviders)).build();
            String defaultFileSystemProviderName = (String)propertiesMetadata.catalogPropertiesMetadata().getOrDefault(config, "default-filesystem-provider");
            this.defaultFileSystemProvider = FileSystemUtils.getFileSystemProviderByName(this.fileSystemProvidersMap, (String)defaultFileSystemProviderName);
            this.scheduler = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("file-system-cache-for-fileset-%d").build());
            Caffeine cacheBuilder = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).removalListener((ignored, value, cause) -> {
                try {
                    ((FileSystem)value).close();
                }
                catch (IOException e) {
                    LOG.warn("Failed to close FileSystem instance in cache", (Throwable)e);
                }
            }).scheduler(Scheduler.forScheduledExecutorService((ScheduledExecutorService)this.scheduler));
            if (metricsSystem != null) {
                cacheBuilder.recordStats(() -> new MetricsStatsCounter(this.catalogMetricsSource.getMetricRegistry(), "filesystem-cache"));
            }
            this.fileSystemCache = cacheBuilder.build();
        }
        this.catalogStorageLocations = this.getAndCheckCatalogStorageLocations(config);
        if (metricsSystem != null) {
            metricsSystem.register((MetricsSource)this.catalogMetricsSource);
        }
    }

    public NameIdentifier[] listFilesets(Namespace namespace) throws NoSuchSchemaException {
        try {
            NameIdentifier schemaIdent = NameIdentifier.of((String[])namespace.levels());
            if (!this.store.exists(schemaIdent, Entity.EntityType.SCHEMA)) {
                throw new NoSuchSchemaException(SCHEMA_DOES_NOT_EXIST_MSG, new Object[]{schemaIdent});
            }
            List filesets = this.store.list(namespace, FilesetEntity.class, Entity.EntityType.FILESET);
            return (NameIdentifier[])filesets.stream().map(f -> NameIdentifier.of((Namespace)namespace, (String)f.name())).toArray(NameIdentifier[]::new);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to list filesets under namespace " + String.valueOf(namespace), e);
        }
    }

    public Fileset loadFileset(NameIdentifier ident) throws NoSuchFilesetException {
        try {
            FilesetEntity filesetEntity = (FilesetEntity)this.store.get(ident, Entity.EntityType.FILESET, FilesetEntity.class);
            return ((FilesetImpl.Builder)((FilesetImpl.Builder)((FilesetImpl.Builder)((FilesetImpl.Builder)((FilesetImpl.Builder)((FilesetImpl.Builder)FilesetImpl.builder().withName(ident.name())).withType(filesetEntity.filesetType())).withComment(filesetEntity.comment())).withStorageLocations(filesetEntity.storageLocations())).withProperties(filesetEntity.properties())).withAuditInfo(filesetEntity.auditInfo())).build();
        }
        catch (NoSuchEntityException exception) {
            throw new NoSuchFilesetException((Throwable)exception, FILESET_DOES_NOT_EXIST_MSG, new Object[]{ident});
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to load fileset %s" + String.valueOf(ident), ioe);
        }
    }

    public FileInfo[] listFiles(NameIdentifier filesetIdent, String locationName, String subPath) throws NoSuchFilesetException, IOException {
        FileSystem fileSystem;
        if (this.disableFSOps) {
            LOG.warn("Filesystem operations disabled, rejecting listFiles for {}", (Object)filesetIdent);
            throw new UnsupportedOperationException("Filesystem operations are disabled on this server");
        }
        String actualPath = this.getFileLocation(filesetIdent, subPath, locationName);
        Path formalizedPath = new Path(actualPath).makeQualified((fileSystem = this.getFileSystemWithCache(new Path(actualPath), this.conf)).getUri(), fileSystem.getWorkingDirectory());
        FileSystem fs = this.getFileSystemWithCache(formalizedPath, this.conf);
        if (!fs.exists(formalizedPath)) {
            throw new IllegalArgumentException(String.format("Path %s does not exist in fileset %s", formalizedPath.toString(), filesetIdent));
        }
        String catalogName = filesetIdent.namespace().level(1);
        String schemaName = filesetIdent.namespace().level(2);
        String filesetName = filesetIdent.name();
        try {
            return (FileInfo[])Arrays.stream(fs.listStatus(formalizedPath)).map(status -> FileInfoDTO.builder().name(status.getPath().getName()).isDir(status.isDirectory()).size(status.isDirectory() ? 0L : status.getLen()).lastModified(status.getModificationTime()).path(this.buildGVFSFilePath(catalogName, schemaName, filesetName, subPath)).build()).toArray(FileInfo[]::new);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to list files in fileset" + String.valueOf(filesetIdent), e);
        }
    }

    public Fileset createMultipleLocationFileset(NameIdentifier ident, String comment, Fileset.Type type, Map<String, String> storageLocations, Map<String, String> properties) throws NoSuchSchemaException, FilesetAlreadyExistsException {
        Map<String, Path> schemaPaths;
        SchemaEntity schemaEntity;
        storageLocations.forEach((name, path) -> {
            if (StringUtils.isBlank((CharSequence)name)) {
                throw new IllegalArgumentException("Location name must not be blank");
            }
            if (StringUtils.isBlank((CharSequence)path)) {
                throw new IllegalArgumentException("Storage location must not be blank for location name: " + name);
            }
        });
        try {
            if (this.store.exists(ident, Entity.EntityType.FILESET)) {
                throw new FilesetAlreadyExistsException("Fileset %s already exists", new Object[]{ident});
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to check if fileset " + String.valueOf(ident) + " exists", ioe);
        }
        NameIdentifier schemaIdent = NameIdentifier.of((String[])ident.namespace().levels());
        try {
            schemaEntity = (SchemaEntity)this.store.get(schemaIdent, Entity.EntityType.SCHEMA, SchemaEntity.class);
        }
        catch (NoSuchEntityException exception) {
            throw new NoSuchSchemaException((Throwable)exception, SCHEMA_DOES_NOT_EXIST_MSG, new Object[]{schemaIdent});
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to load schema " + String.valueOf(schemaIdent), ioe);
        }
        if (type == Fileset.Type.EXTERNAL) {
            if (storageLocations.isEmpty()) {
                throw new IllegalArgumentException("Storage location must be set for external fileset " + String.valueOf(ident));
            }
            storageLocations.forEach((locationName, location) -> {
                if (StringUtils.isBlank((CharSequence)location)) {
                    throw new IllegalArgumentException("Storage location must be set for external fileset " + String.valueOf(ident) + " with location name " + locationName);
                }
            });
        }
        if ((schemaPaths = this.getAndCheckSchemaPaths(schemaIdent.name(), schemaEntity.properties())).isEmpty() && storageLocations.isEmpty()) {
            throw new IllegalArgumentException("Storage location must be set for fileset " + String.valueOf(ident) + " when it's catalog and schema location are not set");
        }
        storageLocations.forEach((k, location) -> this.checkPlaceholderValue((String)location));
        Map<String, Path> filesetPaths = this.calculateFilesetPaths(schemaIdent.name(), ident.name(), storageLocations, schemaPaths, properties);
        properties = this.setDefaultLocationIfAbsent(properties, filesetPaths);
        ImmutableMap.Builder filesetPathsBuilder = ImmutableMap.builder();
        if (this.disableFSOps) {
            filesetPaths.forEach((locationName, location) -> {
                if (location.toUri().getScheme() == null) {
                    throw new IllegalArgumentException("Storage location must have scheme for fileset if filesystem operations are disabled in the server side, location: " + String.valueOf(location) + ", location name: " + locationName);
                }
                filesetPathsBuilder.put(locationName, location);
            });
        } else {
            try {
                for (Map.Entry<String, Path> entry : filesetPaths.entrySet()) {
                    HashMap<String, String> fsConf = new HashMap<String, String>(this.conf);
                    fsConf.putAll(schemaEntity.properties());
                    fsConf.putAll(properties);
                    FileSystem tmpFs = this.getFileSystemWithCache(entry.getValue(), fsConf);
                    Path formalizePath = entry.getValue().makeQualified(tmpFs.getUri(), tmpFs.getWorkingDirectory());
                    filesetPathsBuilder.put((Object)entry.getKey(), (Object)formalizePath);
                    FileSystem fs = this.getFileSystemWithCache(formalizePath, fsConf);
                    if (fs.exists(formalizePath) && fs.getFileStatus(formalizePath).isFile()) {
                        throw new IllegalArgumentException("Fileset location cannot be a file: " + String.valueOf(formalizePath) + ", location name: " + entry.getKey());
                    }
                    if (!fs.exists(formalizePath)) {
                        if (!fs.mkdirs(formalizePath)) {
                            throw new RuntimeException("Failed to create fileset " + String.valueOf(ident) + " location " + String.valueOf(formalizePath) + " with location name " + entry.getKey());
                        }
                        LOG.info("Created fileset {} location {} with location name {}", new Object[]{ident, formalizePath, entry.getKey()});
                        continue;
                    }
                    LOG.info("Fileset {} manages the existing location {} with location name {}", new Object[]{ident, formalizePath, entry.getKey()});
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException("Failed to create fileset " + String.valueOf(ident), ioe);
            }
        }
        Map formattedStorageLocations = Maps.transformValues((Map)filesetPathsBuilder.build(), Path::toString);
        this.validateLocationHierarchy(Maps.transformValues(schemaPaths, Path::toString), formattedStorageLocations);
        StringIdentifier stringId = StringIdentifier.fromProperties(properties);
        Preconditions.checkArgument((stringId != null ? 1 : 0) != 0, (Object)"Property String identifier should not be null");
        FilesetEntity filesetEntity = FilesetEntity.builder().withName(ident.name()).withId(Long.valueOf(stringId.id())).withNamespace(ident.namespace()).withComment(comment).withFilesetType(type).withStorageLocations(formattedStorageLocations).withProperties(properties).withAuditInfo(AuditInfo.builder().withCreator(PrincipalUtils.getCurrentPrincipal().getName()).withCreateTime(Instant.now()).build()).build();
        try {
            this.store.put((Entity)filesetEntity, true);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to create fileset " + String.valueOf(ident), ioe);
        }
        return ((FilesetImpl.Builder)((FilesetImpl.Builder)((FilesetImpl.Builder)((FilesetImpl.Builder)((FilesetImpl.Builder)((FilesetImpl.Builder)FilesetImpl.builder().withName(ident.name())).withComment(comment)).withType(type)).withStorageLocations(formattedStorageLocations)).withProperties(filesetEntity.properties())).withAuditInfo(filesetEntity.auditInfo())).build();
    }

    private Map<String, String> setDefaultLocationIfAbsent(Map<String, String> properties, Map<String, Path> filesetPaths) {
        Preconditions.checkArgument((filesetPaths != null && !filesetPaths.isEmpty() ? 1 : 0) != 0, (Object)"Fileset paths must not be null or empty");
        if (filesetPaths.size() == 1) {
            String defaultLocationName = filesetPaths.keySet().iterator().next();
            if (properties == null || properties.isEmpty()) {
                return Collections.singletonMap("default-location-name", defaultLocationName);
            }
            if (!properties.containsKey("default-location-name")) {
                return ImmutableMap.builder().putAll(properties).put((Object)"default-location-name", (Object)defaultLocationName).build();
            }
            Preconditions.checkArgument((boolean)defaultLocationName.equals(properties.get("default-location-name")), (Object)"Default location name must be the same as the fileset location name");
            return ImmutableMap.copyOf(properties);
        }
        Preconditions.checkArgument((properties != null && !properties.isEmpty() && properties.containsKey("default-location-name") && filesetPaths.containsKey(properties.get("default-location-name")) ? 1 : 0) != 0, (Object)("The fileset property default-location-name must be set and must be one of the fileset locations, location names: " + String.valueOf(filesetPaths.keySet()) + ", default location name: " + (String)Optional.ofNullable(properties).map(p -> (String)p.get("default-location-name")).orElse(null)));
        return ImmutableMap.copyOf(properties);
    }

    public Fileset alterFileset(NameIdentifier ident, FilesetChange ... changes) throws NoSuchFilesetException, IllegalArgumentException {
        try {
            if (!this.store.exists(ident, Entity.EntityType.FILESET)) {
                throw new NoSuchFilesetException(FILESET_DOES_NOT_EXIST_MSG, new Object[]{ident});
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to load fileset " + String.valueOf(ident), ioe);
        }
        try {
            FilesetEntity updatedFilesetEntity = (FilesetEntity)this.store.update(ident, FilesetEntity.class, Entity.EntityType.FILESET, e -> this.updateFilesetEntity(ident, (FilesetEntity)e, changes));
            return ((FilesetImpl.Builder)((FilesetImpl.Builder)((FilesetImpl.Builder)((FilesetImpl.Builder)((FilesetImpl.Builder)((FilesetImpl.Builder)FilesetImpl.builder().withName(updatedFilesetEntity.name())).withComment(updatedFilesetEntity.comment())).withType(updatedFilesetEntity.filesetType())).withStorageLocations(updatedFilesetEntity.storageLocations())).withProperties(updatedFilesetEntity.properties())).withAuditInfo(updatedFilesetEntity.auditInfo())).build();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to update fileset " + String.valueOf(ident), ioe);
        }
        catch (NoSuchEntityException nsee) {
            throw new NoSuchFilesetException((Throwable)nsee, FILESET_DOES_NOT_EXIST_MSG, new Object[]{ident});
        }
        catch (AlreadyExistsException aee) {
            throw new RuntimeException("Fileset with the same name " + ident.name() + " already exists", aee);
        }
    }

    public boolean dropFileset(NameIdentifier ident) {
        try {
            FilesetEntity filesetEntity = (FilesetEntity)this.store.get(ident, Entity.EntityType.FILESET, FilesetEntity.class);
            if (!this.disableFSOps && filesetEntity.filesetType() == Fileset.Type.MANAGED) {
                AtomicReference exception = new AtomicReference();
                Map storageLocations = Maps.transformValues((Map)filesetEntity.storageLocations(), Path::new);
                storageLocations.forEach((locationName, location) -> {
                    try {
                        FileSystem fs = this.getFileSystemWithCache((Path)location, this.conf);
                        if (fs.exists(location)) {
                            if (!fs.delete(location, true)) {
                                LOG.warn("Failed to delete fileset {} location {} with location name {}", new Object[]{ident, location, locationName});
                            }
                        } else {
                            LOG.warn("Fileset {} location {} with location name {} does not exist", new Object[]{ident, location, locationName});
                        }
                    }
                    catch (IOException ioe) {
                        LOG.warn("Failed to delete fileset {} location {} with location name {}", new Object[]{ident, location, locationName, ioe});
                        exception.set(ioe);
                    }
                });
                if (exception.get() != null) {
                    throw (IOException)exception.get();
                }
            }
            return this.store.delete(ident, Entity.EntityType.FILESET);
        }
        catch (NoSuchEntityException ne) {
            LOG.warn("Fileset {} does not exist", (Object)ident);
            return false;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to delete fileset " + String.valueOf(ident), ioe);
        }
    }

    public String getFileLocation(NameIdentifier ident, String subPath, String locationName) throws NoSuchFilesetException, NoSuchLocationNameException {
        String fileLocation;
        Preconditions.checkArgument((subPath != null ? 1 : 0) != 0, (Object)"subPath must not be null");
        Object processedSubPath = !subPath.trim().isEmpty() && !subPath.trim().startsWith(SLASH) ? SLASH + subPath.trim() : subPath.trim();
        Fileset fileset = this.loadFileset(ident);
        String targetLocationName = locationName == null ? (fileset.storageLocations().size() == 1 ? (String)fileset.storageLocations().keySet().iterator().next() : (String)fileset.properties().get("default-location-name")) : locationName;
        if (!fileset.storageLocations().containsKey(targetLocationName)) {
            throw new NoSuchLocationNameException("Location name %s does not exist in fileset %s", new Object[]{targetLocationName, ident});
        }
        if (this.hasCallerContext()) {
            Map contextMap = CallerContext.CallerContextHolder.get().context();
            String operation = contextMap.getOrDefault("FilesetDataOperation", FilesetDataOperation.UNKNOWN.name());
            if (!FilesetDataOperation.checkValid((String)operation)) {
                LOG.warn("The data operation: {} is not valid, we cannot do some checks for this operation.", (Object)operation);
            } else {
                FilesetDataOperation dataOperation = FilesetDataOperation.valueOf((String)operation);
                switch (dataOperation) {
                    case RENAME: {
                        if (!StringUtils.isBlank((CharSequence)processedSubPath) && (!((String)processedSubPath).startsWith(SLASH) || ((String)processedSubPath).length() != 1)) break;
                        throw new GravitinoRuntimeException("subPath cannot be blank when need to rename a file or a directory.");
                    }
                }
            }
        }
        if (StringUtils.isBlank((CharSequence)processedSubPath)) {
            fileLocation = (String)fileset.storageLocations().get(targetLocationName);
        } else {
            String storageLocation = this.removeTrailingSlash((String)fileset.storageLocations().get(targetLocationName));
            fileLocation = String.format("%s%s", storageLocation, processedSubPath);
        }
        return fileLocation;
    }

    public Schema createSchema(NameIdentifier ident, String comment, Map<String, String> properties) throws NoSuchCatalogException, SchemaAlreadyExistsException {
        if (this.disableFSOps) {
            return super.createSchema(ident, comment, properties);
        }
        try {
            if (this.store.exists(ident, Entity.EntityType.SCHEMA)) {
                throw new SchemaAlreadyExistsException("Schema %s already exists", new Object[]{ident});
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to check if schema " + String.valueOf(ident) + " exists", ioe);
        }
        Map<String, Path> schemaPaths = this.getAndCheckSchemaPaths(ident.name(), properties);
        schemaPaths.forEach((locationName, schemaPath) -> {
            if (schemaPath != null && !this.containsPlaceholder(schemaPath.toString())) {
                try {
                    FileSystem fs = this.getFileSystemWithCache((Path)schemaPath, this.conf);
                    if (fs.exists(schemaPath) && fs.getFileStatus(schemaPath).isFile()) {
                        throw new IllegalArgumentException("Fileset schema location cannot be a file: " + String.valueOf(schemaPath) + ", location name: " + locationName);
                    }
                    if (!fs.exists(schemaPath)) {
                        if (!fs.mkdirs(schemaPath)) {
                            throw new RuntimeException("Failed to create schema " + String.valueOf(ident) + " location: " + String.valueOf(schemaPath) + " with location name: " + locationName);
                        }
                        LOG.info("Created schema {} location: {} with location name: {}", new Object[]{ident, schemaPath, locationName});
                    } else {
                        LOG.info("Schema {} manages the existing location: {} with location name: {}", new Object[]{ident, schemaPath, locationName});
                    }
                }
                catch (IOException ioe) {
                    throw new RuntimeException("Failed to create schema " + String.valueOf(ident) + " location " + String.valueOf(schemaPath), ioe);
                }
            }
        });
        return super.createSchema(ident, comment, properties);
    }

    public Schema alterSchema(NameIdentifier ident, SchemaChange ... changes) throws NoSuchSchemaException {
        try {
            if (!this.store.exists(ident, Entity.EntityType.SCHEMA)) {
                throw new NoSuchSchemaException(SCHEMA_DOES_NOT_EXIST_MSG, new Object[]{ident});
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to check if schema " + String.valueOf(ident) + " exists", ioe);
        }
        return super.alterSchema(ident, changes);
    }

    public boolean dropSchema(NameIdentifier ident, boolean cascade) throws NonEmptySchemaException {
        try {
            Namespace filesetNs = NamespaceUtil.ofFileset((String)ident.namespace().level(0), (String)ident.namespace().level(1), (String)ident.name());
            List filesets = this.store.list(filesetNs, FilesetEntity.class, Entity.EntityType.FILESET);
            if (!filesets.isEmpty() && !cascade) {
                throw new NonEmptySchemaException("Schema %s is not empty", new Object[]{ident});
            }
            SchemaEntity schemaEntity = (SchemaEntity)this.store.get(ident, Entity.EntityType.SCHEMA, SchemaEntity.class);
            Map<String, String> properties = Optional.ofNullable(schemaEntity.properties()).orElse(Collections.emptyMap());
            Map<String, Path> schemaPaths = this.getAndCheckSchemaPaths(ident.name(), properties);
            boolean dropped = super.dropSchema(ident, cascade);
            if (this.disableFSOps) {
                return dropped;
            }
            if (!dropped) {
                return false;
            }
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            filesets.parallelStream().filter(f -> f.filesetType() == Fileset.Type.MANAGED).forEach(f -> {
                ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(cl);
                    f.storageLocations().forEach((locationName, location) -> {
                        try {
                            Path filesetPath = new Path(location);
                            FileSystem fs = this.getFileSystemWithCache(filesetPath, this.conf);
                            if (fs.exists(filesetPath) && !fs.delete(filesetPath, true)) {
                                LOG.warn("Failed to delete fileset {} location: {} with location name: {}", new Object[]{f.name(), filesetPath, locationName});
                            }
                        }
                        catch (IOException ioe) {
                            LOG.warn("Failed to delete fileset {} location: {} with location name: {}", new Object[]{f.name(), location, locationName, ioe});
                        }
                    });
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldCl);
                }
            });
            if (!schemaPaths.isEmpty()) {
                AtomicReference exception = new AtomicReference();
                schemaPaths.forEach((locationName, schemaPath) -> {
                    try {
                        FileStatus[] statuses;
                        FileSystem fs = this.getFileSystemWithCache((Path)schemaPath, this.conf);
                        if (fs.exists(schemaPath) && (statuses = fs.listStatus(schemaPath)).length == 0) {
                            if (fs.delete(schemaPath, true)) {
                                LOG.info("Deleted schema {} location {} with location name {}", new Object[]{ident, schemaPath, locationName});
                            } else {
                                LOG.warn("Failed to delete schema {} because it has files/folders under location {} with location name {}", new Object[]{ident, schemaPath, locationName});
                            }
                        }
                    }
                    catch (IOException ioe) {
                        LOG.warn("Failed to delete schema {} location {} with location name {}", new Object[]{ident, schemaPath, locationName, ioe});
                        exception.set(new RuntimeException("Failed to delete schema " + String.valueOf(ident) + " location", ioe));
                    }
                });
                if (exception.get() != null) {
                    throw (RuntimeException)exception.get();
                }
            }
            LOG.info("Deleted schema {}", (Object)ident);
            return true;
        }
        catch (NoSuchEntityException ne) {
            LOG.warn("Schema {} does not exist", (Object)ident);
            return false;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to delete schema " + String.valueOf(ident) + " location", ioe);
        }
    }

    public void testConnection(NameIdentifier catalogIdent, Catalog.Type type, String provider, String comment, Map<String, String> properties) {
    }

    public void close() throws IOException {
        MetricsSystem metricsSystem;
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
        if (!this.fileSystemExecutor.isShutdown()) {
            this.fileSystemExecutor.shutdownNow();
        }
        if (this.fileSystemCache != null) {
            this.fileSystemCache.asMap().forEach((k, v) -> {
                try {
                    v.close();
                }
                catch (IOException e) {
                    LOG.warn("Failed to close FileSystem instance in cache", (Throwable)e);
                }
            });
            this.fileSystemCache.cleanUp();
        }
        if ((metricsSystem = GravitinoEnv.getInstance().metricsSystem()) != null) {
            metricsSystem.unregister((MetricsSource)this.catalogMetricsSource);
        }
    }

    private void validateLocationHierarchy(Map<String, String> schemaLocations, Map<String, String> filesetLocations) {
        if (schemaLocations == null || filesetLocations == null || schemaLocations.isEmpty() || filesetLocations.isEmpty()) {
            return;
        }
        filesetLocations.forEach((filesetLocationName, filesetLocation) -> schemaLocations.forEach((schemaLocationName, schemaLocation) -> {
            if (this.ensureTrailingSlash((String)schemaLocation).startsWith(this.ensureTrailingSlash((String)filesetLocation))) {
                throw new IllegalArgumentException(String.format("The fileset location %s with location name %s is not allowed to be the parent of the schema location %s with location name %s", filesetLocation, filesetLocationName, schemaLocation, schemaLocationName));
            }
        }));
    }

    private boolean existBlankValue(Map<String, String> properties, String key) {
        return properties.containsKey(key) && StringUtils.isBlank((CharSequence)properties.get(key));
    }

    private Map<String, Path> getAndCheckCatalogStorageLocations(Map<String, String> properties) {
        if (this.existBlankValue(properties, "location")) {
            throw new IllegalArgumentException("The value of the catalog property location must not be blank");
        }
        ImmutableMap.Builder catalogStorageLocations = ImmutableMap.builder();
        String unnamedLocation = (String)this.propertiesMetadata.catalogPropertiesMetadata().getOrDefault(properties, "location");
        if (StringUtils.isNotBlank((CharSequence)unnamedLocation)) {
            this.checkPlaceholderValue(unnamedLocation);
            catalogStorageLocations.put((Object)"unknown", (Object)new Path(this.ensureTrailingSlash(unnamedLocation)));
        }
        properties.forEach((k, v) -> {
            if (k.startsWith("location-")) {
                String locationName = k.substring("location-".length());
                if (StringUtils.isBlank((CharSequence)locationName)) {
                    throw new IllegalArgumentException("Location name must not be blank");
                }
                if (StringUtils.isBlank((CharSequence)v)) {
                    throw new IllegalArgumentException("Location value must not be blank for location name: " + locationName);
                }
                this.checkPlaceholderValue((String)v);
                if (!this.disableFSOps && !this.containsPlaceholder((String)v)) {
                    Path path = new Path(v);
                    FileSystem fs = this.getFileSystemWithCache(path, this.conf);
                    try {
                        if (fs.exists(path) && fs.getFileStatus(path).isFile()) {
                            throw new IllegalArgumentException("Fileset catalog location cannot be a file: " + v + ", location name: " + locationName);
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to check if fileset catalog location exists: " + v, e);
                    }
                }
                catalogStorageLocations.put((Object)locationName, (Object)new Path(this.ensureTrailingSlash((String)v)));
            }
        });
        return catalogStorageLocations.build();
    }

    private Map<String, Path> getAndCheckSchemaPaths(String schemaName, Map<String, String> schemaProps) {
        if (this.existBlankValue(schemaProps, "location")) {
            throw new IllegalArgumentException("The value of the schema property location must not be blank");
        }
        HashMap schemaPaths = new HashMap();
        this.catalogStorageLocations.forEach((name, path) -> {
            if (this.containsPlaceholder(path.toString())) {
                schemaPaths.put(name, path);
            } else {
                schemaPaths.put(name, new Path(path, schemaName));
            }
        });
        String unnamedSchemaLocation = (String)this.propertiesMetadata.schemaPropertiesMetadata().getOrDefault(schemaProps, "location");
        this.checkPlaceholderValue(unnamedSchemaLocation);
        Optional.ofNullable(unnamedSchemaLocation).map(this::ensureTrailingSlash).map(Path::new).ifPresent(p -> schemaPaths.put("unknown", p));
        schemaProps.forEach((k, path) -> {
            if (k.startsWith("location-")) {
                this.checkPlaceholderValue((String)path);
                String locationName = k.substring("location-".length());
                if (StringUtils.isBlank((CharSequence)locationName)) {
                    throw new IllegalArgumentException("Location name must not be blank");
                }
                Optional.ofNullable(path).map(this::ensureTrailingSlash).map(Path::new).ifPresent(p -> schemaPaths.put(locationName, p));
            }
        });
        return ImmutableMap.copyOf(schemaPaths);
    }

    private String ensureTrailingSlash(String path) {
        return path.endsWith(SLASH) ? path : path + SLASH;
    }

    private String removeTrailingSlash(String path) {
        return path.endsWith(SLASH) ? path.substring(0, path.length() - 1) : path;
    }

    private String ensureLeadingSlash(String path) {
        return path.startsWith(SLASH) ? path : SLASH + path;
    }

    private FilesetEntity updateFilesetEntity(NameIdentifier ident, FilesetEntity filesetEntity, FilesetChange ... changes) {
        HashMap props = filesetEntity.properties() == null ? Maps.newHashMap() : Maps.newHashMap((Map)filesetEntity.properties());
        String newName = ident.name();
        String newComment = filesetEntity.comment();
        for (FilesetChange change : changes) {
            if (change instanceof FilesetChange.SetProperty) {
                FilesetChange.SetProperty setProperty = (FilesetChange.SetProperty)change;
                props.put(setProperty.getProperty(), setProperty.getValue());
                continue;
            }
            if (change instanceof FilesetChange.RemoveProperty) {
                FilesetChange.RemoveProperty removeProperty = (FilesetChange.RemoveProperty)change;
                props.remove(removeProperty.getProperty());
                continue;
            }
            if (change instanceof FilesetChange.RenameFileset) {
                newName = ((FilesetChange.RenameFileset)change).getNewName();
                continue;
            }
            if (change instanceof FilesetChange.UpdateFilesetComment) {
                newComment = ((FilesetChange.UpdateFilesetComment)change).getNewComment();
                continue;
            }
            if (change instanceof FilesetChange.RemoveComment) {
                newComment = null;
                continue;
            }
            throw new IllegalArgumentException("Unsupported fileset change: " + change.getClass().getSimpleName());
        }
        return FilesetEntity.builder().withName(newName).withNamespace(ident.namespace()).withId(filesetEntity.id()).withComment(newComment).withFilesetType(filesetEntity.filesetType()).withStorageLocations(filesetEntity.storageLocations()).withProperties((Map)props).withAuditInfo(AuditInfo.builder().withCreator(filesetEntity.auditInfo().creator()).withCreateTime(filesetEntity.auditInfo().createTime()).withLastModifier(PrincipalUtils.getCurrentPrincipal().getName()).withLastModifiedTime(Instant.now()).build()).build();
    }

    private void checkPlaceholderValue(String location) {
        if (StringUtils.isBlank((CharSequence)location)) {
            return;
        }
        Matcher matcher = LOCATION_PLACEHOLDER_PATTERN.matcher(location);
        while (matcher.find()) {
            String placeholder = matcher.group(1);
            if (!placeholder.isEmpty()) continue;
            throw new IllegalArgumentException("Placeholder in location should not be empty, location: " + location);
        }
    }

    private boolean containsPlaceholder(String location) {
        return StringUtils.isNotBlank((CharSequence)location) && LOCATION_PLACEHOLDER_PATTERN.matcher(location).find();
    }

    private Map<String, Path> calculateFilesetPaths(String schemaName, String filesetName, Map<String, String> storageLocations, Map<String, Path> schemaPaths, Map<String, String> properties) {
        ImmutableMap.Builder filesetPaths = ImmutableMap.builder();
        HashSet<String> locationNames = new HashSet<String>(schemaPaths.keySet());
        locationNames.addAll(storageLocations.keySet());
        locationNames.forEach(locationName -> {
            String storageLocation = (String)storageLocations.get(locationName);
            Path schemaPath = (Path)schemaPaths.get(locationName);
            filesetPaths.put(locationName, (Object)this.calculateFilesetPath(schemaName, filesetName, storageLocation, schemaPath, properties));
        });
        return filesetPaths.build();
    }

    private Path calculateFilesetPath(String schemaName, String filesetName, String storageLocation, Path schemaPath, Map<String, String> properties) {
        if (StringUtils.isNotBlank((CharSequence)storageLocation) && !this.containsPlaceholder(storageLocation)) {
            return new Path(storageLocation);
        }
        HashMap<String, String> placeholderMapping = new HashMap<String, String>();
        properties.forEach((k, v) -> {
            if (k.startsWith("placeholder-")) {
                placeholderMapping.put(k.substring("placeholder-".length()), (String)v);
            }
        });
        placeholderMapping.put("placeholder-catalog".substring("placeholder-".length()), this.catalogInfo.name());
        placeholderMapping.put("placeholder-schema".substring("placeholder-".length()), schemaName);
        placeholderMapping.put("placeholder-fileset".substring("placeholder-".length()), filesetName);
        if (StringUtils.isNotBlank((CharSequence)storageLocation)) {
            return new Path(this.replacePlaceholders(storageLocation, placeholderMapping));
        }
        if (!this.containsPlaceholder(schemaPath.toString())) {
            return new Path(schemaPath, filesetName);
        }
        return new Path(this.replacePlaceholders(schemaPath.toString(), placeholderMapping));
    }

    private String replacePlaceholders(String location, Map<String, String> placeholderMapping) {
        Matcher matcher = LOCATION_PLACEHOLDER_PATTERN.matcher(location);
        StringBuilder result = new StringBuilder();
        int currentPosition = 0;
        while (matcher.find()) {
            result.append(location, currentPosition, matcher.start());
            String key = matcher.group(1);
            String replacement = placeholderMapping.get(key);
            if (replacement == null) {
                throw new IllegalArgumentException("No value found for placeholder: " + key);
            }
            result.append(replacement);
            currentPosition = matcher.end();
        }
        if (currentPosition < location.length()) {
            result.append(location, currentPosition, location.length());
        }
        return result.toString();
    }

    @VisibleForTesting
    Path formalizePath(Path path, Map<String, String> configuration) throws IOException {
        FileSystem defaultFs = this.getFileSystem(path, configuration);
        return path.makeQualified(defaultFs.getUri(), defaultFs.getWorkingDirectory());
    }

    private boolean hasCallerContext() {
        return CallerContext.CallerContextHolder.get() != null && CallerContext.CallerContextHolder.get().context() != null && !CallerContext.CallerContextHolder.get().context().isEmpty();
    }

    @VisibleForTesting
    FileSystem getFileSystemWithCache(Path path, Map<String, String> conf) {
        String scheme = path.toUri().getScheme();
        String authority = path.toUri().getAuthority();
        return (FileSystem)this.fileSystemCache.get((Object)new FileSystemCacheKey(scheme, authority, conf), cacheKey -> {
            try {
                return this.getFileSystem(path, conf);
            }
            catch (IOException e) {
                throw new GravitinoRuntimeException((Throwable)e, "Failed to get FileSystem for fileset: path: %s, conf: %s", new Object[]{path, conf});
            }
        });
    }

    private String buildGVFSFilePath(String catalogName, String schemaName, String filesetName, String subPath) {
        String prefix = String.join((CharSequence)SLASH, "/fileset", catalogName, schemaName, filesetName);
        return StringUtils.isBlank((CharSequence)subPath) ? prefix : prefix + this.ensureLeadingSlash(this.removeTrailingSlash(subPath));
    }

    FileSystem getFileSystem(Path path, Map<String, String> config) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("Path should not be null");
        }
        String scheme = path.toUri().getScheme() != null ? path.toUri().getScheme() : this.defaultFileSystemProvider.scheme();
        FileSystemProvider provider = this.fileSystemProvidersMap.get(scheme);
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Unsupported scheme: %s, path: %s, all supported schemes: %s and providers: %s", scheme, path, this.fileSystemProvidersMap.keySet(), this.fileSystemProvidersMap.values()));
        }
        int timeoutSeconds = (Integer)this.propertiesMetadata.catalogPropertiesMetadata().getOrDefault(config, "filesystem-conn-timeout-secs");
        Future<FileSystem> fileSystemFuture = this.fileSystemExecutor.submit(() -> provider.getFileSystem(path, config));
        try {
            return fileSystemFuture.get(timeoutSeconds, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            fileSystemFuture.cancel(true);
            LOG.warn("Timeout when getting FileSystem for path: {}, scheme: {}, provider: {} within {} seconds", new Object[]{path, scheme, provider, timeoutSeconds, e});
            throw new IOException(String.format("Failed to get FileSystem for path: %s, scheme: %s, provider: %s within %s seconds, please check the configuration or increase the file system connection timeout time by setting catalog property: %s", path, scheme, provider, timeoutSeconds, "filesystem-conn-timeout-secs"), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.warn("Interrupted when getting FileSystem for path: {}, possibly the server is shutting down or catalog is been dropped", (Object)path);
            throw new RuntimeException("Interrupted when getting FileSystem for path: " + String.valueOf(path), e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException("Failed to create FileSystem", cause);
        }
    }

    static class FileSystemCacheKey {
        @Nullable
        private final String scheme;
        @Nullable
        private final String authority;
        private final Map<String, String> conf;
        private final String currentUser;

        FileSystemCacheKey(String scheme, String authority, Map<String, String> conf) {
            this.scheme = scheme;
            this.authority = authority;
            this.conf = conf;
            try {
                this.currentUser = UserGroupInformation.getCurrentUser().getShortUserName();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to get current user", e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FileSystemCacheKey)) {
                return false;
            }
            FileSystemCacheKey that = (FileSystemCacheKey)o;
            return this.conf.equals(that.conf) && (this.scheme == null ? that.scheme == null : this.scheme.equals(that.scheme)) && (this.authority == null ? that.authority == null : this.authority.equals(that.authority)) && this.currentUser.equals(that.currentUser);
        }

        public int hashCode() {
            int result = this.conf.hashCode();
            result = 31 * result + (this.scheme == null ? 0 : this.scheme.hashCode());
            result = 31 * result + (this.authority == null ? 0 : this.authority.hashCode());
            result = 31 * result + this.currentUser.hashCode();
            return result;
        }
    }
}

