/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.client.StaticHostProvider;
import org.apache.zookeeper.common.Time;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticHostProviderTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(StaticHostProviderTest.class);

    @Test
    public void testNextGoesRound() {
        StaticHostProvider hostProvider = this.getHostProvider((byte)2);
        InetSocketAddress first = hostProvider.next(0L);
        Assert.assertTrue((boolean)(first instanceof InetSocketAddress));
        hostProvider.next(0L);
        Assert.assertEquals((Object)first, (Object)hostProvider.next(0L));
    }

    @Test
    public void testNextGoesRoundAndSleeps() {
        byte size;
        StaticHostProvider hostProvider = this.getHostProvider(size);
        for (size = 2; size > 0; size = (byte)(size - 1)) {
            hostProvider.next(0L);
        }
        long start = Time.currentElapsedTime();
        hostProvider.next(1000L);
        long stop = Time.currentElapsedTime();
        Assert.assertTrue((900L <= stop - start ? 1 : 0) != 0);
    }

    @Test
    public void testNextDoesNotSleepForZero() {
        byte size;
        StaticHostProvider hostProvider = this.getHostProvider(size);
        for (size = 2; size > 0; size = (byte)(size - 1)) {
            hostProvider.next(0L);
        }
        long start = Time.currentElapsedTime();
        hostProvider.next(0L);
        long stop = Time.currentElapsedTime();
        Assert.assertTrue((5L > stop - start ? 1 : 0) != 0);
    }

    @Test
    public void testTwoConsequitiveCallsToNextReturnDifferentElement() {
        StaticHostProvider hostProvider = this.getHostProvider((byte)2);
        Assert.assertNotSame((Object)hostProvider.next(0L), (Object)hostProvider.next(0L));
    }

    @Test
    public void testOnConnectDoesNotReset() {
        StaticHostProvider hostProvider = this.getHostProvider((byte)2);
        InetSocketAddress first = hostProvider.next(0L);
        hostProvider.onConnected();
        InetSocketAddress second = hostProvider.next(0L);
        Assert.assertNotSame((Object)first, (Object)second);
    }

    @Test
    public void testLiteralIPNoReverseNS() {
        int size = 30;
        StaticHostProvider hostProvider = this.getHostProviderUnresolved((byte)size);
        for (int i = 0; i < size; ++i) {
            InetSocketAddress next = hostProvider.next(0L);
            Assert.assertTrue((boolean)(next instanceof InetSocketAddress));
            Assert.assertTrue((!next.isUnresolved() ? 1 : 0) != 0);
            Assert.assertTrue((String)("InetSocketAddress must not have hostname part " + next.toString()), (boolean)next.toString().startsWith("/"));
            String hostname = next.getHostName();
            hostname.equals(next.getAddress().getHostAddress());
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyServerAddressesList() {
        StaticHostProvider hp = new StaticHostProvider(new ArrayList());
    }

    @Test
    public void testInvalidHostAddresses() {
        ArrayList<InetSocketAddress> invalidAddresses = new ArrayList<InetSocketAddress>();
        InetSocketAddress unresolved = InetSocketAddress.createUnresolved("a", 1234);
        invalidAddresses.add(unresolved);
        StaticHostProvider.Resolver resolver = new StaticHostProvider.Resolver(){

            public InetAddress[] getAllByName(String name) throws UnknownHostException {
                throw new UnknownHostException();
            }
        };
        StaticHostProvider sp = new StaticHostProvider(invalidAddresses, resolver);
        InetSocketAddress n1 = sp.next(0L);
        Assert.assertTrue((String)"Provider should return unresolved address is host is unresolvable", (boolean)n1.isUnresolved());
        Assert.assertSame((String)"Provider should return original address is host is unresolvable", (Object)unresolved, (Object)n1);
    }

    @Test
    public void testReResolvingSingle() throws UnknownHostException {
        int size = 1;
        ArrayList<InetSocketAddress> list = new ArrayList<InetSocketAddress>(size);
        list.add(InetSocketAddress.createUnresolved("issues.apache.org", 1234));
        final InetAddress issuesApacheOrg = (InetAddress)Mockito.mock(InetAddress.class);
        Mockito.when((Object)issuesApacheOrg.getHostAddress()).thenReturn((Object)"192.168.1.1");
        Mockito.when((Object)issuesApacheOrg.toString()).thenReturn((Object)"issues.apache.org");
        Mockito.when((Object)issuesApacheOrg.getHostName()).thenReturn((Object)"issues.apache.org");
        StaticHostProvider.Resolver resolver = new StaticHostProvider.Resolver(){

            public InetAddress[] getAllByName(String name) {
                return new InetAddress[]{issuesApacheOrg};
            }
        };
        StaticHostProvider.Resolver spyResolver = (StaticHostProvider.Resolver)Mockito.spy((Object)resolver);
        StaticHostProvider hostProvider = new StaticHostProvider(list, spyResolver);
        for (int i = 0; i < 10; ++i) {
            InetSocketAddress next = hostProvider.next(0L);
            Assert.assertEquals((Object)issuesApacheOrg, (Object)next.getAddress());
        }
        ((StaticHostProvider.Resolver)Mockito.verify((Object)spyResolver, (VerificationMode)Mockito.times((int)10))).getAllByName("issues.apache.org");
    }

    @Test
    public void testReResolvingMultiple() throws UnknownHostException {
        int size = 1;
        ArrayList<InetSocketAddress> list = new ArrayList<InetSocketAddress>(size);
        list.add(InetSocketAddress.createUnresolved("www.apache.org", 1234));
        InetAddress apacheOrg1 = (InetAddress)Mockito.mock(InetAddress.class);
        Mockito.when((Object)apacheOrg1.getHostAddress()).thenReturn((Object)"192.168.1.1");
        Mockito.when((Object)apacheOrg1.toString()).thenReturn((Object)"www.apache.org");
        Mockito.when((Object)apacheOrg1.getHostName()).thenReturn((Object)"www.apache.org");
        InetAddress apacheOrg2 = (InetAddress)Mockito.mock(InetAddress.class);
        Mockito.when((Object)apacheOrg2.getHostAddress()).thenReturn((Object)"192.168.1.2");
        Mockito.when((Object)apacheOrg2.toString()).thenReturn((Object)"www.apache.org");
        Mockito.when((Object)apacheOrg2.getHostName()).thenReturn((Object)"www.apache.org");
        final ArrayList<InetAddress> resolvedAddresses = new ArrayList<InetAddress>();
        resolvedAddresses.add(apacheOrg1);
        resolvedAddresses.add(apacheOrg2);
        StaticHostProvider.Resolver resolver = new StaticHostProvider.Resolver(){

            public InetAddress[] getAllByName(String name) {
                return resolvedAddresses.toArray(new InetAddress[resolvedAddresses.size()]);
            }
        };
        StaticHostProvider.Resolver spyResolver = (StaticHostProvider.Resolver)Mockito.spy((Object)resolver);
        StaticHostProvider hostProvider = new StaticHostProvider(list, spyResolver);
        Assert.assertEquals((long)1L, (long)hostProvider.size());
        for (int i = 0; i < 10; ++i) {
            InetSocketAddress next = hostProvider.next(0L);
            Assert.assertThat((String)"Bad IP address returned", (Object)next.getAddress().getHostAddress(), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.equalTo((Object)apacheOrg1.getHostAddress()), (Matcher)CoreMatchers.equalTo((Object)apacheOrg2.getHostAddress())));
            Assert.assertEquals((long)1L, (long)hostProvider.size());
        }
        ((StaticHostProvider.Resolver)Mockito.verify((Object)spyResolver, (VerificationMode)Mockito.times((int)10))).getAllByName("www.apache.org");
    }

    @Test
    public void testReResolveMultipleOneFailing() throws UnknownHostException {
        ArrayList<InetSocketAddress> list = new ArrayList<InetSocketAddress>();
        list.add(InetSocketAddress.createUnresolved("www.apache.org", 1234));
        ArrayList<String> ipList = new ArrayList<String>();
        final ArrayList<InetAddress> resolvedAddresses = new ArrayList<InetAddress>();
        for (int i = 0; i < 3; ++i) {
            ipList.add(String.format("192.168.1.%d", i + 1));
            InetAddress apacheOrg = (InetAddress)Mockito.mock(InetAddress.class);
            Mockito.when((Object)apacheOrg.getHostAddress()).thenReturn((Object)String.format("192.168.1.%d", i + 1));
            Mockito.when((Object)apacheOrg.toString()).thenReturn((Object)String.format("192.168.1.%d", i + 1));
            Mockito.when((Object)apacheOrg.getHostName()).thenReturn((Object)"www.apache.org");
            resolvedAddresses.add(apacheOrg);
        }
        StaticHostProvider.Resolver resolver = new StaticHostProvider.Resolver(){

            public InetAddress[] getAllByName(String name) {
                return resolvedAddresses.toArray(new InetAddress[resolvedAddresses.size()]);
            }
        };
        StaticHostProvider.Resolver spyResolver = (StaticHostProvider.Resolver)Mockito.spy((Object)resolver);
        StaticHostProvider hostProvider = new StaticHostProvider(list, spyResolver);
        InetSocketAddress resolvedFirst = hostProvider.next(0L);
        Assert.assertFalse((String)"HostProvider should return resolved addresses", (boolean)resolvedFirst.isUnresolved());
        Assert.assertThat((String)"Bad IP address returned", ipList, (Matcher)JUnitMatchers.hasItems((Object[])new String[]{resolvedFirst.getAddress().getHostAddress()}));
        hostProvider.onConnected();
        InetSocketAddress resolvedSecond = hostProvider.next(0L);
        Assert.assertFalse((String)"HostProvider should return resolved addresses", (boolean)resolvedSecond.isUnresolved());
        Assert.assertThat((String)"Bad IP address returned", ipList, (Matcher)JUnitMatchers.hasItems((Object[])new String[]{resolvedSecond.getAddress().getHostAddress()}));
        InetSocketAddress resolvedThird = hostProvider.next(0L);
        Assert.assertFalse((String)"HostProvider should return resolved addresses", (boolean)resolvedThird.isUnresolved());
        Assert.assertThat((String)"Bad IP address returned", ipList, (Matcher)JUnitMatchers.hasItems((Object[])new String[]{resolvedThird.getAddress().getHostAddress()}));
        ((StaticHostProvider.Resolver)Mockito.verify((Object)spyResolver, (VerificationMode)Mockito.times((int)3))).getAllByName("www.apache.org");
    }

    @Test
    public void testEmptyResolution() throws UnknownHostException {
        ArrayList<InetSocketAddress> list = new ArrayList<InetSocketAddress>();
        list.add(InetSocketAddress.createUnresolved("www.apache.org", 1234));
        list.add(InetSocketAddress.createUnresolved("www.google.com", 1234));
        final ArrayList<InetAddress> resolvedAddresses = new ArrayList<InetAddress>();
        InetAddress apacheOrg1 = (InetAddress)Mockito.mock(InetAddress.class);
        Mockito.when((Object)apacheOrg1.getHostAddress()).thenReturn((Object)"192.168.1.1");
        Mockito.when((Object)apacheOrg1.toString()).thenReturn((Object)"www.apache.org");
        Mockito.when((Object)apacheOrg1.getHostName()).thenReturn((Object)"www.apache.org");
        resolvedAddresses.add(apacheOrg1);
        StaticHostProvider.Resolver resolver = new StaticHostProvider.Resolver(){

            public InetAddress[] getAllByName(String name) {
                if ("www.apache.org".equalsIgnoreCase(name)) {
                    return resolvedAddresses.toArray(new InetAddress[resolvedAddresses.size()]);
                }
                return new InetAddress[0];
            }
        };
        StaticHostProvider.Resolver spyResolver = (StaticHostProvider.Resolver)Mockito.spy((Object)resolver);
        StaticHostProvider hostProvider = new StaticHostProvider(list, spyResolver);
        for (int i = 0; i < 10; ++i) {
            InetSocketAddress resolved = hostProvider.next(0L);
            hostProvider.onConnected();
            if (resolved.getHostName().equals("www.google.com")) {
                Assert.assertTrue((String)"HostProvider should return unresolved address if host is unresolvable", (boolean)resolved.isUnresolved());
                continue;
            }
            Assert.assertFalse((String)"HostProvider should return resolved addresses", (boolean)resolved.isUnresolved());
            Assert.assertEquals((Object)"192.168.1.1", (Object)resolved.getAddress().getHostAddress());
        }
        ((StaticHostProvider.Resolver)Mockito.verify((Object)spyResolver, (VerificationMode)Mockito.times((int)5))).getAllByName("www.apache.org");
        ((StaticHostProvider.Resolver)Mockito.verify((Object)spyResolver, (VerificationMode)Mockito.times((int)5))).getAllByName("www.google.com");
    }

    @Test
    public void testReResolvingLocalhost() {
        int size = 2;
        ArrayList<InetSocketAddress> list = new ArrayList<InetSocketAddress>(size);
        list.add(InetSocketAddress.createUnresolved("localhost", 1234));
        list.add(InetSocketAddress.createUnresolved("localhost", 1235));
        StaticHostProvider hostProvider = new StaticHostProvider(list);
        int sizeBefore = hostProvider.size();
        InetSocketAddress next = hostProvider.next(0L);
        next = hostProvider.next(0L);
        Assert.assertTrue((String)("Different number of addresses in the list: " + hostProvider.size() + " (after), " + sizeBefore + " (before)"), (hostProvider.size() == sizeBefore ? 1 : 0) != 0);
    }

    private StaticHostProvider getHostProviderUnresolved(byte size) {
        return new StaticHostProvider(this.getUnresolvedServerAddresses(size));
    }

    private Collection<InetSocketAddress> getUnresolvedServerAddresses(byte size) {
        ArrayList<InetSocketAddress> list = new ArrayList<InetSocketAddress>(size);
        while (size > 0) {
            list.add(InetSocketAddress.createUnresolved("192.0.2." + size, 1234 + size));
            size = (byte)(size - 1);
        }
        return list;
    }

    private StaticHostProvider getHostProvider(byte size) {
        ArrayList<InetSocketAddress> list = new ArrayList<InetSocketAddress>(size);
        while (size > 0) {
            try {
                list.add(new InetSocketAddress(InetAddress.getByAddress(new byte[]{-64, 0, 2, size}), 1234 + size));
            }
            catch (UnknownHostException e) {
                LOG.error("Exception while resolving address", (Throwable)e);
                Assert.fail((String)"Failed to resolve address");
            }
            size = (byte)(size - 1);
        }
        return new StaticHostProvider(list);
    }
}

