/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.MultiTransactionRecord;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.proto.SetDataRequest;
import org.apache.zookeeper.server.PrepRequestProcessor;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.SessionTracker;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.txn.ErrorTxn;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepRequestProcessorTest
extends ClientBase {
    private static final Logger LOG = LoggerFactory.getLogger(PrepRequestProcessorTest.class);
    private static final int CONNECTION_TIMEOUT = 3000;
    private static String HOSTPORT = "127.0.0.1:" + PortAssignment.unique();
    private CountDownLatch pLatch;
    private ZooKeeperServer zks;
    private ServerCnxnFactory servcnxnf;
    private PrepRequestProcessor processor;
    private Request outcome;

    @Before
    public void setup() throws Exception {
        File tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        this.zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        SyncRequestProcessor.setSnapCount((int)100);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        this.servcnxnf = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        this.servcnxnf.startup(this.zks);
        Assert.assertTrue((String)"waiting for server being up ", (boolean)ClientBase.waitForServerUp(HOSTPORT, 3000L));
        this.zks.sessionTracker = new MySessionTracker();
    }

    @After
    public void teardown() throws Exception {
        if (this.servcnxnf != null) {
            this.servcnxnf.shutdown();
        }
        if (this.zks != null) {
            this.zks.shutdown();
        }
    }

    @Test
    public void testPRequest() throws Exception {
        this.pLatch = new CountDownLatch(1);
        this.processor = new PrepRequestProcessor(this.zks, (RequestProcessor)new MyRequestProcessor());
        Request foo = new Request(null, 1L, 1, 1, ByteBuffer.allocate(3), null);
        this.processor.pRequest(foo);
        Assert.assertEquals((String)"Request should have marshalling error", (Object)new ErrorTxn(KeeperException.Code.MARSHALLINGERROR.intValue()), (Object)this.outcome.txn);
        Assert.assertTrue((String)"request hasn't been processed in chain", (boolean)this.pLatch.await(5L, TimeUnit.SECONDS));
    }

    private Request createRequest(Record record, int opCode) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive((OutputStream)baos);
        record.serialize((OutputArchive)boa, "request");
        baos.close();
        List<Id> ids = Arrays.asList(ZooDefs.Ids.ANYONE_ID_UNSAFE);
        return new Request(null, 1L, 0, opCode, ByteBuffer.wrap(baos.toByteArray()), ids);
    }

    private void process(List<Op> ops) throws Exception {
        this.pLatch = new CountDownLatch(1);
        this.processor = new PrepRequestProcessor(this.zks, (RequestProcessor)new MyRequestProcessor());
        MultiTransactionRecord record = new MultiTransactionRecord(ops);
        Request req = this.createRequest((Record)record, 14);
        this.processor.pRequest(req);
        Assert.assertTrue((String)"request hasn't been processed in chain", (boolean)this.pLatch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testMultiOutstandingChange() throws Exception {
        this.zks.getZKDatabase().dataTree.createNode("/foo", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, 0L, 0, 0L, 0L);
        Assert.assertNull(this.zks.outstandingChangesForPath.get("/foo"));
        this.process(Arrays.asList(Op.setData((String)"/foo", (byte[])new byte[0], (int)-1)));
        ZooKeeperServer.ChangeRecord cr = (ZooKeeperServer.ChangeRecord)this.zks.outstandingChangesForPath.get("/foo");
        Assert.assertNotNull((String)"Change record wasn't set", (Object)cr);
        Assert.assertEquals((String)"Record zxid wasn't set correctly", (long)1L, (long)cr.zxid);
        this.process(Arrays.asList(Op.delete((String)"/foo", (int)-1)));
        cr = (ZooKeeperServer.ChangeRecord)this.zks.outstandingChangesForPath.get("/foo");
        Assert.assertEquals((String)"Record zxid wasn't set correctly", (long)2L, (long)cr.zxid);
        this.process(Arrays.asList(Op.delete((String)"/foo", (int)-1)));
        cr = (ZooKeeperServer.ChangeRecord)this.zks.outstandingChangesForPath.get("/foo");
        Assert.assertEquals((String)"Record zxid wasn't set correctly", (long)2L, (long)cr.zxid);
    }

    @Test
    public void testMultiRollbackNoLastChange() throws Exception {
        this.zks.getZKDatabase().dataTree.createNode("/foo", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, 0L, 0, 0L, 0L);
        this.zks.getZKDatabase().dataTree.createNode("/foo/bar", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, 0L, 0, 0L, 0L);
        Assert.assertNull(this.zks.outstandingChangesForPath.get("/foo"));
        this.process(Arrays.asList(Op.setData((String)"/foo", (byte[])new byte[0], (int)-1), Op.delete((String)"/foo", (int)-1)));
        Assert.assertNull(this.zks.outstandingChangesForPath.get("/foo"));
    }

    @Test
    public void testInvalidPath() throws Exception {
        this.pLatch = new CountDownLatch(1);
        this.processor = new PrepRequestProcessor(this.zks, (RequestProcessor)new MyRequestProcessor());
        SetDataRequest record = new SetDataRequest("", new byte[0], -1);
        Request req = this.createRequest((Record)record, 5);
        this.processor.pRequest(req);
        this.pLatch.await();
        Assert.assertEquals((long)this.outcome.hdr.getType(), (long)-1L);
        Assert.assertEquals((Object)this.outcome.getException().code(), (Object)KeeperException.Code.BADARGUMENTS);
    }

    private class MySessionTracker
    implements SessionTracker {
        private MySessionTracker() {
        }

        public void addSession(long id, int to) {
        }

        public void checkSession(long sessionId, Object owner) throws KeeperException.SessionExpiredException, KeeperException.SessionMovedException {
        }

        public long createSession(int sessionTimeout) {
            return 0L;
        }

        public void dumpSessions(PrintWriter pwriter) {
        }

        public void removeSession(long sessionId) {
        }

        public void setOwner(long id, Object owner) throws KeeperException.SessionExpiredException {
        }

        public void shutdown() {
        }

        public boolean touchSession(long sessionId, int sessionTimeout) {
            return false;
        }

        public void setSessionClosing(long sessionId) {
        }
    }

    private class MyRequestProcessor
    implements RequestProcessor {
        private MyRequestProcessor() {
        }

        public void processRequest(Request request) {
            PrepRequestProcessorTest.this.outcome = request;
            PrepRequestProcessorTest.this.pLatch.countDown();
        }

        public void shutdown() {
        }
    }
}

