/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.rel;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Objects;
import org.apache.gravitino.annotation.Evolving;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.expressions.FunctionExpression;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.tag.SupportsTags;

@Evolving
public interface Column {
    public static final Expression DEFAULT_VALUE_NOT_SET = () -> Expression.EMPTY_EXPRESSION;
    public static final Expression DEFAULT_VALUE_OF_CURRENT_TIMESTAMP = FunctionExpression.of("current_timestamp");

    public String name();

    public Type dataType();

    public String comment();

    public boolean nullable();

    public boolean autoIncrement();

    public Expression defaultValue();

    default public SupportsTags supportsTags() {
        throw new UnsupportedOperationException("Column does not support tag operations.");
    }

    public static ColumnImpl of(String name, Type dataType, String comment, Expression defaultValue) {
        return Column.of(name, dataType, comment, true, false, defaultValue);
    }

    public static ColumnImpl of(String name, Type dataType, String comment) {
        return Column.of(name, dataType, comment, true, false, DEFAULT_VALUE_NOT_SET);
    }

    public static ColumnImpl of(String name, Type dataType) {
        return Column.of(name, dataType, null, true, false, DEFAULT_VALUE_NOT_SET);
    }

    public static ColumnImpl of(String name, Type dataType, String comment, boolean nullable, boolean autoIncrement, Expression defaultValue) {
        return new ColumnImpl(name, dataType, comment, nullable, autoIncrement, defaultValue == null ? DEFAULT_VALUE_NOT_SET : defaultValue);
    }

    public static class ColumnImpl
    implements Column {
        private String name;
        private Type dataType;
        private String comment;
        private boolean nullable;
        private boolean autoIncrement;
        private Expression defaultValue;

        private ColumnImpl(String name, Type dataType, String comment, boolean nullable, boolean autoIncrement, Expression defaultValue) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "Column name cannot be null");
            Preconditions.checkArgument(dataType != null, "Column data type cannot be null");
            this.name = name;
            this.dataType = dataType;
            this.comment = comment;
            this.nullable = nullable;
            this.autoIncrement = autoIncrement;
            this.defaultValue = defaultValue;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Type dataType() {
            return this.dataType;
        }

        @Override
        public String comment() {
            return this.comment;
        }

        @Override
        public boolean nullable() {
            return this.nullable;
        }

        @Override
        public boolean autoIncrement() {
            return this.autoIncrement;
        }

        @Override
        public Expression defaultValue() {
            return this.defaultValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ColumnImpl)) {
                return false;
            }
            ColumnImpl column = (ColumnImpl)o;
            return this.nullable == column.nullable && this.autoIncrement == column.autoIncrement && Objects.equals(this.name, column.name) && Objects.equals(this.dataType, column.dataType) && Objects.equals(this.comment, column.comment) && Objects.equals(this.defaultValue, column.defaultValue);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.dataType, this.comment, this.nullable, this.autoIncrement, this.defaultValue);
        }
    }
}

