/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.job;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.gravitino.job.JobTemplate;

public class ShellJobTemplate
extends JobTemplate {
    private final List<String> scripts;

    protected ShellJobTemplate(Builder builder) {
        super(builder);
        this.scripts = builder.scripts;
    }

    public List<String> scripts() {
        return this.scripts;
    }

    @Override
    public JobTemplate.JobType jobType() {
        return JobTemplate.JobType.SHELL;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShellJobTemplate)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ShellJobTemplate that = (ShellJobTemplate)o;
        return Objects.equals(this.scripts, that.scripts);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.scripts);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.scripts.isEmpty()) {
            sb.append("  scripts=[\n");
            this.scripts.forEach(s2 -> sb.append("    ").append((String)s2).append("\n"));
            sb.append("  ]\n");
        } else {
            sb.append("  scripts=[]\n");
        }
        return "\nShellJobTemplate{\n" + super.toString() + String.valueOf(sb) + "}\n";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends JobTemplate.BaseBuilder<Builder, ShellJobTemplate> {
        private List<String> scripts;

        private Builder() {
        }

        public Builder withScripts(List<String> scripts) {
            this.scripts = scripts;
            return this;
        }

        @Override
        public ShellJobTemplate build() {
            this.validate();
            return new ShellJobTemplate(this);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            this.scripts = this.scripts != null ? ImmutableList.copyOf(this.scripts) : ImmutableList.of();
        }
    }
}

