/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.requests;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.rest.RESTRequest;

public class PoliciesAssociateRequest
implements RESTRequest {
    @JsonProperty(value="policiesToAdd")
    private final String[] policiesToAdd;
    @JsonProperty(value="policiesToRemove")
    private final String[] policiesToRemove;

    public PoliciesAssociateRequest(String[] policiesToAdd, String[] policiesToRemove) {
        this.policiesToAdd = policiesToAdd;
        this.policiesToRemove = policiesToRemove;
    }

    private PoliciesAssociateRequest() {
        this(null, null);
    }

    @Override
    public void validate() throws IllegalArgumentException {
        Preconditions.checkArgument(this.policiesToAdd != null || this.policiesToRemove != null, "policiesToAdd and policiesToRemove cannot both be null");
        if (this.policiesToAdd != null) {
            for (String policy : this.policiesToAdd) {
                Preconditions.checkArgument(StringUtils.isNotBlank(policy), "policiesToAdd must not contain null or empty policy names");
            }
        }
        if (this.policiesToRemove != null) {
            for (String policy : this.policiesToRemove) {
                Preconditions.checkArgument(StringUtils.isNotBlank(policy), "policiesToRemove must not contain null or empty policy names");
            }
        }
    }

    public String[] getPoliciesToAdd() {
        return this.policiesToAdd;
    }

    public String[] getPoliciesToRemove() {
        return this.policiesToRemove;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PoliciesAssociateRequest)) {
            return false;
        }
        PoliciesAssociateRequest other = (PoliciesAssociateRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getPoliciesToAdd(), other.getPoliciesToAdd())) {
            return false;
        }
        return Arrays.deepEquals(this.getPoliciesToRemove(), other.getPoliciesToRemove());
    }

    protected boolean canEqual(Object other) {
        return other instanceof PoliciesAssociateRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getPoliciesToAdd());
        result = result * 59 + Arrays.deepHashCode(this.getPoliciesToRemove());
        return result;
    }

    public String toString() {
        return "PoliciesAssociateRequest(policiesToAdd=" + Arrays.deepToString(this.getPoliciesToAdd()) + ", policiesToRemove=" + Arrays.deepToString(this.getPoliciesToRemove()) + ")";
    }
}

