/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.requests;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.file.Fileset;
import org.apache.gravitino.rest.RESTRequest;

public class FilesetCreateRequest
implements RESTRequest {
    @JsonProperty(value="name")
    private String name;
    @Nullable
    @JsonProperty(value="comment")
    private String comment;
    @Nullable
    @JsonProperty(value="type")
    private Fileset.Type type;
    @Nullable
    @JsonProperty(value="storageLocation")
    private String storageLocation;
    @Nullable
    @JsonProperty(value="storageLocations")
    private Map<String, String> storageLocations;
    @Nullable
    @JsonProperty(value="properties")
    private Map<String, String> properties;

    @Override
    public void validate() throws IllegalArgumentException {
        Preconditions.checkArgument(StringUtils.isNotBlank(this.name), "\"name\" field is required and cannot be empty");
    }

    public static FilesetCreateRequestBuilder builder() {
        return new FilesetCreateRequestBuilder();
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getComment() {
        return this.comment;
    }

    @Nullable
    public Fileset.Type getType() {
        return this.type;
    }

    @Nullable
    public String getStorageLocation() {
        return this.storageLocation;
    }

    @Nullable
    public Map<String, String> getStorageLocations() {
        return this.storageLocations;
    }

    @Nullable
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilesetCreateRequest)) {
            return false;
        }
        FilesetCreateRequest other = (FilesetCreateRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        Fileset.Type this$type = this.getType();
        Fileset.Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$storageLocation = this.getStorageLocation();
        String other$storageLocation = other.getStorageLocation();
        if (this$storageLocation == null ? other$storageLocation != null : !this$storageLocation.equals(other$storageLocation)) {
            return false;
        }
        Map<String, String> this$storageLocations = this.getStorageLocations();
        Map<String, String> other$storageLocations = other.getStorageLocations();
        if (this$storageLocations == null ? other$storageLocations != null : !((Object)this$storageLocations).equals(other$storageLocations)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FilesetCreateRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        Fileset.Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $storageLocation = this.getStorageLocation();
        result = result * 59 + ($storageLocation == null ? 43 : $storageLocation.hashCode());
        Map<String, String> $storageLocations = this.getStorageLocations();
        result = result * 59 + ($storageLocations == null ? 43 : ((Object)$storageLocations).hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "FilesetCreateRequest(name=" + this.getName() + ", comment=" + this.getComment() + ", type=" + String.valueOf((Object)this.getType()) + ", storageLocation=" + this.getStorageLocation() + ", storageLocations=" + String.valueOf(this.getStorageLocations()) + ", properties=" + String.valueOf(this.getProperties()) + ")";
    }

    public FilesetCreateRequest() {
    }

    public FilesetCreateRequest(String name, @Nullable String comment, @Nullable Fileset.Type type, @Nullable String storageLocation, @Nullable Map<String, String> storageLocations, @Nullable Map<String, String> properties) {
        this.name = name;
        this.comment = comment;
        this.type = type;
        this.storageLocation = storageLocation;
        this.storageLocations = storageLocations;
        this.properties = properties;
    }

    public static class FilesetCreateRequestBuilder {
        private String name;
        private String comment;
        private Fileset.Type type;
        private String storageLocation;
        private Map<String, String> storageLocations;
        private Map<String, String> properties;

        FilesetCreateRequestBuilder() {
        }

        @JsonProperty(value="name")
        public FilesetCreateRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="comment")
        public FilesetCreateRequestBuilder comment(@Nullable String comment) {
            this.comment = comment;
            return this;
        }

        @JsonProperty(value="type")
        public FilesetCreateRequestBuilder type(@Nullable Fileset.Type type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="storageLocation")
        public FilesetCreateRequestBuilder storageLocation(@Nullable String storageLocation) {
            this.storageLocation = storageLocation;
            return this;
        }

        @JsonProperty(value="storageLocations")
        public FilesetCreateRequestBuilder storageLocations(@Nullable Map<String, String> storageLocations) {
            this.storageLocations = storageLocations;
            return this;
        }

        @JsonProperty(value="properties")
        public FilesetCreateRequestBuilder properties(@Nullable Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public FilesetCreateRequest build() {
            return new FilesetCreateRequest(this.name, this.comment, this.type, this.storageLocation, this.storageLocations, this.properties);
        }

        public String toString() {
            return "FilesetCreateRequest.FilesetCreateRequestBuilder(name=" + this.name + ", comment=" + this.comment + ", type=" + String.valueOf((Object)this.type) + ", storageLocation=" + this.storageLocation + ", storageLocations=" + String.valueOf(this.storageLocations) + ", properties=" + String.valueOf(this.properties) + ")";
        }
    }
}

