/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.rel.partitioning;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Arrays;
import org.apache.gravitino.dto.rel.ColumnDTO;
import org.apache.gravitino.dto.rel.PartitionUtils;
import org.apache.gravitino.json.JsonUtils;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.expressions.NamedReference;
import org.apache.gravitino.rel.expressions.transforms.Transform;

@JsonSerialize(using=JsonUtils.PartitioningSerializer.class)
@JsonDeserialize(using=JsonUtils.PartitioningDeserializer.class)
public interface Partitioning
extends Transform {
    public static final Partitioning[] EMPTY_PARTITIONING = new Partitioning[0];

    public Strategy strategy();

    public void validate(ColumnDTO[] var1) throws IllegalArgumentException;

    public static abstract class SingleFieldPartitioning
    implements Partitioning {
        String[] fieldName;

        public String[] fieldName() {
            return this.fieldName;
        }

        @Override
        public void validate(ColumnDTO[] columns) throws IllegalArgumentException {
            PartitionUtils.validateFieldExistence(columns, this.fieldName);
        }

        @Override
        public String name() {
            return this.strategy().name().toLowerCase();
        }

        @Override
        public Expression[] arguments() {
            return new Expression[]{NamedReference.field(this.fieldName)};
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SingleFieldPartitioning)) {
                return false;
            }
            SingleFieldPartitioning other = (SingleFieldPartitioning)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return Arrays.deepEquals(this.fieldName, other.fieldName);
        }

        protected boolean canEqual(Object other) {
            return other instanceof SingleFieldPartitioning;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.fieldName);
            return result;
        }
    }

    public static enum Strategy {
        IDENTITY,
        YEAR,
        MONTH,
        DAY,
        HOUR,
        BUCKET,
        TRUNCATE,
        LIST,
        RANGE,
        FUNCTION;


        public static Strategy getByName(String name) {
            for (Strategy strategy : Strategy.values()) {
                if (!strategy.name().equalsIgnoreCase(name)) continue;
                return strategy;
            }
            throw new IllegalArgumentException("Invalid partitioning strategy: " + name + ". Valid values are: " + Arrays.toString((Object[])Strategy.values()));
        }
    }
}

