/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.MetalakeChange;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoAdminClient;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;

public class UpdateMetalakeComment
extends Command {
    protected final String metalake;
    protected final String comment;

    public UpdateMetalakeComment(CommandContext context, String metalake, String comment) {
        super(context);
        this.metalake = metalake;
        this.comment = comment;
    }

    @Override
    public void handle() {
        try {
            GravitinoAdminClient client = this.buildAdminClient();
            MetalakeChange change = MetalakeChange.updateComment(this.comment);
            client.alterMetalake(this.metalake, change);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        this.printInformation(this.metalake + " comment changed.");
    }
}

