/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.rel.TableChange;

public class SetTableProperty
extends Command {
    protected final String metalake;
    protected final String catalog;
    protected final String schema;
    protected final String table;
    protected final String property;
    protected final String value;

    public SetTableProperty(CommandContext context, String metalake, String catalog, String schema, String table, String property, String value) {
        super(context);
        this.metalake = metalake;
        this.catalog = catalog;
        this.schema = schema;
        this.table = table;
        this.property = property;
        this.value = value;
    }

    @Override
    public void handle() {
        try {
            NameIdentifier name = NameIdentifier.of(this.schema, this.table);
            GravitinoClient client = this.buildClient(this.metalake);
            TableChange change = TableChange.setProperty(this.property, this.value);
            client.loadCatalog(this.catalog).asTableCatalog().alterTable(name, change);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (NoSuchSchemaException err) {
            this.exitWithError("Unknown schema name.");
        }
        catch (NoSuchTableException err) {
            this.exitWithError("Unknown table name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        this.printInformation(this.table + " property set.");
    }

    @Override
    public Command validate() {
        this.validatePropertyAndValue(this.property, this.value);
        return super.validate();
    }
}

