/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.MetalakeChange;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoAdminClient;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;

public class SetMetalakeProperty
extends Command {
    protected final String metalake;
    protected final String property;
    protected final String value;

    public SetMetalakeProperty(CommandContext context, String metalake, String property, String value) {
        super(context);
        this.metalake = metalake;
        this.property = property;
        this.value = value;
    }

    @Override
    public void handle() {
        try {
            GravitinoAdminClient client = this.buildAdminClient();
            MetalakeChange change = MetalakeChange.setProperty(this.property, this.value);
            client.alterMetalake(this.metalake, change);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        this.printInformation(this.metalake + " property set.");
    }

    @Override
    public Command validate() {
        this.validatePropertyAndValue(this.property, this.value);
        return this;
    }
}

