/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.Catalog;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.MetadataObjects;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.FullName;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;

public class MetadataCommand
extends Command {
    public MetadataCommand(CommandContext context) {
        super(context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected MetadataObject constructMetadataObject(FullName entity, GravitinoClient client) {
        String name = entity.getName();
        if (entity.hasColumnName()) {
            return MetadataObjects.of(null, name, MetadataObject.Type.COLUMN);
        }
        if (entity.hasTableName()) {
            Catalog catalog = client.loadCatalog(entity.getCatalogName());
            Catalog.Type catalogType = catalog.type();
            if (catalogType == Catalog.Type.RELATIONAL) {
                return MetadataObjects.of(null, name, MetadataObject.Type.TABLE);
            }
            if (catalogType == Catalog.Type.MESSAGING) {
                return MetadataObjects.of(null, name, MetadataObject.Type.TOPIC);
            }
            if (catalogType != Catalog.Type.FILESET) throw new IllegalArgumentException("Unknown entity type: " + name);
            return MetadataObjects.of(null, name, MetadataObject.Type.FILESET);
        }
        if (entity.hasSchemaName()) {
            return MetadataObjects.of(null, name, MetadataObject.Type.SCHEMA);
        }
        if (entity.hasCatalogName()) {
            return MetadataObjects.of(null, name, MetadataObject.Type.CATALOG);
        }
        if (entity.getMetalakeName() == null) throw new IllegalArgumentException("Unknown entity type: " + name);
        return MetadataObjects.of(null, name, MetadataObject.Type.METALAKE);
    }

    @Override
    public void handle() {
    }
}

