/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.CommandHandler;
import org.apache.gravitino.cli.FullName;
import org.apache.gravitino.cli.GravitinoCommandLine;
import org.apache.gravitino.cli.Main;
import org.apache.gravitino.cli.commands.Command;

public class SchemaCommandHandler
extends CommandHandler {
    private final GravitinoCommandLine gravitinoCommandLine;
    private final CommandLine line;
    private final String command;
    private final CommandContext context;
    private final FullName name;
    private final String metalake;
    private final String catalog;
    private String schema;

    public SchemaCommandHandler(GravitinoCommandLine gravitinoCommandLine, CommandLine line, String command, CommandContext context) {
        this.gravitinoCommandLine = gravitinoCommandLine;
        this.line = line;
        this.command = command;
        this.context = context;
        this.name = new FullName(line);
        this.metalake = this.name.getMetalakeName();
        this.catalog = this.name.getCatalogName();
    }

    @Override
    protected void handle() {
        String userName = this.line.getOptionValue("login");
        Command.setAuthenticationMode(this.context.auth(), userName);
        ArrayList<String> missingEntities = Lists.newArrayList();
        if (this.metalake == null) {
            missingEntities.add("metalake");
        }
        if (this.catalog == null) {
            missingEntities.add("catalog");
        }
        if ("list".equals(this.command)) {
            this.checkEntities(missingEntities);
            this.handleListCommand();
            return;
        }
        this.schema = this.name.getSchemaName();
        if (this.schema == null) {
            missingEntities.add("schema");
        }
        this.checkEntities(missingEntities);
        if (!this.executeCommand()) {
            System.err.println("Unsupported or unknown command.");
            Main.exit(-1);
        }
    }

    private boolean executeCommand() {
        switch (this.command) {
            case "details": {
                this.handleDetailsCommand();
                return true;
            }
            case "create": {
                this.handleCreateCommand();
                return true;
            }
            case "delete": {
                this.handleDeleteCommand();
                return true;
            }
            case "set": {
                this.handleSetCommand();
                return true;
            }
            case "remove": {
                this.handleRemoveCommand();
                return true;
            }
            case "properties": {
                this.handlePropertiesCommand();
                return true;
            }
        }
        return false;
    }

    private void handleListCommand() {
        this.gravitinoCommandLine.newListSchema(this.context, this.metalake, this.catalog).validate().handle();
    }

    private void handleDetailsCommand() {
        if (this.line.hasOption("audit")) {
            this.gravitinoCommandLine.newSchemaAudit(this.context, this.metalake, this.catalog, this.schema).validate().handle();
        } else {
            this.gravitinoCommandLine.newSchemaDetails(this.context, this.metalake, this.catalog, this.schema).validate().handle();
        }
    }

    private void handleCreateCommand() {
        String comment = this.line.getOptionValue("comment");
        this.gravitinoCommandLine.newCreateSchema(this.context, this.metalake, this.catalog, this.schema, comment).validate().handle();
    }

    private void handleDeleteCommand() {
        this.gravitinoCommandLine.newDeleteSchema(this.context, this.metalake, this.catalog, this.schema).validate().handle();
    }

    private void handleSetCommand() {
        String property = this.line.getOptionValue("property");
        String value = this.line.getOptionValue("value");
        this.gravitinoCommandLine.newSetSchemaProperty(this.context, this.metalake, this.catalog, this.schema, property, value).validate().handle();
    }

    private void handleRemoveCommand() {
        String property = this.line.getOptionValue("property");
        this.gravitinoCommandLine.newRemoveSchemaProperty(this.context, this.metalake, this.catalog, this.schema, property).validate().handle();
    }

    private void handlePropertiesCommand() {
        this.gravitinoCommandLine.newListSchemaProperties(this.context, this.metalake, this.catalog, this.schema).validate().handle();
    }
}

