/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class Properties {
    private Pattern delimiterPattern;
    private Pattern keyValueSeparatorPattern;

    public Properties() {
        this.delimiterPattern = Pattern.compile(",");
        this.keyValueSeparatorPattern = Pattern.compile("=");
    }

    public Properties(String delimiter, String keyValueSeparator) {
        Preconditions.checkArgument(delimiter != null && !delimiter.isEmpty(), "delimiter cannot be null or empty");
        Preconditions.checkArgument(keyValueSeparator != null && !keyValueSeparator.isEmpty(), "keyValueSeparator cannot be null or empty");
        this.delimiterPattern = Pattern.compile(Pattern.quote(delimiter));
        this.keyValueSeparatorPattern = Pattern.compile(Pattern.quote(keyValueSeparator));
    }

    public Map<String, String> parse(String[] inputs) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (inputs != null) {
            for (String input : inputs) {
                String[] pairs;
                if (input == null || input.isEmpty()) continue;
                for (String pair : pairs = this.delimiterPattern.split(input)) {
                    String[] keyValue;
                    if (pair.isEmpty() || (keyValue = this.keyValueSeparatorPattern.split(pair, 2)).length != 2) continue;
                    map.put(keyValue[0].trim(), keyValue[1].trim());
                }
            }
        }
        return map;
    }
}

