/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.postgresql;

import org.apache.gravitino.storage.relational.mapper.provider.base.TopicMetaBaseSQLProvider;
import org.apache.gravitino.storage.relational.po.TopicPO;
import org.apache.ibatis.annotations.Param;

public class TopicMetaPostgreSQLProvider
extends TopicMetaBaseSQLProvider {
    @Override
    public String updateTopicMeta(@Param(value="newTopicMeta") TopicPO newTopicPO, @Param(value="oldTopicMeta") TopicPO oldTopicPO) {
        return "UPDATE topic_meta SET topic_name = #{newTopicMeta.topicName}, metalake_id = #{newTopicMeta.metalakeId}, catalog_id = #{newTopicMeta.catalogId}, schema_id = #{newTopicMeta.schemaId}, comment = #{newTopicMeta.comment}, properties = #{newTopicMeta.properties}, audit_info = #{newTopicMeta.auditInfo}, current_version = #{newTopicMeta.currentVersion}, last_version = #{newTopicMeta.lastVersion}, deleted_at = #{newTopicMeta.deletedAt} WHERE topic_id = #{oldTopicMeta.topicId} AND topic_name = #{oldTopicMeta.topicName} AND metalake_id = #{oldTopicMeta.metalakeId} AND catalog_id = #{oldTopicMeta.catalogId} AND schema_id = #{oldTopicMeta.schemaId} AND (comment = #{oldTopicMeta.comment}   OR (CAST(comment AS VARCHAR) IS NULL   AND CAST(#{oldTopicMeta.comment} AS VARCHAR) IS NULL)) AND properties = #{oldTopicMeta.properties} AND audit_info = #{oldTopicMeta.auditInfo} AND current_version = #{oldTopicMeta.currentVersion} AND last_version = #{oldTopicMeta.lastVersion} AND deleted_at = 0";
    }

    @Override
    public String softDeleteTopicMetasByTopicId(Long topicId) {
        return "UPDATE topic_meta SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) WHERE topic_id = #{topicId} AND deleted_at = 0";
    }

    @Override
    public String softDeleteTopicMetasByCatalogId(Long catalogId) {
        return "UPDATE topic_meta SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) WHERE catalog_id = #{catalogId} AND deleted_at = 0";
    }

    @Override
    public String softDeleteTopicMetasByMetalakeId(Long metalakeId) {
        return "UPDATE topic_meta SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) WHERE metalake_id = #{metalakeId} AND deleted_at = 0";
    }

    @Override
    public String softDeleteTopicMetasBySchemaId(Long schemaId) {
        return "UPDATE topic_meta SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) WHERE schema_id = #{schemaId} AND deleted_at = 0";
    }

    @Override
    public String insertTopicMetaOnDuplicateKeyUpdate(TopicPO topicPO) {
        return "INSERT INTO topic_meta (topic_id, topic_name, metalake_id, catalog_id, schema_id, comment, properties, audit_info, current_version, last_version, deleted_at) VALUES ( #{topicMeta.topicId}, #{topicMeta.topicName}, #{topicMeta.metalakeId}, #{topicMeta.catalogId}, #{topicMeta.schemaId}, #{topicMeta.comment}, #{topicMeta.properties}, #{topicMeta.auditInfo}, #{topicMeta.currentVersion}, #{topicMeta.lastVersion}, #{topicMeta.deletedAt} ) ON CONFLICT (topic_id) DO UPDATE SET topic_name = #{topicMeta.topicName}, metalake_id = #{topicMeta.metalakeId}, catalog_id = #{topicMeta.catalogId}, schema_id = #{topicMeta.schemaId}, comment = #{topicMeta.comment}, properties = #{topicMeta.properties}, audit_info = #{topicMeta.auditInfo}, current_version = #{topicMeta.currentVersion}, last_version = #{topicMeta.lastVersion}, deleted_at = #{topicMeta.deletedAt}";
    }

    @Override
    public String deleteTopicMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return "DELETE FROM topic_meta WHERE topic_id IN (SELECT topic_id FROM topic_meta WHERE deleted_at != 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit})";
    }
}

