/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.operation;

import com.lancedb.lance.shaded.guava.base.MoreObjects;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;

public class RewrittenIndex {
    private final UUID oldId;
    private final UUID newId;
    private final String newIndexDetailsTypeUrl;
    private final byte[] newIndexDetailsValue;
    private final int newIndexVersion;

    private RewrittenIndex(UUID oldId, UUID newId, String newIndexDetailsTypeUrl, byte[] newIndexDetailsValue, int newIndexVersion) {
        if (oldId == null || newId == null || newIndexDetailsTypeUrl == null || newIndexDetailsValue == null || newIndexVersion < 0) {
            throw new IllegalArgumentException("oldId, newId, newIndexDetailsTypeUrl, and newIndexDetailsValue cannot be null");
        }
        this.oldId = oldId;
        this.newId = newId;
        this.newIndexDetailsTypeUrl = newIndexDetailsTypeUrl;
        this.newIndexDetailsValue = newIndexDetailsValue;
        this.newIndexVersion = newIndexVersion;
    }

    public UUID getOldId() {
        return this.oldId;
    }

    public UUID getNewId() {
        return this.newId;
    }

    public String getNewIndexDetailsTypeUrl() {
        return this.newIndexDetailsTypeUrl;
    }

    public byte[] getNewIndexDetailsValue() {
        return this.newIndexDetailsValue;
    }

    public int getNewIndexVersion() {
        return this.newIndexVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RewrittenIndex that = (RewrittenIndex)o;
        return Objects.equals(this.oldId, that.oldId) && Objects.equals(this.newId, that.newId) && Objects.equals(this.newIndexDetailsTypeUrl, that.newIndexDetailsTypeUrl) && Arrays.equals(this.newIndexDetailsValue, that.newIndexDetailsValue) && this.newIndexVersion == that.newIndexVersion;
    }

    public int hashCode() {
        return Objects.hash(this.oldId, this.newId, this.newIndexDetailsTypeUrl, Arrays.hashCode(this.newIndexDetailsValue), this.newIndexVersion);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("oldId", this.oldId).add("newId", this.newId).add("newIndexDetailsTypeUrl", this.newIndexDetailsTypeUrl).add("newIndexDetailsValue", this.newIndexDetailsValue).add("newIndexVersion", this.newIndexVersion).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private UUID oldId;
        private UUID newId;
        private String newIndexDetailsTypeUrl;
        private byte[] newIndexDetailsValue;
        private int newIndexVersion;

        private Builder() {
        }

        public Builder oldId(UUID oldId) {
            this.oldId = oldId;
            return this;
        }

        public Builder newId(UUID newId) {
            this.newId = newId;
            return this;
        }

        public Builder newIndexDetailsTypeUrl(String newIndexDetailsTypeUrl) {
            this.newIndexDetailsTypeUrl = newIndexDetailsTypeUrl;
            return this;
        }

        public Builder newIndexDetailsValue(byte[] newIndexDetailsValue) {
            this.newIndexDetailsValue = newIndexDetailsValue;
            return this;
        }

        public Builder newIndexVersion(int newIndexVersion) {
            this.newIndexVersion = newIndexVersion;
            return this;
        }

        public RewrittenIndex build() {
            return new RewrittenIndex(this.oldId, this.newId, this.newIndexDetailsTypeUrl, this.newIndexDetailsValue, this.newIndexVersion);
        }
    }
}

