/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance;

import com.lancedb.lance.Dataset;
import com.lancedb.lance.ReadOptions;
import com.lancedb.lance.namespace.LanceNamespace;
import com.lancedb.lance.namespace.LanceNamespaceStorageOptionsProvider;
import com.lancedb.lance.namespace.model.DescribeTableRequest;
import com.lancedb.lance.namespace.model.DescribeTableResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.Preconditions;

public class OpenDatasetBuilder {
    private BufferAllocator allocator;
    private boolean selfManagedAllocator = false;
    private String uri;
    private LanceNamespace namespace;
    private List<String> tableId;
    private ReadOptions options = new ReadOptions.Builder().build();
    private boolean ignoreNamespaceTableStorageOptions = false;

    OpenDatasetBuilder() {
    }

    public OpenDatasetBuilder allocator(BufferAllocator allocator) {
        Preconditions.checkNotNull((Object)allocator);
        this.allocator = allocator;
        this.selfManagedAllocator = false;
        return this;
    }

    public OpenDatasetBuilder uri(String uri) {
        this.uri = uri;
        return this;
    }

    public OpenDatasetBuilder namespace(LanceNamespace namespace) {
        this.namespace = namespace;
        return this;
    }

    public OpenDatasetBuilder tableId(List<String> tableId) {
        this.tableId = tableId;
        return this;
    }

    public OpenDatasetBuilder readOptions(ReadOptions options) {
        this.options = options;
        return this;
    }

    public OpenDatasetBuilder ignoreNamespaceTableStorageOptions(boolean ignoreNamespaceTableStorageOptions) {
        this.ignoreNamespaceTableStorageOptions = ignoreNamespaceTableStorageOptions;
        return this;
    }

    public Dataset build() {
        boolean hasNamespace;
        boolean hasUri = this.uri != null;
        boolean bl = hasNamespace = this.namespace != null && this.tableId != null;
        if (hasUri && hasNamespace) {
            throw new IllegalArgumentException("Cannot specify both uri and namespace+tableId. Use one or the other.");
        }
        if (!hasUri && !hasNamespace) {
            if (this.namespace != null) {
                throw new IllegalArgumentException("namespace is set but tableId is missing. Both namespace and tableId must be provided together.");
            }
            if (this.tableId != null) {
                throw new IllegalArgumentException("tableId is set but namespace is missing. Both namespace and tableId must be provided together.");
            }
            throw new IllegalArgumentException("Either uri or namespace+tableId must be provided.");
        }
        Preconditions.checkNotNull((Object)this.options, (Object)"options must be set");
        if (this.allocator == null) {
            this.allocator = new RootAllocator(Long.MAX_VALUE);
            this.selfManagedAllocator = true;
        }
        if (hasNamespace) {
            return this.buildFromNamespace();
        }
        return Dataset.open(this.allocator, this.selfManagedAllocator, this.uri, this.options);
    }

    private Dataset buildFromNamespace() {
        DescribeTableRequest request = new DescribeTableRequest();
        request.setId(this.tableId);
        this.options.getVersion().ifPresent(v -> request.setVersion(Long.valueOf(v.intValue())));
        DescribeTableResponse response = this.namespace.describeTable(request);
        String location = response.getLocation();
        if (location == null || location.isEmpty()) {
            throw new IllegalArgumentException("Namespace did not return a table location");
        }
        Map namespaceStorageOptions = this.ignoreNamespaceTableStorageOptions ? null : response.getStorageOptions();
        ReadOptions.Builder optionsBuilder = new ReadOptions.Builder().setIndexCacheSizeBytes(this.options.getIndexCacheSizeBytes()).setMetadataCacheSizeBytes(this.options.getMetadataCacheSizeBytes());
        if (namespaceStorageOptions != null && !namespaceStorageOptions.isEmpty()) {
            LanceNamespaceStorageOptionsProvider storageOptionsProvider = new LanceNamespaceStorageOptionsProvider(this.namespace, this.tableId);
            optionsBuilder.setStorageOptionsProvider(storageOptionsProvider);
        }
        this.options.getVersion().ifPresent(optionsBuilder::setVersion);
        this.options.getBlockSize().ifPresent(optionsBuilder::setBlockSize);
        this.options.getSerializedManifest().ifPresent(optionsBuilder::setSerializedManifest);
        this.options.getS3CredentialsRefreshOffsetSeconds().ifPresent(optionsBuilder::setS3CredentialsRefreshOffsetSeconds);
        HashMap<String, String> storageOptions = new HashMap<String, String>(this.options.getStorageOptions());
        if (namespaceStorageOptions != null) {
            storageOptions.putAll(namespaceStorageOptions);
        }
        optionsBuilder.setStorageOptions(storageOptions);
        return Dataset.open(this.allocator, this.selfManagedAllocator, location, optionsBuilder.build());
    }
}

