/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.service;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import org.apache.iceberg.rest.RESTSerializers;

public class IcebergObjectMapper {
    private static final ObjectMapper objectMapper = IcebergObjectMapper.createIcebergObjectMapper();

    private IcebergObjectMapper() {
    }

    private static ObjectMapper createIcebergObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setPropertyNamingStrategy((PropertyNamingStrategy)new PropertyNamingStrategies.KebabCaseStrategy());
        RESTSerializers.registerAll((ObjectMapper)mapper);
        return mapper;
    }

    public static ObjectMapper getInstance() {
        return objectMapper;
    }
}

