/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.starrocks.converter;

import org.apache.gravitino.catalog.jdbc.converter.JdbcTypeConverter;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.rel.types.Types;

public class StarRocksTypeConverter
extends JdbcTypeConverter {
    static final String BIGINT = "bigint";
    static final String BOOLEAN = "boolean";
    static final String DECIMAL = "decimal";
    static final String DOUBLE = "double";
    static final String FLOAT = "float";
    static final String INT = "int";
    static final String LARGEINT = "largeint";
    static final String SMALLINT = "smallint";
    static final String TINYINT = "tinyint";
    static final String BINARY = "binary";
    static final String VARBINARY = "varbinary";
    static final String CHAR = "char";
    static final String STRING = "string";
    static final String VARCHAR = "varchar";
    static final String DATE = "date";
    static final String DATETIME = "datetime";
    static final String ARRAY = "array";
    static final String JSON = "json";
    static final String MAP = "map";
    static final String STRUCT = "struct";
    static final String BITMAP = "bitmap";
    static final String HLL = "hll";
    static final String BIT = "BIT";

    public Type toGravitino(JdbcTypeConverter.JdbcTypeBean typeBean) {
        switch (typeBean.getTypeName().toLowerCase()) {
            case "bigint": {
                return Types.LongType.get();
            }
            case "boolean": {
                return Types.BooleanType.get();
            }
            case "decimal": {
                return Types.DecimalType.of((int)typeBean.getColumnSize(), (int)typeBean.getScale());
            }
            case "double": {
                return Types.DoubleType.get();
            }
            case "float": {
                return Types.FloatType.get();
            }
            case "int": {
                return Types.IntegerType.get();
            }
            case "smallint": {
                return Types.ShortType.get();
            }
            case "tinyint": {
                return Types.ByteType.get();
            }
            case "binary": 
            case "varbinary": {
                return Types.BinaryType.get();
            }
            case "char": {
                return Types.FixedCharType.of((int)typeBean.getColumnSize());
            }
            case "string": {
                return Types.StringType.get();
            }
            case "varchar": {
                if (typeBean.getColumnSize() == 65533) {
                    return Types.StringType.get();
                }
                return Types.VarCharType.of((int)typeBean.getColumnSize());
            }
            case "date": {
                return Types.DateType.get();
            }
            case "datetime": {
                return Types.TimestampType.withoutTimeZone();
            }
        }
        if (typeBean.getTypeName().equals(BIT) && typeBean.getColumnSize() == 1 && typeBean.getScale() == 0) {
            return Types.BooleanType.get();
        }
        return Types.ExternalType.of((String)typeBean.getTypeName());
    }

    public String fromGravitino(Type type) {
        if (type instanceof Types.LongType) {
            return BIGINT;
        }
        if (type instanceof Types.BooleanType) {
            return BOOLEAN;
        }
        if (type instanceof Types.DecimalType) {
            return "decimal(" + ((Types.DecimalType)type).precision() + "," + ((Types.DecimalType)type).scale() + ")";
        }
        if (type instanceof Types.DoubleType) {
            return DOUBLE;
        }
        if (type instanceof Types.FloatType) {
            return FLOAT;
        }
        if (type instanceof Types.IntegerType) {
            return INT;
        }
        if (type instanceof Types.ShortType) {
            return SMALLINT;
        }
        if (type instanceof Types.ByteType) {
            return TINYINT;
        }
        if (type instanceof Types.BinaryType) {
            return BINARY;
        }
        if (type instanceof Types.FixedCharType) {
            int length = ((Types.FixedCharType)type).length();
            if (length < 1 || length > 255) {
                throw new IllegalArgumentException(String.format("Type %s is invalid, length should be between 1 and 255", type.simpleString()));
            }
            return "char(" + ((Types.FixedCharType)type).length() + ")";
        }
        if (type instanceof Types.StringType) {
            return STRING;
        }
        if (type instanceof Types.VarCharType) {
            int length = ((Types.VarCharType)type).length();
            if (length < 1 || length > 0x100000) {
                throw new IllegalArgumentException(String.format("Type %s is invalid, length should be between 1 and 1048576", type.simpleString()));
            }
            return "varchar(" + ((Types.VarCharType)type).length() + ")";
        }
        if (type instanceof Types.DateType) {
            return DATE;
        }
        if (type instanceof Types.TimestampType) {
            return DATETIME;
        }
        throw new IllegalArgumentException(String.format("Couldn't convert Gravitino type %s to StarRocks type", type.simpleString()));
    }
}

