/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.service;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.gravitino.Entity;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.meta.ModelEntity;
import org.apache.gravitino.meta.ModelVersionEntity;
import org.apache.gravitino.metrics.MethodMonitorAspect;
import org.apache.gravitino.metrics.Monitored;
import org.apache.gravitino.metrics.source.MetricsSource;
import org.apache.gravitino.storage.relational.mapper.ModelMetaMapper;
import org.apache.gravitino.storage.relational.mapper.ModelVersionAliasRelMapper;
import org.apache.gravitino.storage.relational.mapper.ModelVersionMetaMapper;
import org.apache.gravitino.storage.relational.po.ModelVersionAliasRelPO;
import org.apache.gravitino.storage.relational.po.ModelVersionPO;
import org.apache.gravitino.storage.relational.service.EntityIdService;
import org.apache.gravitino.storage.relational.service.ModelMetaService;
import org.apache.gravitino.storage.relational.utils.ExceptionUtils;
import org.apache.gravitino.storage.relational.utils.POConverters;
import org.apache.gravitino.storage.relational.utils.SessionUtils;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.NamespaceUtil;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class ModelVersionMetaService {
    private static final ModelVersionMetaService INSTANCE;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ Annotation ajc$anno$5;

    public static ModelVersionMetaService getInstance() {
        return INSTANCE;
    }

    private ModelVersionMetaService() {
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="listModelVersionsByNamespace")
    public List<ModelVersionEntity> listModelVersionsByNamespace(Namespace ns) {
        Namespace namespace = ns;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)namespace);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = ModelVersionMetaService.class.getDeclaredMethod("listModelVersionsByNamespace", Namespace.class).getAnnotation(Monitored.class);
        }
        return (List)ModelVersionMetaService.listModelVersionsByNamespace_aroundBody1$advice(this, namespace, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getModelVersionByIdentifier")
    public ModelVersionEntity getModelVersionByIdentifier(NameIdentifier ident) {
        NameIdentifier nameIdentifier = ident;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)nameIdentifier);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = ModelVersionMetaService.class.getDeclaredMethod("getModelVersionByIdentifier", NameIdentifier.class).getAnnotation(Monitored.class);
        }
        return (ModelVersionEntity)ModelVersionMetaService.getModelVersionByIdentifier_aroundBody3$advice(this, nameIdentifier, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="insertModelVersion")
    public void insertModelVersion(ModelVersionEntity modelVersionEntity) throws IOException {
        ModelVersionEntity modelVersionEntity2 = modelVersionEntity;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)modelVersionEntity2);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = ModelVersionMetaService.class.getDeclaredMethod("insertModelVersion", ModelVersionEntity.class).getAnnotation(Monitored.class);
        }
        ModelVersionMetaService.insertModelVersion_aroundBody5$advice(this, modelVersionEntity2, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="deleteModelVersion")
    public boolean deleteModelVersion(NameIdentifier ident) {
        NameIdentifier nameIdentifier = ident;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)nameIdentifier);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = ModelVersionMetaService.class.getDeclaredMethod("deleteModelVersion", NameIdentifier.class).getAnnotation(Monitored.class);
        }
        return Conversions.booleanValue((Object)ModelVersionMetaService.deleteModelVersion_aroundBody7$advice(this, nameIdentifier, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation));
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="deleteModelVersionMetasByLegacyTimeline")
    public int deleteModelVersionMetasByLegacyTimeline(Long legacyTimeline, int limit) {
        Long l = legacyTimeline;
        int n = limit;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)l, (Object)Conversions.intObject((int)n));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = ModelVersionMetaService.class.getDeclaredMethod("deleteModelVersionMetasByLegacyTimeline", Long.class, Integer.TYPE).getAnnotation(Monitored.class);
        }
        return Conversions.intValue((Object)ModelVersionMetaService.deleteModelVersionMetasByLegacyTimeline_aroundBody9$advice(this, l, n, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation));
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="updateModelVersion")
    public <E extends Entity & HasIdentifier> ModelVersionEntity updateModelVersion(NameIdentifier ident, Function<E, E> updater) throws IOException {
        NameIdentifier nameIdentifier = ident;
        Function<E, E> function = updater;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)nameIdentifier, function);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = ModelVersionMetaService.class.getDeclaredMethod("updateModelVersion", NameIdentifier.class, Function.class).getAnnotation(Monitored.class);
        }
        return (ModelVersionEntity)ModelVersionMetaService.updateModelVersion_aroundBody11$advice(this, nameIdentifier, function, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    private boolean isModelVersionAliasUpdated(ModelVersionEntity oldModelVersionEntity, ModelVersionEntity newModelVersionEntity) {
        List<String> oldAliases = oldModelVersionEntity.aliases();
        List<String> newAliases = newModelVersionEntity.aliases();
        if (oldAliases.size() != newAliases.size()) {
            return true;
        }
        return !oldAliases.equals(newAliases);
    }

    private boolean isModelVersionUriUpdated(ModelVersionEntity oldModelVersionEntity, ModelVersionEntity newModelVersionEntity) {
        Map<String, String> newUris;
        Map<String, String> oldUris = oldModelVersionEntity.uris();
        return !oldUris.equals(newUris = newModelVersionEntity.uris());
    }

    private static /* synthetic */ ModelVersionEntity lambda$listModelVersionsByNamespace$3(Multimap aliasRelPOsByModelVersion, NameIdentifier modelIdent, List m) {
        ArrayList versionAliasRelPOs = Lists.newArrayList((Iterable)aliasRelPOsByModelVersion.get((Object)((ModelVersionPO)m.get(0)).getModelVersion()));
        return POConverters.fromModelVersionPO(modelIdent, m, versionAliasRelPOs);
    }

    private static /* synthetic */ void lambda$listModelVersionsByNamespace$2(Multimap aliasRelPOsByModelVersion, ModelVersionAliasRelPO r) {
        aliasRelPOsByModelVersion.put((Object)r.getModelVersion(), (Object)r);
    }

    static {
        ModelVersionMetaService.ajc$preClinit();
        INSTANCE = new ModelVersionMetaService();
    }

    private static final /* synthetic */ List listModelVersionsByNamespace_aroundBody0(ModelVersionMetaService ajc$this, Namespace ns, JoinPoint joinPoint) {
        NamespaceUtil.checkModelVersion(ns);
        NameIdentifier modelIdent = NameIdentifier.of((String[])ns.levels());
        ModelEntity modelEntity = ModelMetaService.getInstance().getModelByIdentifier(modelIdent);
        List modelVersionPOs = SessionUtils.getWithoutCommit(ModelVersionMetaMapper.class, mapper -> mapper.listModelVersionMetasByModelId(modelEntity.id()));
        if (modelVersionPOs.isEmpty()) {
            return Collections.emptyList();
        }
        List aliasRelPOs = SessionUtils.getWithoutCommit(ModelVersionAliasRelMapper.class, mapper -> mapper.selectModelVersionAliasRelsByModelId(modelEntity.id()));
        ArrayListMultimap aliasRelPOsByModelVersion = ArrayListMultimap.create();
        aliasRelPOs.forEach(arg_0 -> ModelVersionMetaService.lambda$listModelVersionsByNamespace$2((Multimap)aliasRelPOsByModelVersion, arg_0));
        return ImmutableList.copyOf(modelVersionPOs.stream().collect(Collectors.groupingBy(ModelVersionPO::getModelVersion, Collectors.collectingAndThen(Collectors.toList(), arg_0 -> ModelVersionMetaService.lambda$listModelVersionsByNamespace$3((Multimap)aliasRelPOsByModelVersion, modelIdent, arg_0)))).values());
    }

    private static final /* synthetic */ Object listModelVersionsByNamespace_aroundBody1$advice(ModelVersionMetaService ajc$this, Namespace ns, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        List list;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return ModelVersionMetaService.listModelVersionsByNamespace_aroundBody0(ajc$this, ns, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return ModelVersionMetaService.listModelVersionsByNamespace_aroundBody0(ajc$this, ns, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                List result = ModelVersionMetaService.listModelVersionsByNamespace_aroundBody0(ajc$this, ns, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                list = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return list;
    }

    private static final /* synthetic */ ModelVersionEntity getModelVersionByIdentifier_aroundBody2(ModelVersionMetaService ajc$this, NameIdentifier ident, JoinPoint joinPoint) {
        NameIdentifierUtil.checkModelVersion(ident);
        NameIdentifier modelIdent = NameIdentifier.of((String[])ident.namespace().levels());
        ModelEntity modelEntity = ModelMetaService.getInstance().getModelByIdentifier(modelIdent);
        boolean isVersionNumber = NumberUtils.isCreatable((String)ident.name());
        List modelVersionPOs = SessionUtils.getWithoutCommit(ModelVersionMetaMapper.class, mapper -> {
            if (isVersionNumber) {
                return mapper.selectModelVersionMeta(modelEntity.id(), Integer.valueOf(ident.name()));
            }
            return mapper.selectModelVersionMetaByAlias(modelEntity.id(), ident.name());
        });
        if (modelVersionPOs.isEmpty()) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.MODEL_VERSION.name().toLowerCase(Locale.ROOT), ident.toString()});
        }
        List aliasRelPOs = SessionUtils.getWithoutCommit(ModelVersionAliasRelMapper.class, mapper -> {
            if (isVersionNumber) {
                return mapper.selectModelVersionAliasRelsByModelIdAndVersion(modelEntity.id(), Integer.valueOf(ident.name()));
            }
            return mapper.selectModelVersionAliasRelsByModelIdAndAlias(modelEntity.id(), ident.name());
        });
        return POConverters.fromModelVersionPO(modelIdent, modelVersionPOs, aliasRelPOs);
    }

    private static final /* synthetic */ Object getModelVersionByIdentifier_aroundBody3$advice(ModelVersionMetaService ajc$this, NameIdentifier ident, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        ModelVersionEntity modelVersionEntity;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return ModelVersionMetaService.getModelVersionByIdentifier_aroundBody2(ajc$this, ident, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return ModelVersionMetaService.getModelVersionByIdentifier_aroundBody2(ajc$this, ident, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                ModelVersionEntity result = ModelVersionMetaService.getModelVersionByIdentifier_aroundBody2(ajc$this, ident, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                modelVersionEntity = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return modelVersionEntity;
    }

    private static final /* synthetic */ void insertModelVersion_aroundBody4(ModelVersionMetaService ajc$this, ModelVersionEntity modelVersionEntity, JoinPoint joinPoint) {
        NameIdentifier modelIdent = modelVersionEntity.modelIdentifier();
        NameIdentifierUtil.checkModel(modelIdent);
        Long modelId = EntityIdService.getEntityId(modelIdent, Entity.EntityType.MODEL);
        List<ModelVersionPO> modelVersionPOs = POConverters.initializeModelVersionPO(modelVersionEntity, modelId);
        List<ModelVersionAliasRelPO> aliasRelPOs = POConverters.initializeModelVersionAliasRelPO(modelVersionEntity, modelId);
        try {
            SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(ModelVersionMetaMapper.class, mapper -> mapper.insertModelVersionMetas(modelVersionPOs)), () -> {
                if (aliasRelPOs.isEmpty()) {
                    return;
                }
                SessionUtils.doWithoutCommit(ModelVersionAliasRelMapper.class, mapper -> mapper.insertModelVersionAliasRels(aliasRelPOs));
            }, () -> SessionUtils.doWithoutCommit(ModelMetaMapper.class, mapper -> mapper.updateModelLatestVersion(modelId)));
        }
        catch (RuntimeException re) {
            ExceptionUtils.checkSQLException(re, Entity.EntityType.MODEL_VERSION, modelVersionEntity.modelIdentifier().toString());
            throw re;
        }
    }

    private static final /* synthetic */ Object insertModelVersion_aroundBody5$advice(ModelVersionMetaService ajc$this, ModelVersionEntity modelVersionEntity, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object var13_18;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                ModelVersionMetaService.insertModelVersion_aroundBody4(ajc$this, modelVersionEntity, (JoinPoint)proceedingJoinPoint);
                return null;
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                ModelVersionMetaService.insertModelVersion_aroundBody4(ajc$this, modelVersionEntity, (JoinPoint)proceedingJoinPoint);
                return null;
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                ModelVersionMetaService.insertModelVersion_aroundBody4(ajc$this, modelVersionEntity, (JoinPoint)proceedingJoinPoint);
                Object result = null;
                successMeter.mark();
                var13_18 = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return var13_18;
    }

    private static final /* synthetic */ boolean deleteModelVersion_aroundBody6(ModelVersionMetaService ajc$this, NameIdentifier ident, JoinPoint joinPoint) {
        ModelEntity modelEntity;
        NameIdentifierUtil.checkModelVersion(ident);
        NameIdentifier modelIdent = NameIdentifier.of((String[])ident.namespace().levels());
        try {
            modelEntity = ModelMetaService.getInstance().getModelByIdentifier(modelIdent);
        }
        catch (NoSuchEntityException e) {
            return false;
        }
        boolean isVersionNumber = NumberUtils.isCreatable((String)ident.name());
        AtomicInteger modelVersionDeletedCount = new AtomicInteger();
        SessionUtils.doMultipleWithCommit(() -> modelVersionDeletedCount.set(SessionUtils.getWithoutCommit(ModelVersionMetaMapper.class, mapper -> {
            if (isVersionNumber) {
                return mapper.softDeleteModelVersionMetaByModelIdAndVersion(modelEntity.id(), Integer.valueOf(ident.name()));
            }
            return mapper.softDeleteModelVersionMetaByModelIdAndAlias(modelEntity.id(), ident.name());
        })), () -> {
            if (modelVersionDeletedCount.get() == 0) {
                return;
            }
            SessionUtils.doWithoutCommit(ModelVersionAliasRelMapper.class, mapper -> {
                if (isVersionNumber) {
                    mapper.softDeleteModelVersionAliasRelsByModelIdAndVersion(modelEntity.id(), Integer.valueOf(ident.name()));
                } else {
                    mapper.softDeleteModelVersionAliasRelsByModelIdAndAlias(modelEntity.id(), ident.name());
                }
            });
        });
        return modelVersionDeletedCount.get() > 0;
    }

    private static final /* synthetic */ Object deleteModelVersion_aroundBody7$advice(ModelVersionMetaService ajc$this, NameIdentifier ident, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object object;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.booleanObject((boolean)ModelVersionMetaService.deleteModelVersion_aroundBody6(ajc$this, ident, (JoinPoint)proceedingJoinPoint));
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.booleanObject((boolean)ModelVersionMetaService.deleteModelVersion_aroundBody6(ajc$this, ident, (JoinPoint)proceedingJoinPoint));
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Object result = Conversions.booleanObject((boolean)ModelVersionMetaService.deleteModelVersion_aroundBody6(ajc$this, ident, (JoinPoint)proceedingJoinPoint));
                successMeter.mark();
                object = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return object;
    }

    private static final /* synthetic */ int deleteModelVersionMetasByLegacyTimeline_aroundBody8(ModelVersionMetaService ajc$this, Long legacyTimeline, int limit, JoinPoint joinPoint) {
        int[] modelVersionDeletedCount = new int[]{0};
        int[] modelVersionAliasRelDeletedCount = new int[]{0};
        SessionUtils.doMultipleWithCommit(() -> {
            modelVersionDeletedCount[0] = SessionUtils.getWithoutCommit(ModelVersionMetaMapper.class, mapper -> mapper.deleteModelVersionMetasByLegacyTimeline(legacyTimeline, limit));
        }, () -> {
            modelVersionAliasRelDeletedCount[0] = SessionUtils.getWithoutCommit(ModelVersionAliasRelMapper.class, mapper -> mapper.deleteModelVersionAliasRelsByLegacyTimeline(legacyTimeline, limit));
        });
        return modelVersionDeletedCount[0] + modelVersionAliasRelDeletedCount[0];
    }

    private static final /* synthetic */ Object deleteModelVersionMetasByLegacyTimeline_aroundBody9$advice(ModelVersionMetaService ajc$this, Long legacyTimeline, int limit, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object object;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)ModelVersionMetaService.deleteModelVersionMetasByLegacyTimeline_aroundBody8(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)ModelVersionMetaService.deleteModelVersionMetasByLegacyTimeline_aroundBody8(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Object result = Conversions.intObject((int)ModelVersionMetaService.deleteModelVersionMetasByLegacyTimeline_aroundBody8(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
                successMeter.mark();
                object = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return object;
    }

    private static final /* synthetic */ ModelVersionEntity updateModelVersion_aroundBody10(ModelVersionMetaService ajc$this, NameIdentifier ident, Function updater, JoinPoint joinPoint) {
        NameIdentifierUtil.checkModelVersion(ident);
        NameIdentifier modelIdent = NameIdentifier.of((String[])ident.namespace().levels());
        boolean isVersionNumber = NumberUtils.isCreatable((String)ident.name());
        ModelEntity modelEntity = ModelMetaService.getInstance().getModelByIdentifier(modelIdent);
        List oldModelVersionPOs = SessionUtils.getWithoutCommit(ModelVersionMetaMapper.class, mapper -> {
            if (isVersionNumber) {
                return mapper.selectModelVersionMeta(modelEntity.id(), Integer.valueOf(ident.name()));
            }
            return mapper.selectModelVersionMetaByAlias(modelEntity.id(), ident.name());
        });
        if (oldModelVersionPOs.isEmpty()) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.MODEL_VERSION.name().toLowerCase(Locale.ROOT), ident.toString()});
        }
        List oldAliasRelPOs = SessionUtils.getWithoutCommit(ModelVersionAliasRelMapper.class, mapper -> {
            if (isVersionNumber) {
                return mapper.selectModelVersionAliasRelsByModelIdAndVersion(modelEntity.id(), Integer.valueOf(ident.name()));
            }
            return mapper.selectModelVersionAliasRelsByModelIdAndAlias(modelEntity.id(), ident.name());
        });
        ModelVersionEntity oldModelVersionEntity = POConverters.fromModelVersionPO(modelIdent, oldModelVersionPOs, oldAliasRelPOs);
        ModelVersionEntity newModelVersionEntity = (ModelVersionEntity)updater.apply(oldModelVersionEntity);
        Preconditions.checkArgument((boolean)Objects.equals(oldModelVersionEntity.version(), newModelVersionEntity.version()), (String)"The updated model version: %s should be same with the table entity version before: %s", (Object)newModelVersionEntity.version(), (Object)oldModelVersionEntity.version());
        boolean isAliasChanged = ajc$this.isModelVersionAliasUpdated(oldModelVersionEntity, newModelVersionEntity);
        List<ModelVersionAliasRelPO> newAliasRelPOs = POConverters.updateModelVersionAliasRelPO(oldAliasRelPOs, newModelVersionEntity);
        boolean isModelVersionUriUpdated = ajc$this.isModelVersionUriUpdated(oldModelVersionEntity, newModelVersionEntity);
        AtomicInteger updateResult = new AtomicInteger(0);
        try {
            SessionUtils.doMultipleWithCommit(() -> {
                if (isModelVersionUriUpdated) {
                    updateResult.addAndGet(SessionUtils.getWithoutCommit(ModelVersionMetaMapper.class, mapper -> {
                        if (isVersionNumber) {
                            return mapper.softDeleteModelVersionMetaByModelIdAndVersion(modelEntity.id(), Integer.valueOf(ident.name()));
                        }
                        return mapper.softDeleteModelVersionMetaByModelIdAndAlias(modelEntity.id(), ident.name());
                    }));
                    List<ModelVersionPO> modelVersionPOs = POConverters.initializeModelVersionPO(newModelVersionEntity, modelEntity.id());
                    SessionUtils.doWithoutCommit(ModelVersionMetaMapper.class, mapper -> mapper.insertModelVersionMetasWithVersionNumber(modelVersionPOs));
                } else {
                    updateResult.addAndGet(SessionUtils.getWithoutCommit(ModelVersionMetaMapper.class, mapper -> mapper.updateModelVersionMeta(POConverters.updateModelVersionPO((ModelVersionPO)oldModelVersionPOs.get(0), newModelVersionEntity), (ModelVersionPO)oldModelVersionPOs.get(0))));
                }
            }, () -> {
                if (isAliasChanged) {
                    SessionUtils.doWithoutCommit(ModelVersionAliasRelMapper.class, mapper -> oldModelVersionEntity.aliases().forEach(alias -> mapper.softDeleteModelVersionAliasRelsByModelIdAndAlias(modelEntity.id(), (String)alias)));
                    SessionUtils.doWithoutCommit(ModelVersionAliasRelMapper.class, mapper -> mapper.updateModelVersionAliasRel(newAliasRelPOs));
                }
            });
        }
        catch (RuntimeException re) {
            ExceptionUtils.checkSQLException(re, Entity.EntityType.MODEL_VERSION, newModelVersionEntity.nameIdentifier().toString());
            throw re;
        }
        if (updateResult.get() > 0) {
            return newModelVersionEntity;
        }
        throw new IOException("Failed to update the entity: " + String.valueOf(ident));
    }

    private static final /* synthetic */ Object updateModelVersion_aroundBody11$advice(ModelVersionMetaService ajc$this, NameIdentifier ident, Function updater, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        ModelVersionEntity modelVersionEntity;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return ModelVersionMetaService.updateModelVersion_aroundBody10(ajc$this, ident, updater, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return ModelVersionMetaService.updateModelVersion_aroundBody10(ajc$this, ident, updater, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                ModelVersionEntity result = ModelVersionMetaService.updateModelVersion_aroundBody10(ajc$this, ident, updater, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                modelVersionEntity = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return modelVersionEntity;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ModelVersionMetaService.java", ModelVersionMetaService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listModelVersionsByNamespace", "org.apache.gravitino.storage.relational.service.ModelVersionMetaService", "org.apache.gravitino.Namespace", "ns", "", "java.util.List"), 71);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getModelVersionByIdentifier", "org.apache.gravitino.storage.relational.service.ModelVersionMetaService", "org.apache.gravitino.NameIdentifier", "ident", "", "org.apache.gravitino.meta.ModelVersionEntity"), 115);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "insertModelVersion", "org.apache.gravitino.storage.relational.service.ModelVersionMetaService", "org.apache.gravitino.meta.ModelVersionEntity", "modelVersionEntity", "java.io.IOException", "void"), 162);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteModelVersion", "org.apache.gravitino.storage.relational.service.ModelVersionMetaService", "org.apache.gravitino.NameIdentifier", "ident", "", "boolean"), 201);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteModelVersionMetasByLegacyTimeline", "org.apache.gravitino.storage.relational.service.ModelVersionMetaService", "java.lang.Long:int", "legacyTimeline:limit", "", "int"), 256);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateModelVersion", "org.apache.gravitino.storage.relational.service.ModelVersionMetaService", "org.apache.gravitino.NameIdentifier:java.util.function.Function", "ident:updater", "java.io.IOException", "org.apache.gravitino.meta.ModelVersionEntity"), 290);
    }
}

