/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable.primitive;

import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.primitive.CharSets;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.set.primitive.CharSet;
import org.eclipse.collections.api.set.primitive.ImmutableCharSet;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;
import org.eclipse.collections.impl.set.primitive.AbstractCharSet;

public abstract class AbstractImmutableCharSet
extends AbstractCharSet
implements ImmutableCharSet {
    public ImmutableCharSet newWith(char element) {
        return CharHashSet.newSet(this).with(element).toImmutable();
    }

    public ImmutableCharSet newWithout(char element) {
        return CharHashSet.newSet(this).without(element).toImmutable();
    }

    public ImmutableCharSet newWithAll(CharIterable elements) {
        return CharHashSet.newSet(this).withAll(elements).toImmutable();
    }

    public ImmutableCharSet newWithoutAll(CharIterable elements) {
        return CharHashSet.newSet(this).withoutAll(elements).toImmutable();
    }

    public CharSet freeze() {
        return this;
    }

    public ImmutableCharSet toImmutable() {
        return this;
    }

    public RichIterable<CharIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size) {
                result.add((Object)this);
            } else {
                CharIterator iterator = this.charIterator();
                while (iterator.hasNext()) {
                    MutableCharSet batch = CharSets.mutable.empty();
                    for (int i = 0; i < size && iterator.hasNext(); ++i) {
                        batch.add(iterator.next());
                    }
                    result.add((Object)batch.toImmutable());
                }
            }
        }
        return result.toImmutable();
    }
}

