/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table;

import java.util.List;
import java.util.Map;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.partition.PartitionStatistics;

public interface PartitionHandler
extends AutoCloseable {
    public void createPartitions(List<Map<String, String>> var1) throws Catalog.TableNotExistException;

    public void dropPartitions(List<Map<String, String>> var1) throws Catalog.TableNotExistException;

    public void alterPartitions(List<PartitionStatistics> var1) throws Catalog.TableNotExistException;

    public void markDonePartitions(List<Map<String, String>> var1) throws Catalog.TableNotExistException;

    public static PartitionHandler create(final Catalog catalog, final Identifier identifier) {
        return new PartitionHandler(){

            @Override
            public void createPartitions(List<Map<String, String>> partitions) throws Catalog.TableNotExistException {
                catalog.createPartitions(identifier, partitions);
            }

            @Override
            public void dropPartitions(List<Map<String, String>> partitions) throws Catalog.TableNotExistException {
                catalog.dropPartitions(identifier, partitions);
            }

            @Override
            public void alterPartitions(List<PartitionStatistics> partitions) throws Catalog.TableNotExistException {
                catalog.alterPartitions(identifier, partitions);
            }

            @Override
            public void markDonePartitions(List<Map<String, String>> partitions) throws Catalog.TableNotExistException {
                catalog.markDonePartitions(identifier, partitions);
            }

            @Override
            public void close() throws Exception {
                catalog.close();
            }
        };
    }
}

