/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.schema;

import com.lancedb.lance.schema.LanceField;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.arrow.vector.types.pojo.Schema;

public class LanceSchema {
    private final List<LanceField> fields;
    private final Map<String, String> metadata;

    LanceSchema(List<LanceField> fields, Map<String, String> metadata) {
        this.fields = fields;
        this.metadata = metadata;
    }

    public List<LanceField> fields() {
        return this.fields;
    }

    public Map<String, String> metadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public Schema asArrowSchema() {
        return new Schema((Iterable)this.fields.stream().map(LanceField::asArrowField).collect(Collectors.toList()), this.metadata);
    }

    private static class Builder {
        private List<LanceField> fields;
        private Map<String, String> metadata;

        Builder() {
        }

        public Builder withFields(List<LanceField> fields) {
            this.fields = fields;
            return this;
        }

        public Builder withMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public LanceSchema build() {
            return new LanceSchema(this.fields, this.metadata);
        }
    }
}

