/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.operation;

import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class RewrittenIndex {
    private final UUID oldId;
    private final UUID newId;

    private RewrittenIndex(UUID oldId, UUID newId) {
        this.oldId = oldId;
        this.newId = newId;
    }

    public UUID getOldId() {
        return this.oldId;
    }

    public UUID getNewId() {
        return this.newId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RewrittenIndex that = (RewrittenIndex)o;
        return Objects.equals(this.oldId, that.oldId) && Objects.equals(this.newId, that.newId);
    }

    public int hashCode() {
        return Objects.hash(this.oldId, this.newId);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("oldId", (Object)this.oldId).append("newId", (Object)this.newId).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private UUID oldId;
        private UUID newId;

        private Builder() {
        }

        public Builder oldId(UUID oldId) {
            this.oldId = oldId;
            return this;
        }

        public Builder newId(UUID newId) {
            this.newId = newId;
            return this;
        }

        public RewrittenIndex build() {
            return new RewrittenIndex(this.oldId, this.newId);
        }
    }
}

